/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.io;

import java.io.IOException;
import java.util.Objects;

public final class IllegalHeaderException
extends IOException {
    private static final long serialVersionUID = -1266798578155159251L;
    private final String expected;
    private final String got;

    public IllegalHeaderException(String expected, String got) {
        super(String.format("Failed to read a buffer; Illegal header. Expected \"%s\", but \"%s\" was present instead.", Objects.requireNonNull(expected), Objects.requireNonNull(got)));
        this.expected = expected;
        this.got = got;
    }

    public final String getExpected() {
        return this.expected;
    }

    public final String getGot() {
        return this.got;
    }

    public final int hashCode() {
        return Objects.hash(this.expected, this.got);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IllegalHeaderException other = (IllegalHeaderException)obj;
        return Objects.equals(this.expected, other.expected) && Objects.equals(this.got, other.got);
    }
}

