/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import java.awt.geom.Point2D;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class TInputContext {
    private final InputType inputType;
    @Nullable
    private InputKeyboardKey keyboardKey;
    @Nullable
    private Character typedChar;
    @Nullable
    private Integer mouseButton;
    @Nullable
    private Point2D.Double mousePos;
    @Nullable
    private Point2D.Double mouseDelta;
    @Nullable
    private Point2D.Double scrollAmount;

    private TInputContext(InputType inputType) {
        this.inputType = Objects.requireNonNull(inputType);
    }

    public final InputType getInputType() {
        return this.inputType;
    }

    @UsedFor(value={InputType.KEY_PRESS, InputType.KEY_RELEASE})
    @Nullable
    public final InputKeyboardKey getKeyboardKey() {
        return this.keyboardKey;
    }

    @UsedFor(value={InputType.CHAR_TYPE})
    @Nullable
    public final Character getTypedChar() {
        return this.typedChar;
    }

    @UsedFor(value={InputType.MOUSE_PRESS, InputType.MOUSE_RELEASE, InputType.MOUSE_DRAG, InputType.MOUSE_DRAG_END})
    @Nullable
    public final Integer getMouseButton() {
        return this.mouseButton;
    }

    @UsedFor(value={InputType.MOUSE_MOVE, InputType.MOUSE_DRAG, InputType.MOUSE_SCROLL})
    @Nullable
    public final Point2D.Double getMousePosition() {
        return this.mousePos;
    }

    @UsedFor(value={InputType.MOUSE_DRAG})
    @Nullable
    public final Point2D.Double getMouseDelta() {
        return this.mouseDelta;
    }

    @UsedFor(value={InputType.MOUSE_SCROLL})
    @Nullable
    public final Point2D.Double getScrollAmount() {
        return this.scrollAmount;
    }

    public static TInputContext ofKeyboardPR(InputKeyboardKey key, boolean isDown) {
        TInputContext result = new TInputContext(isDown ? InputType.KEY_PRESS : InputType.KEY_RELEASE);
        result.keyboardKey = Objects.requireNonNull(key);
        return result;
    }

    public static TInputContext ofCharType(char character, int modifiers) {
        TInputContext result = new TInputContext(InputType.CHAR_TYPE);
        result.typedChar = Character.valueOf(character);
        result.keyboardKey = new InputKeyboardKey(0, 0, modifiers);
        return result;
    }

    public static TInputContext ofMouseCR(int mouseButton, boolean isDown) {
        TInputContext result = new TInputContext(isDown ? InputType.MOUSE_PRESS : InputType.MOUSE_RELEASE);
        result.mouseButton = mouseButton;
        return result;
    }

    public static TInputContext ofMouseMove(double mouseX, double mouseY) {
        TInputContext result = new TInputContext(InputType.MOUSE_MOVE);
        result.mousePos = new Point2D.Double(mouseX, mouseY);
        return result;
    }

    public static TInputContext ofMouseDrag(double mouseX, double mouseY, double deltaX, double deltaY, int mouseButton) {
        TInputContext result = new TInputContext(InputType.MOUSE_DRAG);
        result.mousePos = new Point2D.Double(mouseX, mouseY);
        result.mouseDelta = new Point2D.Double(deltaX, deltaY);
        result.mouseButton = mouseButton;
        return result;
    }

    public static TInputContext ofMouseDragEnd(int mouseButton) {
        TInputContext result = new TInputContext(InputType.MOUSE_DRAG_END);
        result.mouseButton = mouseButton;
        return result;
    }

    public static TInputContext ofMouseScroll(double mouseX, double mouseY, double vAmount) {
        return TInputContext.ofMouseScroll(mouseX, mouseY, 0.0, vAmount);
    }

    public static TInputContext ofMouseScroll(double mouseX, double mouseY, double hAmount, double vAmount) {
        TInputContext result = new TInputContext(InputType.MOUSE_SCROLL);
        result.mousePos = new Point2D.Double(mouseX, mouseY);
        result.scrollAmount = new Point2D.Double(hAmount, vAmount);
        return result;
    }

    public static enum InputType {
        KEY_PRESS,
        KEY_RELEASE,
        CHAR_TYPE,
        MOUSE_PRESS,
        MOUSE_RELEASE,
        MOUSE_MOVE,
        MOUSE_DRAG,
        MOUSE_DRAG_END,
        MOUSE_SCROLL;


        public boolean isKeyboardRelated() {
            return this == KEY_PRESS || this == KEY_RELEASE || this == CHAR_TYPE;
        }

        public boolean isMouseRelated() {
            return this == MOUSE_PRESS || this == MOUSE_RELEASE || this == MOUSE_MOVE || this == MOUSE_DRAG || this == MOUSE_SCROLL;
        }
    }

    public static final class InputKeyboardKey {
        public final int keyCode;
        public final int scanCode;
        public final int modifiers;

        public InputKeyboardKey(int keyCode, int scanCode) {
            this(keyCode, scanCode, 0);
        }

        public InputKeyboardKey(int keyCode, int scanCode, int modifiers) {
            this.keyCode = keyCode;
            this.scanCode = scanCode;
            this.modifiers = modifiers;
        }

        public final boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InputKeyboardKey key = (InputKeyboardKey)other;
            if (this.keyCode != key.keyCode) {
                return false;
            }
            if (this.scanCode != key.scanCode) {
                return false;
            }
            return this.modifiers == key.modifiers;
        }

        public final int hashCode() {
            int result = this.keyCode;
            result = 31 * result + this.scanCode;
            result = 31 * result + this.modifiers;
            return result;
        }
    }

    public static enum InputDiscoveryPhase {
        BROADCAST,
        PREEMPT,
        MAIN;

    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface UsedFor {
        public InputType[] value();
    }
}

