/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.text.BreakIterator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import snownee.jade.overlay.DisplayHelper;

public class WordCutter {
    private final BreakIterator breakIterator;
    private final TokenClassifier classifier;
    private final List<Token> tokens = Lists.newArrayList();
    private int maxWidth;
    private int widthSum;
    private boolean hasColon;

    public WordCutter(BreakIterator breakIterator, TokenClassifier classifier) {
        this.breakIterator = breakIterator;
        this.classifier = classifier;
    }

    public void setText(String text, int maxWidth) {
        Preconditions.checkArgument((maxWidth > 0 ? 1 : 0) != 0, (Object)"maxWidth must be positive");
        this.maxWidth = maxWidth;
        this.tokens.clear();
        this.widthSum = 0;
        this.hasColon = false;
        this.breakIterator.setText(text);
        int start = this.breakIterator.first();
        int depth = 0;
        int end = this.breakIterator.next();
        while (end != -1) {
            String word = text.substring(start, end);
            TokenType type = this.classifier.classify(word);
            if (type == TokenType.LEFT_BRACKET) {
                ++depth;
            }
            Token token = new Token(word, type, depth, DisplayHelper.font().method_1727(word));
            if (type == TokenType.RIGHT_BRACKET) {
                --depth;
            }
            this.tokens.add(token);
            this.widthSum += token.width;
            this.hasColon |= type == TokenType.COLON;
            start = end;
            end = this.breakIterator.next();
        }
    }

    public int width() {
        return this.widthSum;
    }

    public boolean hasColon() {
        return this.hasColon;
    }

    public boolean tooLong() {
        return this.widthSum > this.maxWidth;
    }

    public @Unmodifiable List<Token> tokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public int tokenCount() {
        return this.tokens.size();
    }

    public void trim() {
        for (int i = 0; i < this.tokens.size() - 1; ++i) {
            Token token = this.tokens.get(i);
            Token next = this.tokens.get(i + 1);
            if (token.type != TokenType.SEPARATOR || next.type != TokenType.SEPARATOR) continue;
            this.widthSum -= next.width;
            this.tokens.remove(i + 1);
            --i;
        }
        if (!this.tokens.isEmpty() && this.tokens.getFirst().type == TokenType.SEPARATOR) {
            this.widthSum -= this.tokens.getFirst().width;
            this.tokens.removeFirst();
        }
        while (!this.tokens.isEmpty()) {
            Token last = this.tokens.getLast();
            if (!last.type.canRemoveTail()) break;
            this.widthSum -= last.width;
            this.tokens.removeLast();
        }
    }

    public void removeBracketed() {
        int start = this.findFirst((Predicate<Token>)((Predicate)token -> token.type == TokenType.LEFT_BRACKET && token.depth == 1));
        if (start == -1) {
            return;
        }
        int end = this.findFirst((Predicate<Token>)((Predicate)token -> token.type == TokenType.RIGHT_BRACKET && token.depth == 1));
        if (end == -1) {
            return;
        }
        if (start == 0 && end == this.tokens.size() - 1) {
            return;
        }
        this.removeRange(start, end + 1);
    }

    public void removeRange(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.widthSum -= this.tokens.get((int)i).width;
        }
        this.tokens.subList(start, end).clear();
    }

    public int findFirst(Predicate<Token> predicate) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (!predicate.test((Object)this.tokens.get(i))) continue;
            return i;
        }
        return -1;
    }

    public String concat(int start, int end) {
        if (start >= end || end > this.tokens.size()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            sb.append(this.tokens.get((int)i).str);
        }
        return sb.toString();
    }

    public String toString() {
        return this.concat(0, this.tokens.size());
    }

    public void cutToMaxWidth(boolean addEllipsis) {
        Object ellipsis;
        Token last;
        if (!this.tooLong()) {
            return;
        }
        do {
            last = this.tokens.removeLast();
            this.widthSum -= last.width;
        } while (this.tooLong());
        Object object = ellipsis = addEllipsis ? "..." : "";
        if (last.type == TokenType.WORD) {
            int expectedWidth;
            int n = expectedWidth = addEllipsis ? Math.max(this.maxWidth - this.widthSum - 5, 0) : this.maxWidth - this.widthSum;
            if (last.width > expectedWidth) {
                ellipsis = DisplayHelper.font().method_27523(last.str, addEllipsis ? Math.max(expectedWidth - 5, 0) : expectedWidth) + (String)ellipsis;
            }
        } else {
            this.trim();
        }
        this.tokens.add(new Token((String)ellipsis, TokenType.SYMBOL, 0, 0));
    }

    public static interface TokenClassifier {
        public TokenType classify(String var1);
    }

    public static enum TokenType implements class_3542
    {
        SEPARATOR,
        WORD,
        LEFT_BRACKET,
        RIGHT_BRACKET,
        SYMBOL,
        COLON;


        boolean canRemoveTail() {
            return this == SEPARATOR || this == SYMBOL || this == COLON;
        }

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public record Token(String str, TokenType type, int depth, int width) {
    }
}

