/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.util;

import dev.ultimatchamp.bettergrass.config.BetterGrassifyConfig;
import dev.ultimatchamp.bettergrass.util.BetterSnowPredicateUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class BetterGrassifyCacheUtils {
    public static List<class_2248> BETTER_SNOW_CACHE = new CopyOnWriteArrayList<class_2248>();
    public static List<Pair<class_2248, String>> EXCLUDED_BLOCKS_CACHE = new CopyOnWriteArrayList<Pair<class_2248, String>>();
    public static List<class_6862<@NotNull class_2248>> EXCLUDED_TAGS_CACHE = new CopyOnWriteArrayList<class_6862<class_2248>>();
    public static List<Pair<class_2248, String>> WHITELISTED_BLOCKS_CACHE = new CopyOnWriteArrayList<Pair<class_2248, String>>();
    public static List<class_6862<@NotNull class_2248>> WHITELISTED_TAGS_CACHE = new CopyOnWriteArrayList<class_6862<class_2248>>();

    public static void reloadCaches() {
        BETTER_SNOW_CACHE.clear();
        WHITELISTED_BLOCKS_CACHE.clear();
        WHITELISTED_TAGS_CACHE.clear();
        EXCLUDED_BLOCKS_CACHE.clear();
        EXCLUDED_TAGS_CACHE.clear();
    }

    public static void initCaches() {
        class_2960 id;
        if (!BETTER_SNOW_CACHE.isEmpty()) {
            return;
        }
        BetterGrassifyConfig config = BetterGrassifyConfig.load();
        for (String identifier : config.betterSnow.snowLayers) {
            id = class_2960.method_12829((String)identifier);
            class_7923.field_41175.method_17966(id).ifPresent(BETTER_SNOW_CACHE::add);
        }
        for (String block : config.betterSnow.whitelistedBlocks) {
            id = class_2960.method_60654((String)BetterSnowPredicateUtils.withoutAttribute(block));
            class_7923.field_41175.method_17966(id).ifPresent(b -> WHITELISTED_BLOCKS_CACHE.add((Pair<class_2248, String>)Pair.of((Object)b, (Object)block)));
        }
        for (String tag : config.betterSnow.whitelistedTags) {
            id = class_2960.method_60654((String)tag);
            WHITELISTED_TAGS_CACHE.add((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id));
        }
        for (String block : config.betterSnow.excludedBlocks) {
            id = class_2960.method_60654((String)BetterSnowPredicateUtils.withoutAttribute(block));
            class_7923.field_41175.method_17966(id).ifPresent(b -> EXCLUDED_BLOCKS_CACHE.add((Pair<class_2248, String>)Pair.of((Object)b, (Object)block)));
        }
        for (String tag : config.betterSnow.excludedTags) {
            id = class_2960.method_60654((String)tag);
            EXCLUDED_TAGS_CACHE.add((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id));
        }
    }
}

