/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.config;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.ultimatchamp.bettergrass.BetterGrassify;
import dev.ultimatchamp.bettergrass.config.NoClothConfigWarning;
import dev.ultimatchamp.bettergrass.config.OptionsScreen;
import dev.ultimatchamp.bettergrass.config.TranslatableOption;
import dev.ultimatchamp.bettergrass.util.BetterGrassifyCacheUtils;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class BetterGrassifyConfig {
    public GeneralConfig general = new GeneralConfig();
    public BetterSnowConfig betterSnow = new BetterSnowConfig();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("bettergrass.json");
    public static BetterGrassifyConfig cachedConfig;

    public static BetterGrassifyConfig load() {
        BetterGrassifyConfig config;
        if (cachedConfig != null) {
            return cachedConfig;
        }
        BetterGrassifyCacheUtils.reloadCaches();
        try {
            if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
                BetterGrassify.LOGGER.info("[{}] Config file not found. Creating a new one...", (Object)"BetterGrassify");
                config = new BetterGrassifyConfig();
                BetterGrassifyConfig.save(config);
            } else {
                String configContent = Files.readString(CONFIG_PATH).trim();
                if (!configContent.startsWith("{") || !configContent.endsWith("}")) {
                    BetterGrassify.LOGGER.warn("[{}] Config file is empty or invalid. Creating a new one...", (Object)"BetterGrassify");
                    config = new BetterGrassifyConfig();
                    BetterGrassifyConfig.save(config);
                } else {
                    JsonObject configJson = (JsonObject)BetterGrassifyConfig.ensureDefaults(JsonParser.parseString((String)configContent).getAsJsonObject(), GSON.toJsonTree((Object)new BetterGrassifyConfig()).getAsJsonObject()).first();
                    config = (BetterGrassifyConfig)GSON.fromJson((JsonElement)configJson, BetterGrassifyConfig.class);
                }
            }
        }
        catch (Exception e) {
            BetterGrassify.LOGGER.error("[{}] Failed to read config", (Object)"BetterGrassify", (Object)e);
            config = new BetterGrassifyConfig();
            BetterGrassifyConfig.save(config);
        }
        cachedConfig = config;
        return cachedConfig;
    }

    public static void save(BetterGrassifyConfig config) {
        try {
            String jsonString = GSON.toJson((Object)config);
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (IOException e) {
            BetterGrassify.LOGGER.error("[{}] Failed to write config", (Object)"BetterGrassify", (Object)e);
        }
    }

    private static Pair<JsonObject, Boolean> ensureDefaults(JsonObject configJson, JsonObject defaultJson) {
        boolean modified = false;
        for (Map.Entry entry : defaultJson.entrySet()) {
            Pair<JsonObject, Boolean> updated;
            String key = (String)entry.getKey();
            JsonElement defaultValue = (JsonElement)entry.getValue();
            if (!configJson.has(key)) {
                BetterGrassify.LOGGER.warn("[{}] Missing config field '{}'. Re-saving as default.", (Object)"BetterGrassify", (Object)key);
                configJson.add(key, defaultValue);
                modified = true;
                continue;
            }
            JsonElement currentValue = configJson.get(key);
            if (!defaultValue.isJsonObject() || !currentValue.isJsonObject() || !((Boolean)(updated = BetterGrassifyConfig.ensureDefaults(currentValue.getAsJsonObject(), defaultValue.getAsJsonObject())).second()).booleanValue()) continue;
            configJson.add(key, (JsonElement)updated.first());
            modified = true;
        }
        if (modified) {
            BetterGrassifyConfig.save((BetterGrassifyConfig)GSON.fromJson((JsonElement)configJson, BetterGrassifyConfig.class));
        }
        return Pair.of((Object)configJson, (Object)modified);
    }

    public static class_437 createConfigScreen(class_437 parent) {
        if (FabricLoader.getInstance().isModLoaded("cloth-config")) {
            return OptionsScreen.createConfigScreen(parent);
        }
        return new NoClothConfigWarning(parent);
    }

    public static class GeneralConfig {
        public BetterGrassMode betterGrassMode = BetterGrassMode.FANCY;
        public boolean resourcePackCompatibilityMode = true;
        public BlocksConfig blocks = new BlocksConfig();

        public static class BlocksConfig {
            public boolean grassBlocks = true;
            public boolean snowy = true;
            public boolean dirtPaths = true;
            public boolean farmLands = true;
            public boolean podzol = true;
            public boolean mycelium = true;
            public boolean crimsonNylium = true;
            public boolean warpedNylium = true;
            public List<String> moreBlocks = Lists.newArrayList();
        }
    }

    public static class BetterSnowConfig {
        public BetterSnowMode betterSnowMode = BetterSnowMode.LAMBDA;
        public List<String> snowLayers = Lists.newArrayList((Object[])new String[]{"snow", "moss_carpet", "pink_petals", "pale_moss_carpet", "leaf_litter", "wildflowers"});
        public List<String> whitelistedTags = Lists.newArrayList();
        public List<String> whitelistedBlocks = Lists.newArrayList();
        public List<String> excludedTags = Lists.newArrayList();
        public List<String> excludedBlocks = Lists.newArrayList((Object[])new String[]{"lantern[hanging]", "redstone_wall_torch", "soul_lantern[hanging]", "soul_wall_torch", "wall_torch"});
    }

    public static enum BetterSnowMode implements TranslatableOption
    {
        OFF("options.off"),
        OPTIFINE("bettergrass.betterSnow.betterSnowMode.optifine"),
        LAMBDA("bettergrass.betterSnow.betterSnowMode.lambda");

        private final String key;

        private BetterSnowMode(String key) {
            this.key = key;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }
    }

    public static enum BetterGrassMode implements TranslatableOption
    {
        OFF("options.off"),
        FAST("options.graphics.fast"),
        FANCY("options.graphics.fancy");

        private final String key;

        private BetterGrassMode(String key) {
            this.key = key;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }
    }
}

