/*
 * Decompiled with CFR 0.152.
 */
package dev.pandasystems.fallingtrees.trees;

import dev.pandasystems.fallingtrees.FallingTreesRegistriesKt;
import dev.pandasystems.fallingtrees.api.TreeData;
import dev.pandasystems.fallingtrees.api.TreeType;
import dev.pandasystems.fallingtrees.config.ClientConfig;
import dev.pandasystems.fallingtrees.config.CommonConfig;
import dev.pandasystems.fallingtrees.config.FallingTreesConfigKt;
import dev.pandasystems.fallingtrees.config.common.tree.GenericTreeConfig;
import dev.pandasystems.fallingtrees.config.common.tree.TreeConfig;
import dev.pandasystems.fallingtrees.entity.TreeEntity;
import dev.pandasystems.fallingtrees.exceptions.TreeTooBigException;
import dev.pandasystems.pandalib.utils.GameEnvironmentKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ%\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aJ9\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J%\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b!\u0010\u001aJ\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\"\u0010\bJ\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b#\u0010\bR\u0011\u0010'\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Ldev/pandasystems/fallingtrees/trees/GenericTree;", "Ldev/pandasystems/fallingtrees/api/TreeType;", "<init>", "()V", "Lnet/minecraft/class_2680;", "blockState", "", "isTreeStem", "(Lnet/minecraft/class_2680;)Z", "Ldev/pandasystems/fallingtrees/entity/TreeEntity;", "entity", "", "onTreeTick", "(Ldev/pandasystems/fallingtrees/entity/TreeEntity;)V", "Lnet/minecraft/class_2338;", "blockPos", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_1657;", "player", "Ldev/pandasystems/fallingtrees/api/TreeData;", "gatherTreeData", "(Lnet/minecraft/class_2338;Lnet/minecraft/class_1937;Lnet/minecraft/class_1657;)Ldev/pandasystems/fallingtrees/api/TreeData;", "startPos", "", "gatherLogs", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Ljava/util/Set;", "logPos", "gatherLeavesAroundLog", "logs", "leaves", "gatherAdjacentBlocks", "(Lnet/minecraft/class_1937;Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;", "gatherVines", "isLogBlock", "isLeafBlock", "Ldev/pandasystems/fallingtrees/config/common/tree/GenericTreeConfig;", "getConfig", "()Ldev/pandasystems/fallingtrees/config/common/tree/GenericTreeConfig;", "config", "BlockSearchNode", "fallingtrees-common-1.21.10"})
@SourceDebugExtension(value={"SMAP\nGenericTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericTree.kt\ndev/pandasystems/fallingtrees/trees/GenericTree\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class GenericTree
implements TreeType {
    @NotNull
    public final GenericTreeConfig getConfig() {
        return ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getTrees().getGenericTree();
    }

    @Override
    public boolean isTreeStem(@NotNull class_2680 blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return this.getConfig().getLogFilter().isValid(blockState);
    }

    @Override
    public void onTreeTick(@NotNull TreeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        if (GameEnvironmentKt.getGameEnvironment().isClient()) {
            ClientConfig clientConfig = (ClientConfig)FallingTreesConfigKt.getFallingTreesClientConfig().get();
            if (entity.field_6012 == 1 && clientConfig.getSoundSettings().getEnabled()) {
                entity.method_73183().method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)FallingTreesRegistriesKt.getTreeFallSound().get(), class_3419.field_15245, clientConfig.getSoundSettings().getStartVolume(), 1.0f, true);
            }
            if (entity.field_6012 == (int)(clientConfig.getAnimation().getFallAnimLength() * (float)20) - 5 && clientConfig.getSoundSettings().getEnabled()) {
                entity.method_73183().method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)FallingTreesRegistriesKt.getTreeImpactSound().get(), class_3419.field_15245, clientConfig.getSoundSettings().getEndVolume(), 1.0f, true);
            }
        }
    }

    @Override
    @Nullable
    public TreeData gatherTreeData(@NotNull class_2338 blockPos, @NotNull class_1937 level, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_2338 blockPos2 = blockPos;
        if (this.getConfig().getRequireTool()) {
            TreeConfig.Filter filter = this.getConfig().getAllowedToolFilter();
            class_1799 class_17992 = player.method_6047();
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getMainHandItem(...)");
            if (!filter.isValid(class_17992)) {
                return null;
            }
        }
        class_2338 class_23382 = blockPos2.method_10062();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"immutable(...)");
        blockPos2 = class_23382;
        TreeData.Builder builder = new TreeData.Builder();
        class_2680 class_26802 = level.method_8320(blockPos2);
        Intrinsics.checkNotNullExpressionValue((Object)class_26802, (String)"getBlockState(...)");
        if (!this.isLogBlock(class_26802)) {
            return null;
        }
        Set<class_2338> logs = this.gatherLogs(level, blockPos2);
        if (logs.isEmpty()) {
            return null;
        }
        Set leaves = new LinkedHashSet();
        for (class_2338 logPos : logs) {
            leaves.addAll((Collection)this.gatherLeavesAroundLog(level, logPos));
        }
        if (leaves.isEmpty()) {
            return null;
        }
        Set<class_2338> adjacent = this.gatherAdjacentBlocks(level, logs, leaves);
        Set<class_2338> allBlocks = logs;
        allBlocks.addAll(leaves);
        allBlocks.addAll((Collection<class_2338>)adjacent);
        List drops = new ArrayList();
        for (class_2338 block : allBlocks) {
            class_2680 blockState = level.method_8320(block);
            if (!(level instanceof class_3218)) continue;
            List items = class_2248.method_9609((class_2680)blockState, (class_3218)((class_3218)level), (class_2338)block, null, (class_1297)((class_1297)player), (class_1799)player.method_6047());
            Intrinsics.checkNotNull((Object)items);
            drops.addAll(items);
        }
        TreeData.Builder builder2 = builder.addBlocks((Collection<class_2338>)allBlocks).setToolDamage(logs.size()).setFoodExhaustionModifier(arg_0 -> GenericTree.gatherTreeData$lambda$0(logs, arg_0)).addDrops(drops).setMiningSpeedModifier(arg_0 -> GenericTree.gatherTreeData$lambda$1(logs, arg_0));
        List<class_3445> list = logs.stream().map(arg_0 -> GenericTree.gatherTreeData$lambda$3(arg_0 -> GenericTree.gatherTreeData$lambda$2(level, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return builder2.addAwardedStats((Collection)list).build();
    }

    private final Set<class_2338> gatherLogs(class_1937 level, class_2338 startPos) {
        Set logs = new LinkedHashSet();
        Queue toVisit = new LinkedList();
        Set visited = new LinkedHashSet();
        toVisit.add(startPos);
        while (!toVisit.isEmpty()) {
            class_2338 current = (class_2338)toVisit.poll();
            if (visited.contains(current)) continue;
            Intrinsics.checkNotNull((Object)current);
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            Intrinsics.checkNotNull((Object)currentState);
            if (!this.isLogBlock(currentState)) continue;
            logs.add(current);
            if (logs.size() > this.getConfig().getAlgorithm().getMaxLogAmount()) {
                throw new TreeTooBigException(current, level);
            }
            for (class_2338 offset : class_2338.method_10094((int)-1, (int)0, (int)-1, (int)1, (int)1, (int)1)) {
                class_2338 neighbor = current.method_10081((class_2382)offset);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return logs;
    }

    private final Set<class_2338> gatherLeavesAroundLog(class_1937 level, class_2338 logPos) {
        Set leaves = new LinkedHashSet();
        Queue toVisit = new LinkedList();
        Set visited = new LinkedHashSet();
        for (class_2350 direction : EntriesMappings.entries$0) {
            class_2338 neighbor = logPos.method_10093(direction);
            Intrinsics.checkNotNull((Object)neighbor);
            toVisit.add(new BlockSearchNode(neighbor, 1));
        }
        while (!toVisit.isEmpty()) {
            BlockSearchNode node = (BlockSearchNode)toVisit.poll();
            class_2338 current = node.position();
            class_2680 currentState = level.method_8320(current);
            OptionalInt optionalDistanceAt = class_2397.method_49817((class_2680)currentState);
            if (optionalDistanceAt.isPresent() && node.distance() != optionalDistanceAt.getAsInt() || visited.contains(current) || node.distance() > this.getConfig().getAlgorithm().getMaxLeavesRadius()) continue;
            visited.add(current);
            Intrinsics.checkNotNull((Object)currentState);
            if (!this.isLeafBlock(currentState)) continue;
            leaves.add(current);
            for (class_2350 direction : EntriesMappings.entries$0) {
                class_2338 nextPos = current.method_10093(direction);
                if (visited.contains(nextPos)) continue;
                Intrinsics.checkNotNull((Object)nextPos);
                toVisit.add(new BlockSearchNode(nextPos, node.distance() + 1));
            }
        }
        return leaves;
    }

    private final Set<class_2338> gatherAdjacentBlocks(class_1937 level, Set<class_2338> logs, Set<class_2338> leaves) {
        Set adjacentBlocks = new LinkedHashSet();
        Set set = new LinkedHashSet();
        Set it = set;
        boolean bl = false;
        it.addAll((Collection)logs);
        it = set;
        boolean bl2 = false;
        it.addAll((Collection)leaves);
        Set allTreeBlocks = set;
        for (class_2338 blockPos : allTreeBlocks) {
            for (class_2350 dir : EntriesMappings.entries$0) {
                class_2338 neighbor = blockPos.method_10093(dir);
                class_2680 neighborState = level.method_8320(neighbor);
                if (neighborState.method_27852(class_2246.field_10597)) {
                    Intrinsics.checkNotNull((Object)neighbor);
                    adjacentBlocks.addAll((Collection)this.gatherVines(level, neighbor));
                    continue;
                }
                if (neighborState.method_27852(class_2246.field_20421)) {
                    Intrinsics.checkNotNull((Object)neighbor);
                    adjacentBlocks.add(neighbor);
                    continue;
                }
                if (!neighborState.method_27852(class_2246.field_10302)) continue;
                Intrinsics.checkNotNull((Object)neighbor);
                adjacentBlocks.add(neighbor);
            }
        }
        return adjacentBlocks;
    }

    private final Set<class_2338> gatherVines(class_1937 level, class_2338 startPos) {
        Set vines = new LinkedHashSet();
        Stack<class_2338> toVisit = new Stack<class_2338>();
        Set visited = new LinkedHashSet();
        toVisit.push(startPos);
        while (!toVisit.isEmpty()) {
            class_2338 current = (class_2338)toVisit.pop();
            if (visited.contains(current)) continue;
            Intrinsics.checkNotNull((Object)current);
            visited.add(current);
            class_2680 currentState = level.method_8320(current);
            if (!currentState.method_27852(class_2246.field_10597)) continue;
            vines.add(current);
            class_2338 neighbor = current.method_10074();
            if (visited.contains(neighbor)) continue;
            toVisit.push(neighbor);
        }
        return vines;
    }

    private final boolean isLogBlock(class_2680 blockState) {
        return this.getConfig().getLogFilter().isValid(blockState);
    }

    private final boolean isLeafBlock(class_2680 blockState) {
        if (this.getConfig().getAlgorithm().getShouldIgnorePersistentLeaves() && blockState.method_28498((class_2769)class_2741.field_12514) && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12514)).booleanValue()) {
            return false;
        }
        return this.getConfig().getLeavesFilter().isValid(blockState);
    }

    private static final float gatherTreeData$lambda$0(Set $logs, float originalExhaustion) {
        return originalExhaustion * (float)$logs.size();
    }

    private static final float gatherTreeData$lambda$1(Set $logs, float originalMiningSpeed) {
        float speedMultiplication = ((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDynamicMiningSpeed().getSpeedMultiplication();
        float multiplyAmount = RangesKt.coerceAtMost((float)((CommonConfig)FallingTreesConfigKt.getFallingTreesCommonConfig().get()).getDynamicMiningSpeed().getMaxSpeedMultiplication(), (float)((float)$logs.size() - 1.0f));
        return originalMiningSpeed / (multiplyAmount * speedMultiplication + 1.0f);
    }

    private static final class_3445 gatherTreeData$lambda$2(class_1937 $level, class_2338 logPos) {
        Intrinsics.checkNotNullParameter((Object)logPos, (String)"logPos");
        class_2680 blockState = $level.method_8320(logPos);
        return class_3468.field_15427.method_14956((Object)blockState.method_26204());
    }

    private static final class_3445 gatherTreeData$lambda$3(Function1 $tmp0, Object p0) {
        return (class_3445)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0003\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ldev/pandasystems/fallingtrees/trees/GenericTree$BlockSearchNode;", "Ljava/lang/Record;", "Lnet/minecraft/class_2338;", "position", "", "distance", "<init>", "(Lnet/minecraft/class_2338;I)V", "component1", "()Lnet/minecraft/class_2338;", "component2", "()I", "copy", "(Lnet/minecraft/class_2338;I)Ldev/pandasystems/fallingtrees/trees/GenericTree$BlockSearchNode;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2338;", "I", "fallingtrees-common-1.21.10"})
    private static final class BlockSearchNode
    extends Record {
        @NotNull
        private final class_2338 position;
        private final int distance;

        public BlockSearchNode(@NotNull class_2338 position, int distance) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            this.position = position;
            this.distance = distance;
        }

        @NotNull
        public final class_2338 position() {
            return this.position;
        }

        public final int distance() {
            return this.distance;
        }

        @NotNull
        public final class_2338 component1() {
            return this.position;
        }

        public final int component2() {
            return this.distance;
        }

        @NotNull
        public final BlockSearchNode copy(@NotNull class_2338 position, int distance) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new BlockSearchNode(position, distance);
        }

        public static /* synthetic */ BlockSearchNode copy$default(BlockSearchNode blockSearchNode, class_2338 class_23382, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                class_23382 = blockSearchNode.position;
            }
            if ((n2 & 2) != 0) {
                n = blockSearchNode.distance;
            }
            return blockSearchNode.copy(class_23382, n);
        }

        @Override
        @NotNull
        public String toString() {
            return "BlockSearchNode(position=" + this.position + ", distance=" + this.distance + ")";
        }

        @Override
        public int hashCode() {
            int result = this.position.hashCode();
            result = result * 31 + Integer.hashCode(this.distance);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BlockSearchNode)) {
                return false;
            }
            BlockSearchNode blockSearchNode = (BlockSearchNode)other;
            if (!Intrinsics.areEqual((Object)this.position, (Object)blockSearchNode.position)) {
                return false;
            }
            return this.distance == blockSearchNode.distance;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<class_2350> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])class_2350.values()));
        }
    }
}

