/*
 * Decompiled with CFR 0.152.
 */
package dev.pandasystems.fallingtrees.client.render;

import dev.pandasystems.fallingtrees.api.TreeType;
import dev.pandasystems.fallingtrees.client.render.TreeRenderState;
import dev.pandasystems.fallingtrees.config.ClientConfig;
import dev.pandasystems.fallingtrees.config.FallingTreesConfigKt;
import dev.pandasystems.fallingtrees.entity.TreeEntity;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J3\u0010!\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b&\u0010%J\u0019\u0010(\u001a\u00020'2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0004\b(\u0010)R\u0011\u0010-\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Ldev/pandasystems/fallingtrees/client/render/TreeRenderer;", "Lnet/minecraft/class_897;", "Ldev/pandasystems/fallingtrees/entity/TreeEntity;", "Ldev/pandasystems/fallingtrees/client/render/TreeRenderState;", "Lnet/minecraft/class_5617$class_5618;", "context", "<init>", "(Lnet/minecraft/class_5617$class_5618;)V", "renderState", "Lnet/minecraft/class_4587;", "poseStack", "Lnet/minecraft/class_11659;", "nodeCollector", "Lnet/minecraft/class_12075;", "cameraRenderState", "", "submit", "(Ldev/pandasystems/fallingtrees/client/render/TreeRenderState;Lnet/minecraft/class_4587;Lnet/minecraft/class_11659;Lnet/minecraft/class_12075;)V", "createRenderState", "()Ldev/pandasystems/fallingtrees/client/render/TreeRenderState;", "entity", "", "f", "extractRenderState", "(Ldev/pandasystems/fallingtrees/entity/TreeEntity;Ldev/pandasystems/fallingtrees/client/render/TreeRenderState;F)V", "Ldev/pandasystems/fallingtrees/api/TreeType;", "tree", "", "Lnet/minecraft/class_2338;", "Lnet/minecraft/class_2680;", "blocks", "Lnet/minecraft/class_2350;", "direction", "getDistance", "(Ldev/pandasystems/fallingtrees/api/TreeType;Ljava/util/Map;Lnet/minecraft/class_2350;)F", "time", "bumpCos", "(F)F", "bumpSin", "", "affectedByCulling", "(Ldev/pandasystems/fallingtrees/entity/TreeEntity;)Z", "Ldev/pandasystems/fallingtrees/config/ClientConfig;", "getConfig", "()Ldev/pandasystems/fallingtrees/config/ClientConfig;", "config", "fallingtrees-common-1.21.10"})
@SourceDebugExtension(value={"SMAP\nTreeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeRenderer.kt\ndev/pandasystems/fallingtrees/client/render/TreeRenderer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,139:1\n216#2,2:140\n*S KotlinDebug\n*F\n+ 1 TreeRenderer.kt\ndev/pandasystems/fallingtrees/client/render/TreeRenderer\n*L\n70#1:140,2\n*E\n"})
public final class TreeRenderer
extends class_897<TreeEntity, TreeRenderState> {
    public TreeRenderer(@NotNull class_5617.class_5618 context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @NotNull
    public final ClientConfig getConfig() {
        return (ClientConfig)FallingTreesConfigKt.getFallingTreesClientConfig().get();
    }

    public void submit(@NotNull TreeRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_11659 nodeCollector, @NotNull class_12075 cameraRenderState) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)nodeCollector, (String)"nodeCollector");
        Intrinsics.checkNotNullParameter((Object)cameraRenderState, (String)"cameraRenderState");
        super.method_3936((class_10017)renderState, poseStack, nodeCollector, cameraRenderState);
        TreeType treeType = renderState.getTreeType();
        if (treeType == null) {
            return;
        }
        TreeType tree = treeType;
        poseStack.method_22903();
        Map<class_2338, class_2680> map = renderState.getBlocks();
        Intrinsics.checkNotNull(map);
        Map<class_2338, class_2680> blocks = map;
        float fallAnimLength = this.getConfig().getAnimation().getFallAnimLength();
        float bounceHeight = this.getConfig().getAnimation().getBounceAngleHeight();
        float bounceAnimLength = this.getConfig().getAnimation().getBounceAnimLength();
        float time = (float)(renderState.getLifeTime() * 1.5707963267948966 / (double)fallAnimLength);
        float fallAnim = this.bumpCos(time) * (float)90;
        float bounceAnim = this.bumpSin((float)(((double)time - 1.5707963267948966) / (double)(bounceAnimLength / (fallAnimLength * (float)2)))) * bounceHeight;
        float animation = fallAnim + bounceAnim - (float)90;
        class_2350 class_23502 = renderState.getDirection();
        Intrinsics.checkNotNull((Object)class_23502);
        class_2350 direction = class_23502.method_10153();
        class_2350 class_23503 = direction.method_10153();
        Intrinsics.checkNotNullExpressionValue((Object)class_23503, (String)"getOpposite(...)");
        float distance = this.getDistance(tree, blocks, class_23503);
        Vector3f pivot = new Vector3f(0.0f, 0.0f, 0.5f + distance);
        pivot.rotateY(Math.toRadians((float)(-direction.method_10144())));
        poseStack.method_46416(-pivot.x, 0.0f, -pivot.z);
        Vector3f vector = new Vector3f(Math.toRadians((float)animation), 0.0f, 0.0f);
        vector.rotateY(Math.toRadians((float)(-direction.method_10144())));
        Quaternionf quaternion = new Quaternionf().identity().rotateX(vector.x).rotateZ(vector.z);
        poseStack.method_22907((Quaternionfc)quaternion);
        class_1937 class_19372 = renderState.getLevel();
        Intrinsics.checkNotNull((Object)class_19372);
        class_1937 level = class_19372;
        poseStack.method_46416(pivot.x, 0.0f, pivot.z);
        poseStack.method_22904(-0.5, 0.0, -0.5);
        Map<class_2338, class_2680> $this$forEach$iv = blocks;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<class_2338, class_2680>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2338, class_2680> element$iv;
            Map.Entry<class_2338, class_2680> entry = element$iv = iterator.next();
            boolean bl = false;
            class_2338 blockPos = entry.getKey();
            class_2680 blockState = entry.getValue();
            poseStack.method_22903();
            poseStack.method_46416((float)blockPos.method_10263(), (float)blockPos.method_10264(), (float)blockPos.method_10260());
            nodeCollector.method_73481(poseStack, blockState, renderState.field_61820, class_4608.field_21444, renderState.field_61821);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    @NotNull
    public TreeRenderState createRenderState() {
        return new TreeRenderState();
    }

    public void extractRenderState(@NotNull TreeEntity entity, @NotNull TreeRenderState renderState, float f) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
        renderState.setTreeType(entity.getTreeType());
        renderState.setBlocks(entity.getBlocks());
        renderState.setLifeTime(entity.getLifetime(f));
        renderState.setDirection(entity.method_5735());
        renderState.setOriginPos((class_2382)entity.getOriginPos());
        renderState.setLevel(entity.method_73183());
        super.method_62354((class_1297)entity, (class_10017)renderState, f);
    }

    private final float getDistance(TreeType tree, Map<class_2338, class_2680> blocks, class_2350 direction) {
        float distance = 0.0f;
        class_2338 currentPos = new class_2338(0, 0, 0);
        class_2338 next = currentPos.method_10093(direction);
        while (blocks.containsKey(next)) {
            class_2680 class_26802 = blocks.get(next);
            Intrinsics.checkNotNull((Object)class_26802);
            if (!tree.isTreeStem(class_26802)) break;
            class_2338 class_23382 = next;
            Intrinsics.checkNotNull((Object)class_23382);
            currentPos = class_23382;
            next = currentPos.method_10093(direction);
            float f = distance;
            distance = f + 1.0f;
        }
        class_2680 class_26803 = blocks.get(currentPos);
        Intrinsics.checkNotNull((Object)class_26803);
        class_2680 blockState = class_26803;
        if (blockState.method_49228()) {
            return distance - 0.5f;
        }
        class_638 class_6382 = class_310.method_1551().field_1687;
        Intrinsics.checkNotNull((Object)class_6382);
        class_265 shape = blockState.method_26220((class_1922)class_6382, currentPos);
        if (shape.method_1110()) {
            class_638 class_6383 = class_310.method_1551().field_1687;
            Intrinsics.checkNotNull((Object)class_6383);
            shape = blockState.method_26218((class_1922)class_6383, currentPos);
        }
        if (!shape.method_1110()) {
            class_238 bounds = shape.method_1107();
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    distance -= (float)bounds.field_1323;
                    break;
                }
                case 2: {
                    distance -= (float)((double)1.0f - bounds.field_1320);
                    break;
                }
                case 3: {
                    distance -= (float)bounds.field_1321;
                    break;
                }
                case 4: {
                    distance -= (float)((double)1.0f - bounds.field_1324);
                    break;
                }
                default: {
                    break;
                }
            }
        } else {
            distance -= 1.0f;
        }
        return distance;
    }

    private final float bumpCos(float time) {
        return (float)Math.max((double)0.0, (double)Math.cos((double)Math.clamp((double)(-java.lang.Math.PI), (double)java.lang.Math.PI, (double)time)));
    }

    private final float bumpSin(float time) {
        return (float)Math.max((double)0.0, (double)Math.sin((double)Math.clamp((double)(-java.lang.Math.PI), (double)java.lang.Math.PI, (double)time)));
    }

    protected boolean affectedByCulling(@Nullable TreeEntity entity) {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[class_2350.values().length];
            try {
                nArray[class_2350.field_11039.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11034.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11035.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[class_2350.field_11043.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

