/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Function3;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.TrinketSlotTarget;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.data.EntitySlotLoader;
import dev.emi.trinkets.payload.BreakPayload;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistryV3;

public class TrinketsApi {
    public static final ComponentKey<TrinketComponent> TRINKET_COMPONENT = ComponentRegistryV3.INSTANCE.getOrCreate(class_2960.method_60655((String)"trinkets", (String)"trinkets"), TrinketComponent.class);
    private static final Map<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>> PREDICATES = new HashMap<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>>();
    private static final Map<class_1792, Trinket> TRINKETS = new HashMap<class_1792, Trinket>();
    private static final Trinket DEFAULT_TRINKET;

    public static void registerTrinket(class_1792 item, Trinket trinket) {
        TRINKETS.put(item, trinket);
    }

    public static Trinket getTrinket(class_1792 item) {
        return TRINKETS.getOrDefault(item, DEFAULT_TRINKET);
    }

    public static Trinket getDefaultTrinket() {
        return DEFAULT_TRINKET;
    }

    public static Optional<TrinketComponent> getTrinketComponent(class_1309 livingEntity) {
        return TRINKET_COMPONENT.maybeGet((Object)livingEntity);
    }

    public static void onTrinketBroken(class_1799 stack, SlotReference ref, class_1309 entity) {
        class_1937 world = entity.method_73183();
        if (!world.method_8608()) {
            BreakPayload packet = new BreakPayload(entity.method_5628(), ref.inventory().getSlotType().getGroup(), ref.inventory().getSlotType().getName(), ref.index());
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
            }
            PlayerLookup.tracking((class_1297)entity).forEach(watcher -> ServerPlayNetworking.send((class_3222)watcher, (class_8710)packet));
        }
    }

    @Deprecated
    public static Map<String, SlotGroup> getPlayerSlots() {
        return TrinketsApi.getEntitySlots(class_1299.field_6097);
    }

    public static Map<String, SlotGroup> getPlayerSlots(class_1937 world) {
        return TrinketsApi.getEntitySlots(world, class_1299.field_6097);
    }

    public static Map<String, SlotGroup> getPlayerSlots(class_1657 player) {
        return TrinketsApi.getEntitySlots((class_1297)player);
    }

    @Deprecated
    public static Map<String, SlotGroup> getEntitySlots(class_1299<?> type) {
        EntitySlotLoader loader = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER;
        return loader.getEntitySlots(type);
    }

    public static Map<String, SlotGroup> getEntitySlots(class_1937 world, class_1299<?> type) {
        EntitySlotLoader loader = world.method_8608() ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER;
        return loader.getEntitySlots(type);
    }

    public static Map<String, SlotGroup> getEntitySlots(class_1297 entity) {
        if (entity != null) {
            return TrinketsApi.getEntitySlots(entity.method_73183(), entity.method_5864());
        }
        return ImmutableMap.of();
    }

    public static void registerTrinketPredicate(class_2960 id, Function3<class_1799, SlotReference, class_1309, TriState> predicate) {
        PREDICATES.put(id, predicate);
    }

    public static Optional<Function3<class_1799, SlotReference, class_1309, TriState>> getTrinketPredicate(class_2960 id) {
        return Optional.ofNullable(PREDICATES.get(id));
    }

    public static boolean evaluatePredicateSet(Set<class_2960> set, class_1799 stack, SlotReference ref, class_1309 entity) {
        TriState state = TriState.DEFAULT;
        for (class_2960 id : set) {
            Optional<Function3<class_1799, SlotReference, class_1309, TriState>> function = TrinketsApi.getTrinketPredicate(id);
            if (function.isPresent()) {
                state = (TriState)function.get().apply((Object)stack, (Object)ref, (Object)entity);
            }
            if (state == TriState.DEFAULT) continue;
            break;
        }
        return state.get();
    }

    public static class_1887.class_9427 withTrinketSlots(class_1887.class_9427 definition, Set<String> slots) {
        class_1887.class_9427 def = new class_1887.class_9427(definition.comp_2506(), definition.comp_2507(), definition.comp_2508(), definition.comp_2509(), definition.comp_2510(), definition.comp_2511(), definition.comp_2512(), definition.comp_2513());
        ((TrinketSlotTarget)def).trinkets$slots(slots);
        return def;
    }

    static {
        TrinketsApi.registerTrinketPredicate(class_2960.method_60655((String)"trinkets", (String)"all"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> TriState.TRUE));
        TrinketsApi.registerTrinketPredicate(class_2960.method_60655((String)"trinkets", (String)"none"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> TriState.FALSE));
        class_6862 trinketsAll = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"trinkets", (String)"all"));
        TrinketsApi.registerTrinketPredicate(class_2960.method_60655((String)"trinkets", (String)"tag"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> {
            SlotType slot = ref.inventory().getSlotType();
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"trinkets", (String)slot.getId()));
            if (stack.method_31573(tag) || stack.method_31573(trinketsAll)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        TrinketsApi.registerTrinketPredicate(class_2960.method_60655((String)"trinkets", (String)"relevant"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> {
            Multimap<class_6880<class_1320>, class_1322> map = TrinketModifiers.get(stack, ref, entity);
            if (!map.isEmpty()) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        DEFAULT_TRINKET = new Trinket(){};
    }
}

