/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.skybox.components;

import btw.lowercase.skyboxify.utils.CommonUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record Fade(int startIn, int endIn, int startOut, int endOut, boolean alwaysOn) {
    public static final Fade DEFAULT = new Fade(0, 0, 0, 0, true);
    public static final Codec<Fade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("startFadeIn", (Object)0).forGetter(Fade::startIn), (App)Codec.INT.optionalFieldOf("endFadeIn", (Object)0).forGetter(Fade::endIn), (App)Codec.INT.optionalFieldOf("startFadeOut", (Object)0).forGetter(Fade::startOut), (App)Codec.INT.optionalFieldOf("endFadeOut", (Object)0).forGetter(Fade::endOut), (App)Codec.BOOL.optionalFieldOf("alwaysOn", (Object)false).forGetter(Fade::alwaysOn)).apply((Applicative)instance, Fade::new));

    public Fade(int startIn, int endIn, int startOut, int endOut, boolean alwaysOn) {
        this.startIn = Fade.normalizeIfNot(startIn, alwaysOn);
        this.endIn = Fade.normalizeIfNot(endIn, alwaysOn);
        this.startOut = Fade.normalizeIfNot(startOut, alwaysOn);
        this.endOut = Fade.normalizeIfNot(endOut, alwaysOn);
        this.alwaysOn = alwaysOn;
    }

    public float getAlpha(int timeOfDay) {
        if (this.alwaysOn || CommonUtils.isInTimeInterval(timeOfDay, this.endIn, this.startOut)) {
            return 1.0f;
        }
        if (CommonUtils.isInTimeInterval(timeOfDay, this.startIn, this.endIn)) {
            int fadeInDuration = Fade.calculateCyclicTimeDistance(this.startIn, this.endIn);
            int timePassedSinceFadeInStart = Fade.calculateCyclicTimeDistance(this.startIn, timeOfDay);
            return (float)timePassedSinceFadeInStart / (float)fadeInDuration;
        }
        if (CommonUtils.isInTimeInterval(timeOfDay, this.startOut, this.endOut)) {
            int fadeOutDuration = Fade.calculateCyclicTimeDistance(this.startOut, this.endOut);
            int timePassedSinceFadeOutStart = Fade.calculateCyclicTimeDistance(this.startOut, timeOfDay);
            return 1.0f - (float)timePassedSinceFadeOutStart / (float)fadeOutDuration;
        }
        return 0.0f;
    }

    private static int normalizeIfNot(int time, boolean ignore) {
        return ignore ? time : CommonUtils.normalizeTickTime(time);
    }

    private static int calculateCyclicTimeDistance(int startTime, int endTime) {
        return (endTime - startTime + 24000) % 24000;
    }
}

