/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.skyboxify.api;

import btw.lowercase.skyboxify.api.SkyboxifyApi;
import btw.lowercase.skyboxify.config.SkyboxifyConfig;
import btw.lowercase.skyboxify.skybox.SkyboxManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;

public final class SkyboxifyImpl
implements SkyboxifyApi {
    private static final SkyboxifyImpl INSTANCE = new SkyboxifyImpl();
    private final SkyboxifyConfig config = new SkyboxifyConfig();
    private final SkyboxManager skyboxManager = new SkyboxManager(this);
    private final Map<Integer, class_2960> dimensionMapping = new HashMap<Integer, class_2960>();

    private SkyboxifyImpl() {
        this.registerDimensionMapping(-1, class_2960.method_60656((String)"the_nether"));
        this.registerDimensionMapping(0, class_2960.method_60656((String)"overworld"));
        this.registerDimensionMapping(1, class_2960.method_60656((String)"the_end"));
        this.registerDimensionMapping(4, class_2960.method_60655((String)"aether", (String)"the_aether"));
        this.registerDimensionMapping(7, class_2960.method_60655((String)"twilightforest", (String)"twilight_forest"));
    }

    public static SkyboxifyApi getInstance() {
        return INSTANCE;
    }

    public static SkyboxifyConfig config() {
        return SkyboxifyImpl.getInstance().getConfig();
    }

    @Override
    public SkyboxifyConfig getConfig() {
        return this.config;
    }

    public static SkyboxManager skyboxManager() {
        return SkyboxifyImpl.getInstance().getSkyboxManager();
    }

    @Override
    public SkyboxManager getSkyboxManager() {
        return this.skyboxManager;
    }

    @Override
    public class_2960 getModernDimension(int legacyId) {
        return this.dimensionMapping.getOrDefault(legacyId, null);
    }

    @Override
    public void registerDimensionMapping(int legacyId, class_2960 modernId) {
        if (this.dimensionMapping.containsKey(legacyId)) {
            throw new IllegalArgumentException("Cannot register dimension mapping, world with legacy id " + legacyId + " is already taken by \"" + String.valueOf(this.dimensionMapping.get(legacyId)) + "\"!");
        }
        if (this.dimensionMapping.containsValue(modernId)) {
            int currentId = 0;
            for (int key : this.dimensionMapping.keySet()) {
                if (!Objects.equals(this.dimensionMapping.get(key), modernId)) continue;
                currentId = key;
            }
            throw new IllegalArgumentException("Cannot register dimension mapping, world \"" + String.valueOf(modernId) + "\" is already mapped to legacy id " + currentId);
        }
        this.dimensionMapping.put(legacyId, modernId);
    }
}

