/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebossmagnus.mods.config_manager.common_coremod.compat;

import io.github.thebossmagnus.mods.config_manager.common.Constants;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ModrinthAppCompat {
    public static int getFullScreenSetting(@NotNull Path gameDir) {
        if (Files.exists(gameDir.resolve("options.txt"), new LinkOption[0])) {
            try {
                String content = Files.readString(gameDir.resolve("options.txt"));
                if (content.equals("\nfullscreen:true") || content.equals("fullscreen:true")) {
                    Constants.LOGGER.info("Detected fullscreen preference imposed by the launcher: true, Merging it with modpack preference");
                    return 1;
                }
                if (content.equals("\nfullscreen:false") || content.equals("fullscreen:false")) {
                    Constants.LOGGER.info("Detected fullscreen preference imposed by the launcher: false, Merging it with modpack preference");
                    return 0;
                }
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    public static void reapplyFullScreenSetting(@NotNull Path gameDir, int status) {
        if (status == -1) {
            return;
        }
        String fullscreenSetting = status == 1 ? "fullscreen:true" : "fullscreen:false";
        try {
            Path optionsFile = gameDir.resolve("options.txt");
            List<String> lines = Files.readAllLines(optionsFile);
            boolean replaced = false;
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).startsWith("fullscreen:")) continue;
                if (!lines.get(i).equals(fullscreenSetting)) {
                    Constants.LOGGER.warn("Overriding modpack fullscreen preference ({}) with launcher preference ({})", (Object)lines.get(i), (Object)fullscreenSetting);
                }
                lines.set(i, fullscreenSetting);
                replaced = true;
                break;
            }
            if (!replaced) {
                lines.add(fullscreenSetting);
            }
            Files.write(optionsFile, lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            Constants.LOGGER.error("Could not reapply fullscreen preference chosen by the launcher", (Throwable)e);
        }
    }
}

