/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc.dialtone;

import io.netty.channel.AbstractServerChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import link.e4mc.E4mcClient;
import link.e4mc.QuiclimeSession;
import link.e4mc.dialtone.DialtoneAddress;
import link.e4mc.dialtone.DialtoneChannel;
import link.e4mc.iroh.Endpoint;
import link.e4mc.iroh.NativeException;
import link.e4mc.iroh.Resolvable;

public class DialtoneServerChannel
extends AbstractServerChannel {
    private final ChannelConfig config = new DefaultChannelConfig((Channel)this);
    Endpoint endpoint;
    Thread dispatcher;
    boolean closed = false;

    protected boolean isCompatible(EventLoop loop) {
        return true;
    }

    protected SocketAddress localAddress0() {
        return new DialtoneAddress(this.endpoint.address());
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        this.endpoint = new Endpoint(new byte[][]{"e4mc-dialtone".getBytes(StandardCharsets.UTF_8)}, QuiclimeSession.getRelayMap());
        this.dispatcher = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Runnable polled = this.endpoint.pollCallbackLoop();
                        polled.run();
                    }
                }
                catch (NativeException e) {
                    E4mcClient.LOGGER.error("poll exc, stopping", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    E4mcClient.LOGGER.error("poll exc, continuing", e);
                    continue;
                }
                break;
            }
        }, "Dialtone Server Dispatcher");
        this.dispatcher.setDaemon(true);
        this.dispatcher.start();
        this.endpoint.watchAddress(new Resolvable<String>(){

            @Override
            public void resolve(String addr) {
                if (addr != null) {
                    E4mcClient.LOGGER.info("got new session ticket");
                    DialtoneServerChannel.this.pipeline().fireUserEventTriggered((Object)new DialtoneAddress(addr));
                }
            }

            @Override
            public void reject(Throwable throwable) {
            }
        });
    }

    protected void doClose() {
        this.endpoint.closeAsync().join();
        this.endpoint.close();
        this.dispatcher.interrupt();
        this.endpoint = null;
        this.dispatcher = null;
        this.closed = true;
    }

    protected void doBeginRead() throws Exception {
        ((CompletableFuture)this.endpoint.accept().thenAccept(preconn -> {
            E4mcClient.LOGGER.info("preconn accepted, dialtone child registered");
            DialtoneChannel channel = new DialtoneChannel(this);
            this.pipeline().fireChannelRead((Object)channel);
            this.pipeline().fireChannelReadComplete();
            ((CompletableFuture)preconn.thenAccept(conn -> {
                E4mcClient.LOGGER.info("conn accepted, dialtone child pre-active");
                channel.connection = conn;
                conn.acceptBi().thenAccept(bidi -> {
                    E4mcClient.LOGGER.info("bidi accepted, dialtone child active");
                    channel.stream = bidi;
                    channel.pipeline().fireChannelActive();
                });
            })).exceptionally(e -> {
                channel.pipeline().fireChannelInactive();
                this.pipeline().fireExceptionCaught(e);
                return null;
            });
        })).exceptionally(e -> {
            this.pipeline().fireExceptionCaught(e);
            return null;
        });
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isActive() {
        return this.endpoint != null;
    }
}

