/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.keyboard.CommonKeyboardHints;
import dev.isxander.controlify.screenop.keyboard.KeyboardWidget;
import dev.isxander.controlify.utils.LazyComponentDims;
import dev.isxander.controlify.utils.PrecomputedComponentDims;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7743;

public class AbstractSignEditScreenProcessor
extends ScreenProcessor<class_7743> {
    private static final class_2561 signLineHint = class_2561.method_43469((String)"controlify.hint.sign_line_change", (Object[])new Object[]{ControlifyBindings.GUI_SECONDARY_NAVI_UP.inputGlyph(), ControlifyBindings.GUI_SECONDARY_NAVI_DOWN.inputGlyph()});
    private final Consumer<Integer> moveCursorFunc;
    private final Supplier<class_2625> signSupplier;
    private final Supplier<KeyboardWidget> keyboardWidgetSupplier;
    private List<PrecomputedComponentDims<class_5481>> signLineHintLines;

    public AbstractSignEditScreenProcessor(class_7743 screen, Consumer<Integer> moveCursorFunc, Supplier<class_2625> signSupplier, Supplier<KeyboardWidget> keyboardWidgetSupplier) {
        super(screen);
        this.moveCursorFunc = moveCursorFunc;
        this.signSupplier = signSupplier;
        this.keyboardWidgetSupplier = keyboardWidgetSupplier;
    }

    @Override
    protected void handleButtons(ControllerEntity controller) {
        super.handleButtons(controller);
        GenericControllerConfig config = controller.genericConfig().config();
        if (ControlifyBindings.GUI_SECONDARY_NAVI_DOWN.on(controller).justPressed()) {
            this.moveCursorFunc.accept(1);
            if (config.hintKeyboardSignLine && config.showScreenGuides) {
                config.hintKeyboardSignLine = false;
                Controlify.instance().config().save();
            }
            AbstractSignEditScreenProcessor.playFocusChangeSound();
        }
        if (ControlifyBindings.GUI_SECONDARY_NAVI_UP.on(controller).justPressed()) {
            this.moveCursorFunc.accept(-1);
            if (config.hintKeyboardSignLine && config.showScreenGuides) {
                config.hintKeyboardSignLine = false;
                Controlify.instance().config().save();
            }
            AbstractSignEditScreenProcessor.playFocusChangeSound();
        }
    }

    @Override
    protected void render(ControllerEntity controller, class_332 graphics, float tickDelta, Optional<VirtualMouseHandler> vmouse) {
        GenericControllerConfig config = controller.genericConfig().config();
        KeyboardWidget keyboardWidget = this.keyboardWidgetSupplier.get();
        if (keyboardWidget != null && config.showScreenGuides) {
            if (config.hintKeyboardCursor) {
                LazyComponentDims hint = CommonKeyboardHints.TEXT_CURSOR;
                int x = keyboardWidget.method_55442() - hint.getWidth() - 2;
                int y = keyboardWidget.method_46427() - hint.getHeight();
                graphics.method_51439(AbstractSignEditScreenProcessor.minecraft.field_1772, hint.getComponent(), x, y, -1, true);
            }
            if (config.hintKeyboardSignLine && this.signLineHintLines != null) {
                int y = 4;
                for (PrecomputedComponentDims<class_5481> line : this.signLineHintLines) {
                    int lineWidth = line.width();
                    int lineHeight = line.height();
                    class_5481 lineText = line.component();
                    graphics.method_51430(AbstractSignEditScreenProcessor.minecraft.field_1772, lineText, ((class_7743)this.screen).field_22789 - 1 - lineWidth, y, -1, true);
                    Objects.requireNonNull(AbstractSignEditScreenProcessor.minecraft.field_1772);
                    y += 9;
                }
            }
        }
    }

    @Override
    public void onWidgetRebuild() {
        super.onWidgetRebuild();
        if (Controlify.instance().currentInputMode() == InputMode.MIXED) {
            this.holdRepeatHelper.clearDelay();
        }
        this.getWidget(class_5244.field_24334).ifPresent(doneButton -> ButtonGuideApi.addGuideToButton((class_4264)doneButton, ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always()));
        class_2625 sign = this.signSupplier.get();
        int signRight = ((class_7743)this.screen).field_22789 / 2 + sign.method_45470() / 2;
        int maxLineWidth = ((class_7743)this.screen).field_22789 - signRight;
        this.signLineHintLines = AbstractSignEditScreenProcessor.minecraft.field_1772.method_1728((class_5348)signLineHint, maxLineWidth).stream().map(cs -> PrecomputedComponentDims.of(cs, AbstractSignEditScreenProcessor.minecraft.field_1772)).toList();
    }
}

