/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.event.MappingEvent;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointFactory;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystoneRemoveReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdateReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystonesListReceivedEvent;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

@JourneyMapPlugin(apiVersion="2.0.0")
public class JourneyMapIntegration
implements IClientPlugin {
    private static final Gson gson = new Gson();
    private IClientAPI api;
    private boolean journeyMapReady;
    private final Map<UUID, String> waystoneToWaypoint = new HashMap<UUID, String>();
    private final List<Runnable> scheduledJobsWhenReady = new ArrayList<Runnable>();
    private static JourneyMapIntegration instance;

    public JourneyMapIntegration() {
        instance = this;
        Balm.events().onEvent(WaystonesListReceivedEvent.class, this::onWaystonesListReceived);
        Balm.events().onEvent(WaystoneUpdateReceivedEvent.class, this::onWaystoneUpdateReceived);
        Balm.events().onEvent(WaystoneRemoveReceivedEvent.class, this::onWaystoneRemoveReceived);
    }

    public void initialize(IClientAPI iClientAPI) {
        this.api = iClientAPI;
        ClientEventRegistry.MAPPING_EVENT.subscribe("waystones", this::onMappingEvent);
    }

    @Nullable
    public static JourneyMapIntegration getInstance() {
        return instance;
    }

    public String getModId() {
        return "waystones";
    }

    public void onMappingEvent(MappingEvent event) {
        if (event.getStage() == MappingEvent.Stage.MAPPING_STARTED) {
            List waypoints = this.api.getWaypoints("waystones");
            for (Waypoint waypoint : waypoints) {
                WaystonesWaypointData.decode(waypoint.getCustomData()).ifPresent(customData -> this.waystoneToWaypoint.put(customData.waystoneId(), waypoint.getGuid()));
            }
            this.journeyMapReady = true;
            for (Runnable scheduledJob : this.scheduledJobsWhenReady) {
                scheduledJob.run();
            }
            this.scheduledJobsWhenReady.clear();
        } else if (event.getStage() == MappingEvent.Stage.MAPPING_STOPPED) {
            this.journeyMapReady = false;
            this.waystoneToWaypoint.clear();
        }
    }

    public void onWaystonesListReceived(WaystonesListReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.updateAllWaypoints(event.getWaystoneType(), event.getWaystones()));
        }
    }

    private boolean isSupportedWaystoneType(class_2960 waystoneType) {
        return waystoneType.equals((Object)WaystoneTypes.WAYSTONE) || WaystoneTypes.isSharestone(waystoneType);
    }

    private static boolean shouldManageWaypoints() {
        WaystonesConfig config = WaystonesConfig.getActive();
        if (config.compatibility.preferJourneyMapIntegrationMod && Balm.platform().isModLoaded("jmi")) {
            return false;
        }
        return config.compatibility.journeyMap;
    }

    public void onWaystoneUpdateReceived(WaystoneUpdateReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystone().getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.updateWaypoint(event.getWaystone()));
        }
    }

    public void onWaystoneRemoveReceived(WaystoneRemoveReceivedEvent event) {
        if (JourneyMapIntegration.shouldManageWaypoints() && this.isSupportedWaystoneType(event.getWaystoneType())) {
            this.runWhenJourneyMapIsReady(() -> this.removeWaypoint(event.getWaystoneId()));
        }
    }

    private void runWhenJourneyMapIsReady(Runnable runnable) {
        if (this.journeyMapReady) {
            runnable.run();
        } else {
            this.scheduledJobsWhenReady.add(runnable);
        }
    }

    private void updateAllWaypoints(class_2960 waystoneType, List<Waystone> waystones) {
        HashSet<UUID> stillExistingIds = new HashSet<UUID>();
        for (Waystone waystone : waystones) {
            stillExistingIds.add(waystone.getWaystoneUid());
            this.updateWaypoint(waystone);
        }
        List waypoints = this.api.getWaypoints("waystones");
        for (Waypoint waypoint : waypoints) {
            WaystonesWaypointData.decode(waypoint.getCustomData()).ifPresent(customData -> {
                UUID waystoneUid = customData.waystoneId();
                if (waystoneType.equals((Object)customData.waystoneType()) && !stillExistingIds.contains(waystoneUid)) {
                    this.api.removeWaypoint("waystones", waypoint);
                    this.waystoneToWaypoint.remove(waystoneUid);
                }
            });
        }
    }

    private void removeWaypoint(UUID waystoneId) {
        String waypointId = this.waystoneToWaypoint.get(waystoneId);
        if (waypointId != null) {
            Waypoint waypoint = this.api.getWaypoint("waystones", waypointId);
            if (waypoint != null) {
                this.api.removeWaypoint("waystones", waypoint);
            }
            this.waystoneToWaypoint.remove(waystoneId);
        }
    }

    private void updateWaypoint(Waystone waystone) {
        try {
            Waypoint waypoint;
            String waypointId = this.waystoneToWaypoint.get(waystone.getWaystoneUid());
            class_2561 waystoneName = waystone.hasName() ? waystone.getName() : class_2561.method_43471((String)"waystones.map.untitled_waystone");
            Waypoint oldWaypoint = waypointId != null ? this.api.getWaypoint("waystones", waypointId) : null;
            Waypoint waypoint2 = waypoint = oldWaypoint != null ? oldWaypoint : WaypointFactory.createClientWaypoint((String)"waystones", (class_2338)waystone.getPos().method_10086(2), (String)waystoneName.getString(), waystone.getDimension(), (boolean)true);
            if (oldWaypoint != null) {
                oldWaypoint.setName(waystoneName.getString());
                waypoint.setPos(waystone.getPos().method_10263(), waystone.getPos().method_10264() + 2, waystone.getPos().method_10260());
                waypoint.setPrimaryDimension(waystone.getDimension());
            }
            waypoint.setCustomData(new WaystonesWaypointData(waystone.getWaystoneUid(), waystone.getWaystoneType()).encode());
            if (oldWaypoint == null) {
                this.api.addWaypoint("waystones", waypoint);
                WaypointGroup group = this.getWaystoneGroup(waystone);
                if (group != null) {
                    group.addWaypoint(waypoint);
                }
            }
            this.waystoneToWaypoint.put(waystone.getWaystoneUid(), waypoint.getGuid());
        }
        catch (Exception e) {
            Waystones.logger.warn("Failed to update waypoint for waystone {}", (Object)waystone.getWaystoneUid(), (Object)e);
        }
    }

    private WaypointGroup getWaystoneGroup(Waystone waystone) {
        if (WaystoneTypes.isSharestone(waystone.getWaystoneType())) {
            return Optional.ofNullable(this.api.getWaypointGroupByName("waystones", "Sharestones")).orElseGet(() -> {
                WaypointGroup group = WaypointFactory.createWaypointGroup((String)"waystones", (String)"Sharestones");
                group.setLocked(true);
                this.api.addWaypointGroup(group);
                return group;
            });
        }
        return Optional.ofNullable(this.api.getWaypointGroupByName("waystones", "Waystones")).orElseGet(() -> {
            WaypointGroup group = WaypointFactory.createWaypointGroup((String)"waystones", (String)"Waystones");
            group.setLocked(true);
            this.api.addWaypointGroup(group);
            return group;
        });
    }

    private record WaystonesWaypointData(UUID waystoneId, class_2960 waystoneType) {
        private static final MapCodec<WaystonesWaypointData> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_4844.field_25122.fieldOf("waystoneId").forGetter(WaystonesWaypointData::waystoneId), (App)class_2960.field_25139.fieldOf("type").forGetter(WaystonesWaypointData::waystoneType)).apply((Applicative)builder, WaystonesWaypointData::new));

        public static Optional<WaystonesWaypointData> decode(String customData) {
            JsonElement jsonElement = (JsonElement)gson.fromJson(customData, JsonElement.class);
            return JsonOps.INSTANCE.getMap(jsonElement).flatMap(it -> CODEC.decode((DynamicOps)JsonOps.INSTANCE, it)).resultOrPartial();
        }

        public String encode() {
            JsonElement jsonElement = (JsonElement)CODEC.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, JsonOps.INSTANCE.mapBuilder()).build((Object)JsonOps.INSTANCE.empty()).getOrThrow();
            return gson.toJson(jsonElement);
        }
    }
}

