/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.collect.ListMultiMap;
import mezz.jei.library.gui.GuiContainerHandlers;
import mezz.jei.library.gui.helpers.ScreenHelper;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import org.jetbrains.annotations.Unmodifiable;

public class GuiHandlerRegistration
implements IGuiHandlerRegistration {
    private final GuiContainerHandlers guiContainerHandlers = new GuiContainerHandlers();
    private final List<IGlobalGuiHandler> globalGuiHandlers = new ArrayList<IGlobalGuiHandler>();
    private final Map<Class<?>, IScreenHandler<?>> guiScreenHandlers = new HashMap();
    private final ListMultiMap<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers = new ListMultiMap();
    private final IJeiHelpers jeiHelpers;
    private static final @Unmodifiable List<Class<? extends class_437>> ghostIngredientGuiBlacklist = List.of(class_437.class, class_490.class, class_481.class);

    public GuiHandlerRegistration(IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    @Override
    public <T extends class_465<?>> void addGuiContainerHandler(Class<? extends T> guiClass, IGuiContainerHandler<T> guiHandler) {
        ErrorUtil.checkNotNull(guiClass, "guiClass");
        ErrorUtil.checkNotNull(guiHandler, "guiHandler");
        this.guiContainerHandlers.add(guiClass, guiHandler);
    }

    @Override
    public <T extends class_465<?>> void addGenericGuiContainerHandler(Class<? extends T> guiClass, IGuiContainerHandler<?> guiHandler) {
        ErrorUtil.checkNotNull(guiClass, "guiClass");
        ErrorUtil.checkNotNull(guiHandler, "guiHandler");
        this.guiContainerHandlers.add(guiClass, guiHandler);
    }

    @Override
    public void addGlobalGuiHandler(IGlobalGuiHandler globalGuiHandler) {
        ErrorUtil.checkNotNull(globalGuiHandler, "globalGuiHandler");
        this.globalGuiHandlers.add(globalGuiHandler);
    }

    @Override
    public <T extends class_437> void addGuiScreenHandler(Class<T> guiClass, IScreenHandler<T> handler) {
        ErrorUtil.checkNotNull(guiClass, "guiClass");
        Preconditions.checkArgument((boolean)class_437.class.isAssignableFrom(guiClass), (Object)"guiClass must inherit from Screen");
        Preconditions.checkArgument((!class_437.class.equals(guiClass) ? 1 : 0) != 0, (Object)"you cannot add a handler for Screen, only a subclass.");
        ErrorUtil.checkNotNull(handler, "guiScreenHandler");
        this.guiScreenHandlers.put(guiClass, handler);
    }

    @Override
    public <T extends class_437> void addGenericGuiScreenHandler(Class<T> guiClass, IScreenHandler<?> handler) {
        ErrorUtil.checkNotNull(guiClass, "guiClass");
        ErrorUtil.checkNotNull(handler, "handler");
        this.guiScreenHandlers.put(guiClass, handler);
    }

    @Override
    public <T extends class_437> void addGhostIngredientHandler(Class<T> guiClass, IGhostIngredientHandler<T> handler) {
        ErrorUtil.checkNotNull(guiClass, "guiClass");
        Preconditions.checkArgument((boolean)class_437.class.isAssignableFrom(guiClass), (Object)"guiClass must inherit from Screen");
        Preconditions.checkArgument((!ghostIngredientGuiBlacklist.contains(guiClass) ? 1 : 0) != 0, (String)"you cannot add a ghost ingredient handler for the following Guis, it would interfere with using JEI: %s", ghostIngredientGuiBlacklist);
        ErrorUtil.checkNotNull(handler, "handler");
        this.ghostIngredientHandlers.put(guiClass, handler);
    }

    public IScreenHelper createGuiScreenHelper(IIngredientManager ingredientManager) {
        return new ScreenHelper(ingredientManager, this.globalGuiHandlers, this.guiContainerHandlers, this.ghostIngredientHandlers, this.guiScreenHandlers);
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }
}

