/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.animation;

import com.google.common.collect.ImmutableList;
import io.github.foundationgames.animatica.Animatica;
import io.github.foundationgames.animatica.animation.AnimationMeta;
import io.github.foundationgames.animatica.util.TextureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class AnimatedTexture
extends class_1043
implements class_1061 {
    public static final ExecutorService EXECUTORS = Executors.newFixedThreadPool(4);
    public final Animation[] anims;
    private final class_1011 original;
    private int frame = 0;
    private CompletableFuture<Void> frameWaitingOn = null;

    public static Optional<AnimatedTexture> tryCreate(class_3300 resources, class_2960 targetTexId, List<AnimationMeta> anims) {
        Optional<AnimatedTexture> optional;
        block8: {
            InputStream targetTexResource = resources.getResourceOrThrow(targetTexId).method_14482();
            try {
                optional = Optional.of(new AnimatedTexture(() -> ((class_2960)targetTexId).toString(), resources, anims, class_1011.method_4309((InputStream)targetTexResource)));
                if (targetTexResource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (targetTexResource != null) {
                        try {
                            targetTexResource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Animatica.LOG.error((Object)e);
                    return Optional.empty();
                }
            }
            targetTexResource.close();
        }
        return optional;
    }

    public AnimatedTexture(Supplier<String> name, class_3300 resources, List<AnimationMeta> metas, class_1011 image) throws IOException {
        super(name, image.method_4307(), image.method_4323(), true);
        this.anims = new Animation[metas.size()];
        for (int i = 0; i < metas.size(); ++i) {
            this.anims[i] = new Animation(metas.get(i), resources);
        }
        this.original = image;
        this.updateAndDraw(this.method_4525(), true, (Executor)class_310.method_1551());
        this.method_4524();
    }

    public boolean canLoop() {
        for (Animation anim : this.anims) {
            if (anim.isOnFrameZero()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private CompletableFuture<Void> getFrameWaitingOn() {
        if (this.frameWaitingOn != null && this.frameWaitingOn.isDone()) {
            this.frameWaitingOn = null;
        }
        return this.frameWaitingOn;
    }

    public void updateAndDraw(class_1011 image, boolean force, Executor exec) {
        boolean changed = false;
        if (this.canLoop()) {
            if (this.frame > 0) {
                this.frame = 0;
            }
        } else if (this.frame <= 0) {
            changed = true;
        }
        for (Animation anim : this.anims) {
            if (!anim.isChanged()) continue;
            changed = true;
            break;
        }
        if ((changed || force) && this.getFrameWaitingOn() == null) {
            this.frameWaitingOn = CompletableFuture.runAsync(() -> {
                image.method_4317(this.original);
                for (Animation anim : this.anims) {
                    Phase phase = anim.getCurrentPhase();
                    if (phase instanceof InterpolatedPhase) {
                        InterpolatedPhase iPhase = (InterpolatedPhase)phase;
                        TextureUtil.blendCopy(anim.sourceTexture, 0, iPhase.prevV, 0, iPhase.v, anim.width, anim.height, image, anim.targetX, anim.targetY, iPhase.blend.getBlend(anim.getPhaseFrame()));
                        continue;
                    }
                    TextureUtil.copy(anim.sourceTexture, 0, phase.v, anim.width, anim.height, image, anim.targetX, anim.targetY);
                }
            }, exec).thenAccept(v -> class_310.method_1551().execute(() -> ((AnimatedTexture)this).method_4524()));
        }
        for (Animation anim : this.anims) {
            anim.advance();
        }
        ++this.frame;
    }

    public void method_4622() {
        this.updateAndDraw(this.method_4525(), false, EXECUTORS);
    }

    public void close() {
        for (Animation anim : this.anims) {
            anim.close();
        }
        this.original.close();
        super.close();
    }

    public static class Animation
    implements AutoCloseable {
        private final List<Phase> phases;
        public final class_1011 sourceTexture;
        public final int targetX;
        public final int targetY;
        public final int width;
        public final int height;
        private final int duration;
        private int frame = 0;
        private Phase currentPhase = null;
        private int phaseFrame = 0;
        private boolean changed = true;

        public Animation(AnimationMeta meta, class_3300 resources) throws IOException {
            this.targetX = meta.targetX();
            this.targetY = meta.targetY();
            this.width = meta.width();
            this.height = meta.height();
            try (InputStream source = resources.getResourceOrThrow(meta.source()).method_14482();){
                this.sourceTexture = class_1011.method_4309((InputStream)source);
            }
            ImmutableList.Builder phases = ImmutableList.builder();
            int duration = 0;
            int textureFrameCount = (int)Math.floor((float)this.sourceTexture.method_4323() / (float)meta.height());
            int animFrameCount = Math.max(textureFrameCount, meta.getGreatestUsedFrame() + 1);
            ArrayList<int[]> frames = new ArrayList<int[]>();
            for (int f = 0; f < animFrameCount; ++f) {
                if (f >= textureFrameCount && !meta.frameMapping().containsKey(f)) continue;
                frames.add(new int[]{meta.frameMapping().getOrDefault(f, f), meta.frameDurations().getOrDefault(f, meta.defaultFrameDuration())});
            }
            for (int i = 0; i < frames.size(); ++i) {
                int[] frame = (int[])frames.get(i);
                int fMap = frame[0];
                int fDuration = frame[1];
                int v = this.getVForFrame(fMap, textureFrameCount);
                int nextV = this.getVForFrame(((int[])frames.get(Math.floorMod(i + 1, frames.size())))[0], textureFrameCount);
                if (meta.interpolate()) {
                    if (meta.interpolationDelay() > 0) {
                        phases.add((Object)new Phase(meta.interpolationDelay(), v));
                        duration += meta.interpolationDelay();
                    }
                    int interpolatedDuration = fDuration - meta.interpolationDelay();
                    phases.add((Object)new InterpolatedPhase(interpolatedDuration, v, nextV, phaseFrame -> (float)phaseFrame / (float)interpolatedDuration));
                    duration += interpolatedDuration;
                    continue;
                }
                phases.add((Object)new Phase(fDuration, v));
                duration += fDuration;
            }
            this.duration = duration;
            this.phases = phases.build();
            this.updateCurrentPhase();
        }

        public void updateCurrentPhase() {
            this.changed = false;
            int progress = this.frame;
            for (Phase phase : this.phases) {
                if ((progress -= phase.duration) >= 0) continue;
                if (this.currentPhase != phase) {
                    this.changed = true;
                }
                if (phase instanceof InterpolatedPhase) {
                    InterpolatedPhase iPhase = (InterpolatedPhase)phase;
                    this.changed = iPhase.hasChangingV();
                }
                this.currentPhase = phase;
                this.phaseFrame = phase.duration + progress;
                return;
            }
        }

        public Phase getCurrentPhase() {
            return this.currentPhase;
        }

        public int getPhaseFrame() {
            return this.phaseFrame;
        }

        public boolean isOnFrameZero() {
            return this.frame <= 0;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void advance() {
            ++this.frame;
            if (this.frame >= this.duration) {
                this.frame = 0;
            }
            this.updateCurrentPhase();
        }

        @Override
        public void close() {
            this.sourceTexture.close();
        }

        private int getVForFrame(int frame, int textureFrameCount) {
            return class_3532.method_15340((int)(frame * this.height), (int)0, (int)((textureFrameCount - 1) * this.height));
        }
    }

    public static class Phase {
        public final int duration;
        public final int v;

        public Phase(int duration, int v) {
            this.duration = duration;
            this.v = v;
        }

        public String toString() {
            return "Animation Bakery Phase { v: " + this.v + " }";
        }
    }

    public static class InterpolatedPhase
    extends Phase {
        public final int prevV;
        public final BlendInterpolator blend;

        public InterpolatedPhase(int duration, int v1, int v2, BlendInterpolator blend) {
            super(duration, v2);
            this.prevV = v1;
            this.blend = blend;
        }

        public boolean hasChangingV() {
            return this.prevV != this.v;
        }
    }

    @FunctionalInterface
    public static interface BlendInterpolator {
        public float getBlend(int var1);
    }
}

