/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.GuiControls;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiControlClickEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiEventManager;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.manager.GuiManagerDist;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiParent
extends GuiControl
implements IGuiParent,
Iterable<GuiControl> {
    private GuiEventManager eventManager;
    private final GuiControls controls = new GuiControls();

    public GuiParent(IGuiParent parent, String name, GuiFlow flow) {
        super(parent, name);
        if (this.dist() != null) {
            this.dist().setFlow(flow);
            this.dist().initControlList(this.controls);
        }
    }

    public GuiParent(IGuiParent parent, String name, GuiFlow flow, VAlign valign) {
        this(parent, name, flow, Align.LEFT, valign);
    }

    public GuiParent(IGuiParent parent, String name, GuiFlow flow, Align align) {
        this(parent, name, flow, align, VAlign.TOP);
    }

    public GuiParent(IGuiParent parent, String name, GuiFlow flow, Align align, VAlign valign) {
        this(parent, name, flow);
        if (this.dist() != null) {
            this.dist().setAlign(align);
            this.dist().setVAlign(valign);
        }
    }

    public GuiParent(IGuiParent parent, String name) {
        this(parent, name, GuiFlow.STACK_X);
    }

    public GuiParent(IGuiParent parent) {
        this(parent, "");
    }

    public GuiParent(IGuiParent parent, GuiFlow flow) {
        this(parent, "", flow);
    }

    @Override
    @Nullable
    public GuiParentDistHandler dist() {
        return (GuiParentDistHandler)super.dist();
    }

    @Override
    public boolean isClient() {
        return this.getParent().isClient();
    }

    public GuiParent setScale(double scale) {
        if (this.dist() != null) {
            this.dist().setScale(scale);
        }
        return this;
    }

    public GuiParent setAlign(Align align) {
        if (this.dist() != null) {
            this.dist().setAlign(align);
        }
        return this;
    }

    public GuiParent setVAlign(VAlign valign) {
        if (this.dist() != null) {
            this.dist().setVAlign(valign);
        }
        return this;
    }

    public GuiParent setSpacing(int spacing) {
        if (this.dist() != null) {
            this.dist().setSpacing(spacing);
        }
        return this;
    }

    public GuiParent setFlow(GuiFlow flow) {
        if (this.dist() != null) {
            this.dist().setFlow(flow);
        }
        return this;
    }

    @Override
    public boolean isExpandableX() {
        if (super.isExpandableX()) {
            return true;
        }
        for (GuiControl control : this.controls) {
            if (!control.isExpandableX()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpandableY() {
        if (super.isExpandableY()) {
            return true;
        }
        for (GuiControl control : this.controls) {
            if (!control.isExpandableY()) continue;
            return true;
        }
        return false;
    }

    public <T extends GuiControl> T get(String name) {
        if (name.isBlank()) {
            return (T)this;
        }
        return this.controls.get(name);
    }

    public <T extends GuiControl> T get(String name, Class<T> clazz) {
        T result = this.get(name);
        if (clazz.isInstance(result)) {
            return result;
        }
        return null;
    }

    public boolean has(String name) {
        return this.get(name) != null;
    }

    public <T extends GuiControl> T insertControlBefore(GuiControl reference, T toInsert) {
        return this.controls.insertControlBefore(reference, toInsert);
    }

    public <T extends GuiControl> T insertControlAfter(GuiControl reference, T toInsert) {
        return this.controls.insertControlAfter(reference, toInsert);
    }

    public GuiParent add(GuiControl control) {
        this.controls.add(control);
        GuiParent.setParent(control, this);
        return this;
    }

    public GuiParent add(GuiControl ... controls) {
        for (GuiControl c : controls) {
            this.add(c);
        }
        return this;
    }

    public GuiParent add(boolean conditional, Supplier<GuiControl> controlSupplier) {
        if (conditional) {
            return this.add(controlSupplier.get());
        }
        return this;
    }

    public GuiParent addHover(GuiControl control) {
        this.controls.addHover(control);
        return this;
    }

    public GuiParent addHover(GuiControl ... controls) {
        for (GuiControl c : controls) {
            this.addHover(c);
        }
        return this;
    }

    public GuiParent addHover(boolean conditional, Supplier<GuiControl> controlSupplier) {
        if (conditional) {
            return this.addHover(controlSupplier.get());
        }
        return this;
    }

    public boolean remove(GuiControl control) {
        return this.controls.remove(control);
    }

    public GuiControl remove(int index) {
        return this.controls.remove(index);
    }

    public boolean replace(GuiControl oldControl, GuiControl newControl) {
        return this.controls.replace(oldControl, newControl);
    }

    public void remove(String ... include) {
        this.controls.remove(include);
    }

    public void removeExclude(String ... exclude) {
        this.controls.removeExclude(exclude);
    }

    public boolean isEmpty() {
        return this.controls.isEmpty();
    }

    public void clear() {
        this.controls.clear();
    }

    public GuiControl get(int index) {
        return this.controls.get(index);
    }

    public int totalSize() {
        return this.controls.totalSize();
    }

    public int size() {
        return this.controls.controlSize();
    }

    @Override
    public Iterator<GuiControl> iterator() {
        return this.controls.iterator();
    }

    @Override
    public boolean isContainer() {
        return this.getParent().isContainer();
    }

    @Override
    public void init() {
        for (GuiControl control : this) {
            control.init();
        }
    }

    @Override
    public void closed() {
        for (GuiControl control : this) {
            control.closed();
        }
    }

    @Override
    public void tick() {
        for (GuiControl control : this) {
            control.tick();
        }
    }

    @Override
    public void closeTopLayer() {
        this.getParent().closeTopLayer();
    }

    public void closeThisLayer() {
        this.getParent().closeLayer(this.getLayer());
    }

    @Override
    public void closeLayer(GuiLayer layer) {
        this.getParent().closeLayer(layer);
    }

    @Override
    public void raiseEvent(GuiEvent event) {
        if (this.getParent() == null) {
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.raiseEvent(event);
        }
        if (!event.isCanceled()) {
            this.getParent().raiseEvent(event);
        }
    }

    public void registerEventClick(Consumer<GuiControlClickEvent> consumer) {
        this.registerEvent(GuiControlClickEvent.class, consumer);
    }

    public void registerEventChanged(Consumer<GuiControlChangedEvent> consumer) {
        this.registerEvent(GuiControlChangedEvent.class, consumer);
    }

    public <E extends GuiEvent> void registerEvent(Class<E> clazz, Consumer<E> action) {
        if (this.eventManager == null) {
            this.eventManager = new GuiEventManager();
        }
        this.eventManager.registerEvent(clazz, action);
    }

    public void clearEvents() {
        if (this.eventManager != null) {
            this.eventManager.clear();
        }
    }

    @Override
    public String getNestedName() {
        if (this.name.isBlank()) {
            if (this.getParent() instanceof GuiControl) {
                return ((GuiControl)((Object)this.getParent())).getNestedName();
            }
            return "";
        }
        return super.getNestedName();
    }

    @Override
    public Rect toLayerRect(GuiControl control, Rect rect) {
        if (this.dist() != null) {
            this.dist().applyOffset(control, rect);
        }
        return this.getParent().toLayerRect(this, rect);
    }

    @Override
    public Rect toScreenRect(GuiControl control, Rect rect) {
        if (this.dist() != null) {
            this.dist().applyOffset(control, rect);
        }
        return this.getParent().toScreenRect(this, rect);
    }

    @Override
    public GuiControlDistHandler createDist(GuiControl control) {
        return this.getParent().createDist(control);
    }

    @Override
    public <T extends GuiManagerDist> T createDist(GuiManager<T> manager) {
        return this.getParent().createDist(manager);
    }

    public static interface GuiParentDistHandler
    extends GuiControlDistHandler {
        public void setScale(double var1);

        public void setAlign(Align var1);

        public void setVAlign(VAlign var1);

        public void setSpacing(int var1);

        public void setFlow(GuiFlow var1);

        public void initControlList(GuiControls var1);

        public void applyOffset(GuiControl var1, Rect var2);

        public Iterable<? extends GuiControlDistHandler> controls();

        public Iterable<? extends GuiControlDistHandler> hoverControls();

        public Iterable<? extends GuiControlDistHandler> all();
    }
}

