/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.item;

import com.zurrtum.create.AllTransfer;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.item.InventoryCache;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3954;
import net.minecraft.class_6885;
import net.minecraft.class_9288;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    private static final Map<class_2338, InventoryCache> INV_CACHE = new Object2ReferenceOpenHashMap();

    public static boolean sameItem(class_1799 stack, class_1799 otherStack) {
        return !otherStack.method_7960() && stack.method_31574(otherStack.method_7909());
    }

    public static Predicate<class_1799> sameItemPredicate(class_1799 stack) {
        return s -> ItemHelper.sameItem(stack, s);
    }

    public static List<class_1799> multipliedOutput(class_1799 out, int count) {
        if (out.method_7960()) {
            return new ArrayList<class_1799>();
        }
        int total = count * out.method_7947();
        int max = out.method_7914();
        int size = total / max;
        int remaining = total % max;
        boolean hasRemaining = remaining != 0;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(hasRemaining ? size + 1 : size);
        stacks.add(out);
        if (size != 0) {
            out.method_7939(max);
            for (int i = 1; i < size; ++i) {
                stacks.add(out.method_7972());
            }
            if (hasRemaining) {
                stacks.add(out.method_46651(remaining));
            }
        } else {
            out.method_7939(total);
        }
        return stacks;
    }

    public static List<class_1799> multipliedOutput(List<class_1799> out, int count) {
        if (out.isEmpty()) {
            return new ArrayList<class_1799>();
        }
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (class_1799 stack : out) {
            int total = count * stack.method_7947();
            int max = stack.method_7914();
            int size = total / max;
            stacks.add(stack);
            if (size != 0) {
                stack.method_7939(max);
                for (int i = 1; i < size; ++i) {
                    stacks.add(stack.method_7972());
                }
                int remaining = total % max;
                if (remaining == 0) continue;
                stacks.add(stack.method_46651(remaining));
                continue;
            }
            stack.method_7939(total);
        }
        return stacks;
    }

    public static void addToList(class_1799 stack, List<class_1799> stacks) {
        for (class_1799 s : stacks) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)s)) continue;
            int transferred = Math.min(s.method_7914() - s.method_7947(), stack.method_7947());
            s.method_7933(transferred);
            stack.method_7934(transferred);
        }
        if (stack.method_7947() > 0) {
            stacks.add(stack);
        }
    }

    public static <T extends IBE<? extends class_2586>> int calcRedstoneFromBlockEntity(T ibe, class_1937 level, class_2338 pos) {
        return ibe.getBlockEntityOptional((class_1922)level, pos).map(be -> ItemHelper.getInventory(level, pos, null)).map(ItemHelper::calcRedstoneFromInventory).orElse(0);
    }

    public static int calcRedstoneFromInventory(@Nullable class_1263 inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        int totalSlots = inv.method_5439();
        int size = totalSlots;
        for (int j = 0; j < size; ++j) {
            int slotLimit = inv.method_5444();
            if (slotLimit == 0) {
                --totalSlots;
                continue;
            }
            class_1799 itemstack = inv.method_5438(j);
            if (itemstack.method_7960()) continue;
            f += (float)itemstack.method_7947() / (float)Math.min(slotLimit, itemstack.method_7914());
            ++i;
        }
        if (totalSlots == 0) {
            return 0;
        }
        return class_3532.method_15375((float)((f /= (float)totalSlots) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static boolean matchIngredients(class_1856 i1, class_1856 i2) {
        if (i1 == i2) {
            return true;
        }
        class_6885 entries1 = i1.field_9019;
        class_6885 entries2 = i2.field_9019;
        Optional tag1 = entries1.method_45925();
        Optional tag2 = entries2.method_45925();
        if (tag1.isPresent()) {
            return tag2.map(tag -> tag.equals(tag1.get())).orElse(false);
        }
        if (tag2.isPresent()) {
            return false;
        }
        int size = entries1.method_40247();
        if (size == entries2.method_40247()) {
            for (int i = 0; i < size; ++i) {
                if (entries1.method_40241(entries2.method_40240(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean matchAllIngredients(List<class_1856> ingredients) {
        if (ingredients.size() <= 1) {
            return true;
        }
        class_1856 firstIngredient = ingredients.getFirst();
        for (int i = 1; i < ingredients.size(); ++i) {
            if (ItemHelper.matchIngredients(firstIngredient, ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class_1799 extractItem(class_1263 inventory, int slot, int amount, boolean simulate) {
        class_1278 sidedInventory;
        class_1799 stack = inventory.method_5438(slot);
        if (stack.method_7960() || inventory instanceof class_1278 && !(sidedInventory = (class_1278)inventory).method_5493(slot, stack, null)) {
            return class_1799.field_8037;
        }
        int extract = Math.min(amount, stack.method_7947());
        if (simulate) {
            return stack.method_46651(extract);
        }
        if (extract == amount) {
            inventory.method_5447(slot, class_1799.field_8037);
            inventory.method_5431();
            return stack;
        }
        class_1799 result = stack.method_7972();
        result.method_7939(extract);
        stack.method_7934(extract);
        inventory.method_5431();
        return result;
    }

    public static boolean canItemStackAmountsStack(class_1799 a, class_1799 b) {
        return class_1799.method_31577((class_1799)a, (class_1799)b) && a.method_7947() + b.method_7947() <= a.method_7914();
    }

    public static class_1799 fromItemEntity(class_1297 entityIn) {
        class_1799 class_17992;
        if (!entityIn.method_5805()) {
            return class_1799.field_8037;
        }
        if (entityIn instanceof PackageEntity) {
            PackageEntity packageEntity = (PackageEntity)entityIn;
            return packageEntity.getBox();
        }
        if (entityIn instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entityIn;
            class_17992 = itemEntity.method_6983();
        } else {
            class_17992 = class_1799.field_8037;
        }
        return class_17992;
    }

    public static void fillItemStackHandler(class_9288 contents, ItemStackHandler inv) {
        List itemStacks = contents.method_57489().toList();
        for (int i = 0; i < itemStacks.size(); ++i) {
            inv.method_5447(i, (class_1799)itemStacks.get(i));
        }
    }

    public static class_9288 containerContentsFromHandler(ItemStackHandler handler) {
        return class_9288.method_57493(handler.getStacks());
    }

    public static class_1799 limitCountToMaxStackSize(class_1799 stack, boolean simulate) {
        int max;
        int count = stack.method_7947();
        if (count <= (max = stack.method_7914())) {
            return class_1799.field_8037;
        }
        class_1799 remainder = stack.method_46651(count - max);
        if (!simulate) {
            stack.method_7939(max);
        }
        return remainder;
    }

    public static void copyContents(class_1263 from, class_1263 to) {
        if (from.method_5439() != to.method_5439()) {
            throw new IllegalArgumentException("Slot count mismatch");
        }
        for (int slot = to.method_5439() - 1; slot >= 0; --slot) {
            to.method_5447(slot, class_1799.field_8037);
        }
        for (int i = 0; i < from.method_5439(); ++i) {
            to.method_5447(i, from.method_5438(i).method_7972());
        }
    }

    public static List<class_1799> getNonEmptyStacks(ItemStackHandler handler) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int size = handler.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = handler.method_5438(i);
            if (stack.method_7960()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static class_1263 getInventory(class_1937 world, class_2338 pos, class_2350 direction) {
        return ItemHelper.getInventory(world, pos, null, null, direction);
    }

    public static class_1263 getInventory(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity, class_2350 direction) {
        class_2248 block;
        if (state == null) {
            class_2680 class_26802 = state = blockEntity != null ? blockEntity.method_11010() : world.method_8320(pos);
        }
        if ((block = state.method_26204()) instanceof ItemInventoryProvider) {
            ItemInventoryProvider provider = (ItemInventoryProvider)block;
            return provider.getInventory(state, (class_1936)world, pos, blockEntity, direction);
        }
        if (block instanceof class_3954) {
            class_3954 provider = (class_3954)block;
            return provider.method_17680(state, (class_1936)world, pos);
        }
        if (blockEntity == null && state.method_31709()) {
            blockEntity = world.method_8321(pos);
        }
        if (blockEntity instanceof class_1263) {
            class_1263 inventory = (class_1263)blockEntity;
            if (inventory instanceof class_2595 && block instanceof class_2281) {
                class_2281 chestBlock = (class_2281)block;
                inventory = class_2281.method_17458((class_2281)chestBlock, (class_2680)state, (class_1937)world, (class_2338)pos, (boolean)true);
            }
            return inventory;
        }
        return AllTransfer.getInventory(world, pos, state, blockEntity, direction);
    }

    public static Supplier<class_1263> getInventoryCache(class_3218 world, class_2338 pos, class_2350 direction, BiPredicate<class_2586, class_2350> filter) {
        InventoryCache cache = new InventoryCache(world, pos, direction, filter);
        INV_CACHE.put(pos, cache);
        return cache;
    }

    public static void invalidateInventoryCache(class_2338 pos) {
        InventoryCache cache = INV_CACHE.get(pos);
        if (cache != null) {
            cache.invalidate();
        }
    }

    public static enum ExtractionCountMode {
        EXACTLY,
        UPTO;

    }
}

