/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.bogey;

import com.zurrtum.create.content.trains.bogey.BogeySize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.UnmodifiableView;

public class AllBogeySizes {
    private static final Map<class_2960, BogeySize> BOGEY_SIZES = new HashMap<class_2960, BogeySize>();
    private static final List<BogeySize> SORTED_INCREASING = new ArrayList<BogeySize>();
    private static final List<BogeySize> SORTED_DECREASING = new ArrayList<BogeySize>();
    private static final @UnmodifiableView Map<class_2960, BogeySize> BOGEY_SIZES_VIEW = Collections.unmodifiableMap(BOGEY_SIZES);
    private static final @UnmodifiableView List<BogeySize> SORTED_INCREASING_VIEW = Collections.unmodifiableList(SORTED_INCREASING);
    private static final @UnmodifiableView List<BogeySize> SORTED_DECREASING_VIEW = Collections.unmodifiableList(SORTED_DECREASING);
    public static final BogeySize SMALL = AllBogeySizes.register("small", 6.5f);
    public static final BogeySize LARGE = AllBogeySizes.register("large", 12.5f);

    private static BogeySize register(String id, float radius) {
        BogeySize size = new BogeySize(class_2960.method_60655((String)"create", (String)id), radius / 16.0f);
        AllBogeySizes.register(size);
        return size;
    }

    public static void register(BogeySize size) {
        class_2960 id = size.id();
        if (BOGEY_SIZES.containsKey(id)) {
            throw new IllegalArgumentException();
        }
        BOGEY_SIZES.put(id, size);
        SORTED_INCREASING.add(size);
        SORTED_DECREASING.add(size);
        SORTED_INCREASING.sort(Comparator.comparing(BogeySize::wheelRadius));
        SORTED_DECREASING.sort(Comparator.comparing(BogeySize::wheelRadius).reversed());
    }

    public static @UnmodifiableView Map<class_2960, BogeySize> all() {
        return BOGEY_SIZES_VIEW;
    }

    public static @UnmodifiableView List<BogeySize> allSortedIncreasing() {
        return SORTED_INCREASING_VIEW;
    }

    public static @UnmodifiableView List<BogeySize> allSortedDecreasing() {
        return SORTED_DECREASING_VIEW;
    }

    public static void register() {
    }
}

