/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public interface BasinRecipe
extends CreateRecipe<BasinInput> {
    public static final Map<class_1867, List<SizedIngredient>> SHAPELESS_CACHE = new IdentityHashMap<class_1867, List<SizedIngredient>>();
    public static final Map<class_1869, List<SizedIngredient>> SHAPED_CACHE = new IdentityHashMap<class_1869, List<SizedIngredient>>();

    public static boolean matchCraftingRecipe(BasinInput input, class_1867 recipe, class_1937 world) {
        return BasinRecipe.matchCraftingRecipe(input, recipe, world, SHAPELESS_CACHE, SizedIngredient::of);
    }

    public static boolean matchCraftingRecipe(BasinInput input, class_1869 recipe, class_1937 world) {
        return BasinRecipe.matchCraftingRecipe(input, recipe, world, SHAPED_CACHE, SizedIngredient::of);
    }

    private static <T extends class_3955> boolean matchCraftingRecipe(BasinInput input, T recipe, class_1937 world, Map<T, List<SizedIngredient>> ingredientCache, Function<T, List<SizedIngredient>> recipeToIngredients) {
        ServerFilteringBehaviour filter = input.filter();
        if (filter == null) {
            return false;
        }
        class_1799 result = recipe.method_8116(null, (class_7225.class_7874)world.method_30349());
        if (!filter.test(result)) {
            return false;
        }
        List<SizedIngredient> ingredients = ingredientCache.computeIfAbsent(recipe, recipeToIngredients);
        if (ingredients.isEmpty()) {
            return false;
        }
        List<class_1799> outputs = BasinRecipe.tryCraft(input, ingredients);
        if (outputs == null) {
            return false;
        }
        outputs.add(result);
        return input.acceptOutputs(outputs, List.of(), true);
    }

    @Nullable
    public static List<class_1799> tryCraft(BasinInput input, class_1856 ingredient) {
        class_1263 inventory = input.items();
        int size = inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !ingredient.method_8093(stack)) continue;
            ArrayList<class_1799> outputs = new ArrayList<class_1799>();
            class_1799 remainder = stack.method_7909().method_7858();
            if (remainder != class_1799.field_8037) {
                outputs.add(remainder);
            }
            return outputs;
        }
        return null;
    }

    @Nullable
    public static List<class_1799> tryCraft(BasinInput input, SizedIngredient ingredient) {
        int remainder = ingredient.getCount();
        if (remainder == 1) {
            return BasinRecipe.tryCraft(input, ingredient.getIngredient());
        }
        class_1263 inventory = input.items();
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        int size = inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !ingredient.test(stack)) continue;
            int extract = Math.min(stack.method_7947(), remainder);
            BasinRecipe.addRecipeRemainder(stack, extract, outputs);
            if (extract == remainder) {
                return outputs;
            }
            remainder -= extract;
        }
        return null;
    }

    @Nullable
    public static List<class_1799> tryCraft(BasinInput input, List<SizedIngredient> ingredients) {
        int ingredientIndex;
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return new ArrayList<class_1799>();
        }
        if (ingredientSize == 1) {
            return BasinRecipe.tryCraft(input, ingredients.getFirst());
        }
        ArrayList<class_1799> usings = new ArrayList<class_1799>();
        LinkedList<class_1799> inputs = new LinkedList<class_1799>();
        class_1263 inventory = input.items();
        int itemIndex = 0;
        int inventorySize = inventory.method_5439();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.getCount();
            while (itemIndex < inventorySize) {
                class_1799 stack = inventory.method_5438(itemIndex);
                if (!stack.method_7960()) {
                    if (ingredient.test(stack)) {
                        int count = stack.method_7947();
                        if (count > remainder) {
                            usings.add(stack.method_46651(remainder));
                            ++itemIndex;
                            continue block0;
                        }
                        usings.add(stack);
                        if (count == remainder) {
                            ++itemIndex;
                            continue block0;
                        }
                        remainder -= count;
                    } else {
                        inputs.add(stack);
                    }
                }
                ++itemIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                class_1799 stack = (class_1799)iterator.next();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.method_7947();
                if (count > remainder) {
                    usings.add(stack.method_46651(remainder));
                    ++ingredientIndex;
                    break block0;
                }
                usings.add(stack);
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return null;
        }
        while (ingredientIndex < ingredientSize) {
            block18: {
                SizedIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.getCount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    class_1799 stack = (class_1799)iterator.next();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                    } else {
                        usings.add(stack);
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block18;
                }
                return null;
            }
            ++ingredientIndex;
        }
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (class_1799 stack : usings) {
            BasinRecipe.addRecipeRemainder(stack, stack.method_7947(), outputs);
        }
        return outputs;
    }

    public static boolean matchFluidIngredient(BasinInput input, @Nullable FluidIngredient ingredient) {
        if (ingredient == null) {
            return true;
        }
        int remainder = ingredient.amount();
        for (FluidStack stack : input.fluids()) {
            if (!ingredient.test(stack)) continue;
            int amount = stack.getAmount();
            if (amount >= remainder) {
                return true;
            }
            remainder -= amount;
        }
        return false;
    }

    public static boolean matchFluidIngredient(BasinInput input, List<FluidIngredient> ingredients) {
        int ingredientIndex;
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return true;
        }
        if (ingredientSize == 1) {
            return BasinRecipe.matchFluidIngredient(input, ingredients.getFirst());
        }
        LinkedList<FluidStack> inputs = new LinkedList<FluidStack>();
        FluidInventory inventory = input.fluids();
        int fluidIndex = 0;
        int inventorySize = inventory.size();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.amount();
            while (fluidIndex < inventorySize) {
                FluidStack stack = inventory.getStack(fluidIndex);
                if (!stack.isEmpty()) {
                    if (ingredient.test(stack)) {
                        int amount = stack.getAmount();
                        if (amount >= remainder) {
                            ++fluidIndex;
                            continue block0;
                        }
                        remainder -= amount;
                    } else {
                        inputs.add(stack);
                    }
                }
                ++fluidIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                FluidStack stack = (FluidStack)iterator.next();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.getAmount();
                if (count >= remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return false;
        }
        while (ingredientIndex < ingredientSize) {
            block13: {
                FluidIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.amount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    FluidStack stack = (FluidStack)iterator.next();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count < remainder) {
                        remainder -= count;
                        continue;
                    }
                    break block13;
                }
                return false;
            }
            ++ingredientIndex;
        }
        return true;
    }

    public static boolean applyCraftingRecipe(BasinInput input, class_1869 recipe, class_1937 world) {
        return BasinRecipe.applyCraftingRecipe(input, recipe, world, SHAPED_CACHE, SizedIngredient::of);
    }

    public static boolean applyCraftingRecipe(BasinInput input, class_1867 recipe, class_1937 world) {
        return BasinRecipe.applyCraftingRecipe(input, recipe, world, SHAPELESS_CACHE, SizedIngredient::of);
    }

    private static <T extends class_3955> boolean applyCraftingRecipe(BasinInput input, T recipe, class_1937 world, Map<T, List<SizedIngredient>> ingredientCache, Function<T, List<SizedIngredient>> recipeToIngredients) {
        ArrayDeque<Runnable> changes;
        List<SizedIngredient> ingredients = ingredientCache.computeIfAbsent(recipe, recipeToIngredients);
        List<class_1799> outputs = BasinRecipe.prepareCraft(input, ingredients, changes = new ArrayDeque<Runnable>());
        if (outputs == null) {
            return false;
        }
        outputs.add(recipe.method_8116(null, (class_7225.class_7874)world.method_30349()));
        if (!input.acceptOutputs(outputs, List.of(), true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, List.of(), false);
    }

    public static void addRecipeRemainder(class_1799 stack, int count, List<class_1799> outputs) {
        class_1792 item = stack.method_7909();
        for (int i = 0; i < count; ++i) {
            class_1799 remainder = item.method_7858();
            if (remainder == class_1799.field_8037) continue;
            outputs.add(remainder);
        }
    }

    @Nullable
    public static List<class_1799> prepareCraft(BasinInput input, class_1856 ingredient, Deque<Runnable> changes) {
        class_1263 inventory = input.items();
        int size = inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !ingredient.method_8093(stack)) continue;
            int count = stack.method_7947();
            if (count > 1) {
                int newCount = count - 1;
                changes.add(() -> {
                    stack.method_7939(newCount);
                    inventory.method_5431();
                });
            } else {
                int slot = i;
                changes.add(() -> {
                    inventory.method_5447(slot, class_1799.field_8037);
                    inventory.method_5431();
                });
            }
            ArrayList<class_1799> outputs = new ArrayList<class_1799>();
            class_1799 remainder = stack.method_7909().method_7858();
            if (remainder != class_1799.field_8037) {
                outputs.add(remainder);
            }
            return outputs;
        }
        return null;
    }

    @Nullable
    public static List<class_1799> prepareCraft(BasinInput input, SizedIngredient ingredient, Deque<Runnable> changes) {
        int remainder = ingredient.getCount();
        if (remainder == 1) {
            return BasinRecipe.prepareCraft(input, ingredient.getIngredient(), changes);
        }
        class_1263 inventory = input.items();
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        int size = inventory.method_5439();
        for (int i = 0; i < size; ++i) {
            int using;
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !ingredient.test(stack)) continue;
            int count = stack.method_7947();
            if (count > remainder) {
                int newCount = count - remainder;
                changes.add(() -> stack.method_7939(newCount));
                using = remainder;
            } else {
                int slot = i;
                changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                using = count;
            }
            BasinRecipe.addRecipeRemainder(stack, using, outputs);
            if (using == remainder) {
                changes.add(() -> ((class_1263)inventory).method_5431());
                return outputs;
            }
            remainder -= using;
        }
        return null;
    }

    @Nullable
    public static List<class_1799> prepareCraft(BasinInput input, List<SizedIngredient> ingredients, Deque<Runnable> changes) {
        int ingredientIndex;
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return new ArrayList<class_1799>();
        }
        if (ingredientSize == 1) {
            return BasinRecipe.prepareCraft(input, ingredients.getFirst(), changes);
        }
        ArrayList<class_1799> usings = new ArrayList<class_1799>();
        LinkedList<IntObjectPair> inputs = new LinkedList<IntObjectPair>();
        class_1263 inventory = input.items();
        int itemIndex = 0;
        int inventorySize = inventory.method_5439();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.getCount();
            while (itemIndex < inventorySize) {
                class_1799 stack = inventory.method_5438(itemIndex);
                if (!stack.method_7960()) {
                    if (ingredient.test(stack)) {
                        int count = stack.method_7947();
                        if (count > remainder) {
                            usings.add(stack.method_46651(remainder));
                            int newCount = count - remainder;
                            changes.add(() -> stack.method_7939(newCount));
                            ++itemIndex;
                            continue block0;
                        }
                        usings.add(stack);
                        int slot = itemIndex++;
                        changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                        if (count == remainder) continue block0;
                        remainder -= count;
                    } else {
                        inputs.add(IntObjectPair.of((int)itemIndex, (Object)stack));
                    }
                }
                ++itemIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                IntObjectPair pair = (IntObjectPair)iterator.next();
                class_1799 stack = (class_1799)pair.right();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.method_7947();
                if (count > remainder) {
                    usings.add(stack.method_46651(remainder));
                    int newCount = count - remainder;
                    changes.add(() -> stack.method_7939(newCount));
                    ++ingredientIndex;
                    break block0;
                }
                usings.add(stack);
                int slot = pair.leftInt();
                changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return null;
        }
        while (ingredientIndex < ingredientSize) {
            block17: {
                SizedIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.getCount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    IntObjectPair pair = (IntObjectPair)iterator.next();
                    class_1799 stack = (class_1799)pair.right();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                        int newCount = count - remainder;
                        changes.add(() -> stack.method_7939(newCount));
                    } else {
                        usings.add(stack);
                        int slot = pair.leftInt();
                        changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block17;
                }
                return null;
            }
            ++ingredientIndex;
        }
        changes.add(() -> ((class_1263)inventory).method_5431());
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (class_1799 stack : usings) {
            BasinRecipe.addRecipeRemainder(stack, stack.method_7947(), outputs);
        }
        return outputs;
    }

    public static boolean prepareFluidCraft(BasinInput input, @Nullable FluidIngredient ingredient, Deque<Runnable> changes) {
        if (ingredient == null) {
            return true;
        }
        FluidInventory inventory = input.fluids();
        int remainder = ingredient.amount();
        int fluidInventorySize = inventory.size();
        for (int fluidIndex = 0; fluidIndex < fluidInventorySize; ++fluidIndex) {
            FluidStack stack = inventory.getStack(fluidIndex);
            if (!ingredient.test(stack)) continue;
            int amount = stack.getAmount();
            if (amount > remainder) {
                int newAmount = amount - remainder;
                changes.add(() -> {
                    stack.setAmount(newAmount);
                    inventory.markDirty();
                });
                return true;
            }
            int slot = fluidIndex;
            if (remainder == amount) {
                changes.add(() -> {
                    inventory.setStack(slot, FluidStack.EMPTY);
                    inventory.markDirty();
                });
                return true;
            }
            changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
            remainder -= amount;
        }
        return false;
    }

    public static boolean prepareFluidCraft(BasinInput input, List<FluidIngredient> ingredients, Deque<Runnable> changes) {
        int ingredientIndex;
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return true;
        }
        if (ingredientSize == 1) {
            return BasinRecipe.prepareFluidCraft(input, ingredients.getFirst(), changes);
        }
        LinkedList<IntObjectPair> inputs = new LinkedList<IntObjectPair>();
        FluidInventory inventory = input.fluids();
        int fluidIndex = 0;
        int inventorySize = inventory.size();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.amount();
            while (fluidIndex < inventorySize) {
                FluidStack stack = inventory.getStack(fluidIndex);
                if (!stack.isEmpty()) {
                    if (ingredient.test(stack)) {
                        int count = stack.getAmount();
                        if (count > remainder) {
                            int newAmount = count - remainder;
                            changes.add(() -> stack.setAmount(newAmount));
                            ++fluidIndex;
                            continue block0;
                        }
                        int slot = fluidIndex++;
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count == remainder) continue block0;
                        remainder -= count;
                    } else {
                        inputs.add(IntObjectPair.of((int)fluidIndex, (Object)stack));
                    }
                }
                ++fluidIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                IntObjectPair pair = (IntObjectPair)iterator.next();
                FluidStack stack = (FluidStack)pair.right();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.getAmount();
                if (count > remainder) {
                    int newAmount = count - remainder;
                    changes.add(() -> stack.setAmount(newAmount));
                    ++ingredientIndex;
                    break block0;
                }
                int slot = pair.leftInt();
                changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return false;
        }
        while (ingredientIndex < ingredientSize) {
            block16: {
                FluidIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.amount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    IntObjectPair pair = (IntObjectPair)iterator.next();
                    FluidStack stack = (FluidStack)pair.right();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count > remainder) {
                        int newAmount = count - remainder;
                        changes.add(() -> stack.setAmount(newAmount));
                    } else {
                        int slot = pair.leftInt();
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block16;
                }
                return false;
            }
            ++ingredientIndex;
        }
        changes.add(inventory::markDirty);
        return true;
    }

    public int getIngredientSize();

    public List<SizedIngredient> ingredients();

    public List<FluidIngredient> fluidIngredients();

    default public HeatCondition heat() {
        return HeatCondition.NONE;
    }

    public boolean apply(BasinInput var1);

    default public class_1799 craft(BasinInput input, class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }
}

