/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.depot;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import com.zurrtum.create.content.logistics.depot.EntityLauncher;
import com.zurrtum.create.content.logistics.funnel.AbstractFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorAwardPacket;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorElytraPacket;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_10225;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2426;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class EjectorBlockEntity
extends KineticBlockEntity {
    ServerScrollValueBehaviour maxStackSize;
    public DepotBehaviour depotBehaviour;
    public EntityLauncher launcher = new EntityLauncher(1, 0);
    LerpedFloat lidProgress = LerpedFloat.linear().startWithValue(1.0);
    boolean powered = false;
    boolean launch;
    State state = State.RETRACTING;
    @Nullable
    public Pair<class_243, class_2338> earlyTarget;
    public float earlyTargetTime;
    int scanCooldown;
    class_1799 trackedItem;

    public EjectorBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.WEIGHTED_EJECTOR, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.depotBehaviour = new DepotBehaviour(this);
        behaviours.add(this.depotBehaviour);
        this.maxStackSize = new ServerScrollValueBehaviour(this).between(0, 64);
        behaviours.add(this.maxStackSize);
        this.depotBehaviour.maxStackSize = () -> this.maxStackSize.getValue();
        this.depotBehaviour.canAcceptItems = () -> this.state == State.CHARGED;
        this.depotBehaviour.canFunnelsPullFrom = side -> side != this.getFacing();
        this.depotBehaviour.enableMerging();
        this.depotBehaviour.addSubBehaviours(behaviours);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateSignal();
    }

    public void activate() {
        this.launch = true;
        this.nudgeEntities();
    }

    protected boolean cannotLaunch() {
        return this.state != State.CHARGED && (!this.field_11863.method_8608() || this.state != State.LAUNCHING);
    }

    public void activateDeferred() {
        boolean doLogic;
        if (this.cannotLaunch()) {
            return;
        }
        class_2350 facing = this.getFacing();
        List entities = this.field_11863.method_18467(class_1297.class, new class_238(this.field_11867).method_1009(-0.0625, 0.0, -0.0625));
        boolean bl = doLogic = !this.field_11863.method_8608() || this.isVirtual();
        if (doLogic) {
            this.launchItems();
        }
        for (class_1297 entity : entities) {
            boolean isPlayerEntity = entity instanceof class_1657;
            if (!entity.method_5805() || entity instanceof class_1542 || entity instanceof PackageEntity || entity.method_5657() == class_3619.field_15975) continue;
            entity.method_24830(false);
            if (isPlayerEntity != this.field_11863.method_8608()) continue;
            entity.method_5814((double)((float)this.field_11867.method_10263() + 0.5f), (double)(this.field_11867.method_10264() + 1), (double)((float)this.field_11867.method_10260() + 0.5f));
            this.launcher.applyMotion(entity, facing);
            if (!isPlayerEntity) continue;
            class_1657 playerEntity = (class_1657)entity;
            if (this.launcher.getHorizontalDistance() * this.launcher.getHorizontalDistance() + this.launcher.getVerticalDistance() * this.launcher.getVerticalDistance() >= 625) {
                AllClientHandle.INSTANCE.sendPacket(new EjectorAwardPacket(this.field_11867));
            }
            if (playerEntity.method_6118(class_1304.field_6174).method_7909() != class_1802.field_8833) continue;
            playerEntity.method_36457(-35.0f);
            playerEntity.method_36456(facing.method_10144());
            playerEntity.method_18799(playerEntity.method_18798().method_1021(0.75));
            this.deployElytra(playerEntity);
            AllClientHandle.INSTANCE.sendPacket(new EjectorElytraPacket(this.field_11867));
        }
        if (doLogic) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.state = State.LAUNCHING;
            if (!this.field_11863.method_8608()) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_15080, class_3419.field_15245, 0.35f, 1.0f);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14982, class_3419.field_15245, 0.1f, 1.4f);
            }
        }
    }

    public void deployElytra(class_1657 playerEntity) {
        EntityHack.setElytraFlying((class_1297)playerEntity);
    }

    protected void launchItems() {
        class_1799 heldItemStack = this.depotBehaviour.getHeldItemStack();
        class_2350 funnelFacing = this.getFacing().method_10153();
        if (AbstractFunnelBlock.getFunnelFacing(this.field_11863.method_8320(this.field_11867.method_10084())) == funnelFacing) {
            class_1799 remainder;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (this.depotBehaviour.heldItem != null && (remainder = directOutput.tryExportingToBeltFunnel(heldItemStack, funnelFacing, false)) != null) {
                if (remainder.method_7960()) {
                    this.depotBehaviour.removeHeldItem();
                } else if (remainder.method_7947() != heldItemStack.method_7947()) {
                    this.depotBehaviour.heldItem.stack = remainder;
                }
            }
            Iterator<TransportedItemStack> iterator = this.depotBehaviour.incoming.iterator();
            while (iterator.hasNext()) {
                TransportedItemStack transportedItemStack = iterator.next();
                class_1799 stack = transportedItemStack.stack;
                class_1799 remainder2 = directOutput.tryExportingToBeltFunnel(stack, funnelFacing, false);
                if (remainder2 == null) continue;
                if (remainder2.method_7960()) {
                    iterator.remove();
                    continue;
                }
                if (class_1799.method_7984((class_1799)remainder2, (class_1799)stack)) continue;
                transportedItemStack.stack = remainder2;
            }
            boolean change = false;
            DepotBehaviour.DepotOutputHandler outputs = this.depotBehaviour.processingOutputBuffer;
            int size = outputs.method_5439();
            for (int i = 0; i < size; ++i) {
                class_1799 remainder3 = directOutput.tryExportingToBeltFunnel(outputs.method_5438(i), funnelFacing, false);
                if (remainder3 == null) continue;
                outputs.method_5447(i, remainder3);
                change = true;
            }
            if (change) {
                outputs.method_5431();
            }
            return;
        }
        if (!this.field_11863.method_8608()) {
            for (class_2350 d : Iterate.directions) {
                class_2680 blockState = this.field_11863.method_8320(this.field_11867.method_10093(d));
                if (!(blockState.method_26204() instanceof class_2426) || blockState.method_11654((class_2769)class_2426.field_10927) != d.method_10153()) continue;
                blockState.method_26191((class_4538)this.field_11863, (class_10225)this.field_11863, this.field_11867.method_10093(d), d.method_10153(), this.field_11867, blockState, this.field_11863.field_9229);
            }
        }
        if (this.depotBehaviour.heldItem != null) {
            this.addToLaunchedItems(heldItemStack);
            this.depotBehaviour.removeHeldItem();
        }
        for (TransportedItemStack transportedItemStack : this.depotBehaviour.incoming) {
            this.addToLaunchedItems(transportedItemStack.stack);
        }
        this.depotBehaviour.incoming.clear();
        boolean change = false;
        DepotBehaviour.DepotOutputHandler outputs = this.depotBehaviour.processingOutputBuffer;
        int size = outputs.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = outputs.method_5438(i);
            if (stack.method_7960()) continue;
            this.addToLaunchedItems(stack);
            outputs.method_5447(i, class_1799.field_8037);
            change = true;
        }
        if (change) {
            outputs.method_5431();
        }
    }

    protected void addToLaunchedItems(class_1799 stack) {
        if ((!this.field_11863.method_8608() || this.isVirtual()) && this.trackedItem == null && this.scanCooldown == 0) {
            this.scanCooldown = (Integer)AllConfigs.server().kinetics.ejectorScanInterval.get();
            this.trackedItem = stack;
        }
        EjectorItemEntity item = new EjectorItemEntity(this.field_11863, this, stack);
        this.field_11863.method_8649((class_1297)item);
    }

    public class_2350 getFacing() {
        class_2680 blockState = this.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.WEIGHTED_EJECTOR)) {
            return class_2350.field_11036;
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)EjectorBlock.HORIZONTAL_FACING);
        return facing;
    }

    @Override
    public void tick() {
        super.tick();
        boolean doLogic = !this.field_11863.method_8608() || this.isVirtual();
        State prevState = this.state;
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.launch) {
            this.launch = false;
            this.activateDeferred();
        }
        if (this.state == State.LAUNCHING) {
            this.lidProgress.chase(1.0, 0.8f, LerpedFloat.Chaser.EXP);
            this.lidProgress.tickChaser();
            if (this.lidProgress.getValue() > 0.9375f && doLogic) {
                this.state = State.RETRACTING;
                this.lidProgress.setValue(1.0);
            }
        }
        if (this.state == State.CHARGED) {
            this.lidProgress.setValue(0.0);
            this.lidProgress.updateChaseSpeed(0.0);
            if (doLogic) {
                this.ejectIfTriggered();
            }
        }
        if (this.state == State.RETRACTING) {
            if (this.lidProgress.getChaseTarget() == 1.0f && !this.lidProgress.settled()) {
                this.lidProgress.tickChaser();
            } else {
                this.lidProgress.updateChaseTarget(0.0f);
                this.lidProgress.updateChaseSpeed(0.0);
                if (this.lidProgress.getValue() == 0.0f && doLogic) {
                    this.state = State.CHARGED;
                    this.lidProgress.setValue(0.0);
                    this.sendData();
                }
                float value = class_3532.method_15363((float)(this.lidProgress.getValue() - this.getWindUpSpeed()), (float)0.0f, (float)1.0f);
                this.lidProgress.setValue(value);
                int soundRate = (int)(1.0f / (this.getWindUpSpeed() * 5.0f)) + 1;
                float volume = 0.125f;
                float pitch = 1.5f - this.lidProgress.getValue();
                if ((int)this.field_11863.method_8510() % soundRate == 0 && doLogic) {
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_15105, class_3419.field_15245, volume, pitch);
                }
            }
        }
        if (this.state != prevState) {
            this.notifyUpdate();
        }
    }

    private boolean scanTrajectoryForObstacles(int time) {
        class_2680 blockState;
        boolean miss;
        class_243 target;
        if (time <= 2) {
            return false;
        }
        class_243 source = this.getLaunchedItemLocation(time);
        class_3965 rayTraceBlocks = this.field_11863.method_17742(new class_3959(source, target = this.getLaunchedItemLocation(time + 1), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
        boolean bl = miss = rayTraceBlocks.method_17783() == class_239.class_240.field_1333;
        if (!miss && rayTraceBlocks.method_17783() == class_239.class_240.field_1332 && FunnelBlock.isFunnel(blockState = this.field_11863.method_8320(rayTraceBlocks.method_17777())) && blockState.method_28498((class_2769)FunnelBlock.EXTRACTING) && ((Boolean)blockState.method_11654((class_2769)FunnelBlock.EXTRACTING)).booleanValue()) {
            miss = true;
        }
        if (miss) {
            if (this.earlyTarget != null && this.earlyTargetTime < (float)(time + 1)) {
                this.earlyTarget = null;
                this.earlyTargetTime = 0.0f;
            }
            return false;
        }
        class_243 vec = rayTraceBlocks.method_17784();
        this.earlyTarget = Pair.of(vec.method_1019(class_243.method_24954((class_2382)rayTraceBlocks.method_17780().method_62675()).method_1021(0.25)), rayTraceBlocks.method_17777());
        this.earlyTargetTime = (float)((double)time + source.method_1022(vec) / source.method_1022(target));
        this.sendData();
        return true;
    }

    protected void nudgeEntities() {
        for (class_1297 entity : this.field_11863.method_18467(class_1297.class, new class_238(this.field_11867).method_1009(-0.0625, 0.0, -0.0625))) {
            if (!entity.method_5805() || entity.method_5657() == class_3619.field_15975 || entity instanceof class_1657) continue;
            entity.method_5814(entity.method_23317(), entity.method_23318() + 0.125, entity.method_23321());
        }
    }

    protected void ejectIfTriggered() {
        DirectBeltInputBehaviour targetOpenInv;
        if (this.powered) {
            return;
        }
        int presentStackSize = this.depotBehaviour.getPresentStackSize();
        if (presentStackSize == 0) {
            return;
        }
        if (presentStackSize < this.maxStackSize.getValue()) {
            return;
        }
        if (this.depotBehaviour.heldItem != null && this.depotBehaviour.heldItem.beltPosition < 0.49f) {
            return;
        }
        class_2350 funnelFacing = this.getFacing().method_10153();
        class_1799 held = this.depotBehaviour.getHeldItemStack();
        if (AbstractFunnelBlock.getFunnelFacing(this.field_11863.method_8320(this.field_11867.method_10084())) == funnelFacing) {
            class_1799 tryFunnel;
            DirectBeltInputBehaviour directOutput = this.getBehaviour(DirectBeltInputBehaviour.TYPE);
            if (!(this.depotBehaviour.heldItem == null || (tryFunnel = directOutput.tryExportingToBeltFunnel(held, funnelFacing, true)) != null && tryFunnel.method_7960())) {
                return;
            }
        }
        if ((targetOpenInv = this.getTargetOpenInv()) != null && this.depotBehaviour.heldItem != null && targetOpenInv.handleInsertion(held, class_2350.field_11036, true).method_7947() == held.method_7947()) {
            return;
        }
        this.activate();
        this.notifyUpdate();
    }

    public DirectBeltInputBehaviour getTargetOpenInv() {
        class_2338 targetPos = this.earlyTarget != null ? this.earlyTarget.getSecond() : this.field_11867.method_10086(this.launcher.getVerticalDistance()).method_10079(this.getFacing(), Math.max(1, this.launcher.getHorizontalDistance()));
        return BlockEntityBehaviour.get((class_1922)this.field_11863, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public class_243 getLaunchedItemLocation(float time) {
        return this.launcher.getGlobalPos((double)time, this.getFacing().method_10153(), this.field_11867);
    }

    public class_243 getLaunchedItemMotion(float time) {
        class_243 pos = this.launcher.getGlobalVelocity(time, this.getFacing().method_10153()).method_1021(0.5);
        return new class_243((double)((int)(class_3532.method_15350((double)pos.field_1352, (double)-3.9, (double)3.9) * 8000.0)) / 8000.0, (double)((int)(class_3532.method_15350((double)pos.field_1351, (double)-3.9, (double)3.9) * 8000.0)) / 8000.0, (double)((int)(class_3532.method_15350((double)pos.field_1350, (double)-3.9, (double)3.9) * 8000.0)) / 8000.0);
    }

    public float getWindUpSpeed() {
        int hd = this.launcher.getHorizontalDistance();
        int vd = this.launcher.getVerticalDistance();
        float speedFactor = Math.abs(this.getSpeed()) / 256.0f;
        float distanceFactor = hd == 0 && vd == 0 ? 1.0f : 1.0f * class_3532.method_15355((float)(hd * hd + vd * vd));
        return speedFactor / distanceFactor;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("HorizontalDistance", this.launcher.getHorizontalDistance());
        view.method_71465("VerticalDistance", this.launcher.getVerticalDistance());
        view.method_71472("Powered", this.powered);
        view.method_71468("State", State.CODEC, (Object)this.state);
        this.lidProgress.write(view.method_71461("Lid"));
        if (this.earlyTarget != null) {
            view.method_71468("EarlyTarget", class_243.field_38277, (Object)this.earlyTarget.getFirst());
            view.method_71468("EarlyTargetPos", class_2338.field_25064, (Object)this.earlyTarget.getSecond());
            view.method_71464("EarlyTargetTime", this.earlyTargetTime);
        }
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        view.method_71465("HorizontalDistance", this.launcher.getHorizontalDistance());
        view.method_71465("VerticalDistance", this.launcher.getVerticalDistance());
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        int horizontalDistance = view.method_71424("HorizontalDistance", 0);
        int verticalDistance = view.method_71424("VerticalDistance", 0);
        if (this.launcher.getHorizontalDistance() != horizontalDistance || this.launcher.getVerticalDistance() != verticalDistance) {
            this.launcher.set(horizontalDistance, verticalDistance);
            this.launcher.clamp((Integer)AllConfigs.server().kinetics.maxEjectorDistance.get());
        }
        this.powered = view.method_71433("Powered", false);
        this.state = view.method_71426("State", State.CODEC).orElse(State.RETRACTING);
        this.lidProgress.read(view.method_71434("Lid"), false);
        this.earlyTarget = null;
        this.earlyTargetTime = 0.0f;
        view.method_71426("EarlyTarget", class_243.field_38277).ifPresent(vec3d -> {
            this.earlyTarget = Pair.of(vec3d, (class_2338)view.method_71426("EarlyTargetPos", class_2338.field_25064).orElseThrow());
            this.earlyTargetTime = view.method_71423("EarlyTargetTime", 0.0f);
        });
        float forceAngle = view.method_71423("ForceAngle", -1.0f);
        if (forceAngle != -1.0f) {
            this.lidProgress.startWithValue(forceAngle);
        }
    }

    public void updateSignal() {
        boolean shoudPower = this.field_11863.method_49803(this.field_11867);
        if (shoudPower == this.powered) {
            return;
        }
        this.powered = shoudPower;
        this.sendData();
    }

    public void setTarget(int horizontalDistance, int verticalDistance) {
        this.launcher.set(Math.max(1, horizontalDistance), verticalDistance);
        this.sendData();
    }

    public class_2338 getTargetPosition() {
        class_2680 blockState = this.method_11010();
        if (!blockState.method_27852((class_2248)AllBlocks.WEIGHTED_EJECTOR)) {
            return this.field_11867;
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)EjectorBlock.HORIZONTAL_FACING);
        return this.field_11867.method_10079(facing, this.launcher.getHorizontalDistance()).method_10086(this.launcher.getVerticalDistance());
    }

    public float getLidProgress(float pt) {
        return this.lidProgress.getValue(pt);
    }

    public State getState() {
        return this.state;
    }

    public static enum State implements class_3542
    {
        CHARGED,
        LAUNCHING,
        RETRACTING;

        public static final Codec<State> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(State::values);
        }
    }

    private static abstract class EntityHack
    extends class_1297 {
        public EntityHack(class_1299<?> p_i48580_1_, class_1937 p_i48580_2_) {
            super(p_i48580_1_, p_i48580_2_);
        }

        public static void setElytraFlying(class_1297 e) {
            class_2945 data = e.method_5841();
            data.method_12778(field_5990, (Object)((byte)((Byte)data.method_12789(field_5990) | 0x80)));
        }
    }
}

