/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.deployer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerPlayer;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationInput;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.recipe.RecipeApplier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public class BeltDeployerCallbacks {
    public static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerBlockEntity blockEntity) {
        class_1799 held;
        if (blockEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.mode == DeployerBlockEntity.Mode.PUNCH) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        class_2680 blockState = blockEntity.method_11010();
        if (!blockState.method_28498(DirectionalKineticBlock.FACING) || blockState.method_11654(DirectionalKineticBlock.FACING) != class_2350.field_11033) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.state != DeployerBlockEntity.State.WAITING) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.redstoneLocked) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerPlayer player = blockEntity.getPlayer();
        class_1799 class_17992 = held = player == null ? class_1799.field_8037 : player.cast().method_6047();
        if (held.method_7960()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.getRecipe(s.stack) == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        blockEntity.start();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerBlockEntity blockEntity) {
        class_1799 held;
        if (blockEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        class_2680 blockState = blockEntity.method_11010();
        if (!blockState.method_28498(DirectionalKineticBlock.FACING) || blockState.method_11654(DirectionalKineticBlock.FACING) != class_2350.field_11033) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerPlayer player = blockEntity.getPlayer();
        class_1799 class_17992 = held = player == null ? class_1799.field_8037 : player.cast().method_6047();
        if (held.method_7960()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        class_1860<? extends class_9695> recipe = blockEntity.getRecipe(s.stack);
        if (recipe == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.state == DeployerBlockEntity.State.RETRACTING && blockEntity.timer == 1000) {
            BeltDeployerCallbacks.activate(s, i, blockEntity, recipe);
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.state == DeployerBlockEntity.State.WAITING) {
            if (blockEntity.redstoneLocked) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            blockEntity.start();
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static void activate(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, DeployerBlockEntity blockEntity, class_1860<?> recipe) {
        class_1799 resultItem;
        boolean keepHeld;
        List<TransportedItemStack> collect;
        class_1937 world = blockEntity.method_10997();
        class_3222 player = blockEntity.player.cast();
        class_1799 heldItem = player.method_6047();
        if (recipe instanceof SandPaperPolishingRecipe) {
            SandPaperPolishingRecipe polishingRecipe = (SandPaperPolishingRecipe)recipe;
            class_1799 result = polishingRecipe.craft(new class_9696(transported.stack), (class_7225.class_7874)world.method_30349());
            TransportedItemStack copy = transported.copy();
            copy.stack = result;
            copy.angle = BeltHelper.isItemUpright(result) ? 180 : world.method_8409().method_43048(360);
            copy.locked = false;
            collect = List.of(copy);
            keepHeld = false;
        } else if (recipe instanceof ItemApplicationRecipe) {
            ItemApplicationRecipe itemApplicationRecipe = (ItemApplicationRecipe)recipe;
            class_5819 random = world.method_8409();
            List<class_1799> results = RecipeApplier.applyRecipeOn(random, 1, new ItemApplicationInput(transported.stack, heldItem), itemApplicationRecipe);
            collect = new ArrayList(results.size());
            for (class_1799 result : results) {
                TransportedItemStack copy = transported.copy();
                copy.stack = result;
                copy.angle = BeltHelper.isItemUpright(result) ? 180 : random.method_43048(360);
                copy.locked = false;
                collect.add(copy);
            }
            keepHeld = itemApplicationRecipe.keepHeldItem();
        } else {
            collect = List.of();
            keepHeld = false;
        }
        blockEntity.award(AllAdvancements.DEPLOYER);
        transported.clearFanProcessingData();
        TransportedItemStack left = transported.copy();
        blockEntity.player.setSpawnedItemEffects(transported.stack.method_7972());
        left.stack.method_7934(1);
        if (collect.isEmpty()) {
            resultItem = left.stack.method_7972();
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(left));
        } else {
            resultItem = ((TransportedItemStack)collect.getFirst()).stack;
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(collect, left));
        }
        if (!keepHeld) {
            if (heldItem.method_7936() > 0) {
                heldItem.method_7970(1, (class_1309)player, class_1304.field_6173);
            } else {
                class_1799 leftover = heldItem.method_7909().method_7858();
                heldItem.method_7934(1);
                if (!leftover.method_7960()) {
                    if (heldItem.method_7960()) {
                        player.method_6122(class_1268.field_5808, leftover);
                    } else if (!player.method_31548().method_7394(leftover)) {
                        player.method_7328(leftover, false);
                    }
                }
            }
        }
        if (!resultItem.method_7960()) {
            BeltDeployerCallbacks.awardAdvancements(blockEntity, resultItem);
        }
        class_2338 pos = blockEntity.method_11016();
        if (heldItem.method_7960()) {
            world.method_8396(null, pos, (class_3414)class_3417.field_15075.comp_349(), class_3419.field_15245, 0.25f, 1.0f);
        }
        world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.25f, 0.75f);
        if (recipe instanceof SandPaperPolishingRecipe) {
            AllSoundEvents.SANDING_SHORT.playOnServer(world, (class_2382)pos, 0.35f, 1.0f);
        }
        blockEntity.notifyUpdate();
    }

    private static void awardAdvancements(DeployerBlockEntity blockEntity, class_1799 created) {
        CreateTrigger advancement;
        if (created.method_31574((class_1792)AllItems.ANDESITE_CASING)) {
            advancement = AllAdvancements.ANDESITE_CASING;
        } else if (created.method_31574((class_1792)AllItems.BRASS_CASING)) {
            advancement = AllAdvancements.BRASS_CASING;
        } else if (created.method_31574((class_1792)AllItems.COPPER_CASING)) {
            advancement = AllAdvancements.COPPER_CASING;
        } else if (created.method_31574((class_1792)AllItems.RAILWAY_CASING)) {
            advancement = AllAdvancements.TRAIN_CASING;
        } else {
            return;
        }
        blockEntity.award(advancement);
    }
}

