/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.equipment.toolbox;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import com.zurrtum.create.content.equipment.toolbox.ToolboxHandler;
import com.zurrtum.create.content.equipment.toolbox.ToolboxInventory;
import com.zurrtum.create.content.equipment.toolbox.ToolboxMenu;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.utility.ResetableLazy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4844;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9323;
import net.minecraft.class_9473;

public class ToolboxBlockEntity
extends SmartBlockEntity
implements MenuProvider,
class_1275 {
    public LerpedFloat lid = LerpedFloat.linear().startWithValue(0.0);
    public LerpedFloat drawers = LerpedFloat.linear().startWithValue(0.0);
    UUID uniqueId;
    public ToolboxInventory inventory;
    ResetableLazy<class_1767> colorProvider;
    Map<Integer, WeakHashMap<class_1657, Integer>> connectedPlayers = new HashMap<Integer, WeakHashMap<class_1657, Integer>>();
    private class_2561 customName;
    private AnimatedContainerBehaviour<ToolboxMenu> openTracker;

    public ToolboxBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.TOOLBOX, pos, state);
        this.inventory = new ToolboxInventory(this);
        this.colorProvider = ResetableLazy.of(() -> {
            class_2680 blockState = this.method_11010();
            if (blockState != null && blockState.method_26204() instanceof ToolboxBlock) {
                return ((ToolboxBlock)blockState.method_26204()).getColor();
            }
            return class_1767.field_7957;
        });
        this.setLazyTickRate(10);
    }

    public class_1767 getColor() {
        return this.colorProvider.get();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.openTracker = new AnimatedContainerBehaviour<ToolboxMenu>(this, ToolboxMenu.class);
        behaviours.add(this.openTracker);
    }

    @Override
    public void initialize() {
        super.initialize();
        ToolboxHandler.onLoad(this);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        ToolboxHandler.onUnload(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            this.tickAudio();
        } else {
            this.tickPlayers();
        }
        this.lid.chase(this.openTracker.openCount > 0 ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.LINEAR);
        this.drawers.chase(this.openTracker.openCount > 0 ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.EXP);
        this.lid.tickChaser();
        this.drawers.tickChaser();
    }

    private void tickPlayers() {
        boolean update = false;
        Iterator<Map.Entry<Integer, WeakHashMap<class_1657, Integer>>> toolboxSlots = this.connectedPlayers.entrySet().iterator();
        while (toolboxSlots.hasNext()) {
            Map.Entry<Integer, WeakHashMap<class_1657, Integer>> toolboxSlotEntry = toolboxSlots.next();
            WeakHashMap<class_1657, Integer> set = toolboxSlotEntry.getValue();
            int slot = toolboxSlotEntry.getKey();
            class_1799 referenceItem = (class_1799)this.inventory.filters.get(slot);
            boolean clear = referenceItem.method_7960();
            Iterator<Map.Entry<class_1657, Integer>> playerEntries = set.entrySet().iterator();
            while (playerEntries.hasNext()) {
                int deposited;
                int targetAmount;
                Map.Entry<class_1657, Integer> playerEntry = playerEntries.next();
                class_1657 player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                if (!clear && !ToolboxHandler.withinRange(player, this)) continue;
                class_1661 playerInv = player.method_31548();
                class_1799 playerStack = playerInv.method_5438(hotbarSlot);
                if (clear || !playerStack.method_7960() && !ToolboxInventory.canItemsShareCompartment(playerStack, referenceItem)) {
                    class_2487 compound = AllSynchedDatas.TOOLBOX.get((class_1297)player);
                    compound.method_10551(String.valueOf(hotbarSlot));
                    playerEntries.remove();
                    if (!(player instanceof class_3222)) continue;
                    ToolboxHandler.syncData(player, compound);
                    continue;
                }
                int count = playerStack.method_7947();
                if (count < (targetAmount = (referenceItem.method_7914() + 1) / 2)) {
                    class_1799 extracted;
                    int amountToReplenish = targetAmount - count;
                    if (this.isOpenInContainer(player) && !(extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, true)).method_7960()) {
                        ToolboxHandler.unequip(player, hotbarSlot, false);
                        ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get((class_1297)player));
                        continue;
                    }
                    extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, false);
                    if (!extracted.method_7960()) {
                        update = true;
                        class_1799 template = playerStack.method_7960() ? extracted : playerStack;
                        playerInv.method_5447(hotbarSlot, template.method_46651(count + extracted.method_7947()));
                    }
                }
                if (count <= targetAmount) continue;
                int amountToDeposit = count - targetAmount;
                class_1799 toDistribute = playerStack.method_46651(amountToDeposit);
                if (this.isOpenInContainer(player) && (deposited = this.inventory.distributeToCompartment(toDistribute, slot, true)) > 0) {
                    ToolboxHandler.unequip(player, hotbarSlot, true);
                    ToolboxHandler.syncData(player, AllSynchedDatas.TOOLBOX.get((class_1297)player));
                    continue;
                }
                int deposited2 = this.inventory.distributeToCompartment(toDistribute, slot, false);
                if (deposited2 <= 0) continue;
                update = true;
                playerInv.method_5447(hotbarSlot, playerStack.method_46651(count - deposited2));
            }
            if (!clear) continue;
            toolboxSlots.remove();
        }
        if (update) {
            this.sendData();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOpenInContainer(class_1657 player) {
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof ToolboxMenu)) return false;
        ToolboxMenu toolboxMenu = (ToolboxMenu)class_17032;
        if (toolboxMenu.contentHolder != this) return false;
        return true;
    }

    public void unequipTracked() {
        if (this.field_11863.method_8608()) {
            return;
        }
        HashSet<class_3222> affected = new HashSet<class_3222>();
        for (Map.Entry<Integer, WeakHashMap<class_1657, Integer>> toolboxSlotEntry : this.connectedPlayers.entrySet()) {
            WeakHashMap<class_1657, Integer> set = toolboxSlotEntry.getValue();
            for (Map.Entry<class_1657, Integer> playerEntry : set.entrySet()) {
                class_1657 player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                ToolboxHandler.unequip(player, hotbarSlot, false);
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                affected.add(serverPlayer);
            }
        }
        for (class_3222 player : affected) {
            ToolboxHandler.syncData((class_1657)player, AllSynchedDatas.TOOLBOX.get((class_1297)player));
        }
        this.connectedPlayers.clear();
    }

    public void unequip(int slot, class_1657 player, int hotbarSlot, boolean keepItems) {
        if (!this.connectedPlayers.containsKey(slot)) {
            return;
        }
        this.connectedPlayers.get(slot).remove(player);
        if (keepItems) {
            return;
        }
        class_1661 playerInv = player.method_31548();
        class_1799 playerStack = playerInv.method_5438(hotbarSlot);
        class_1799 toInsert = ToolboxInventory.cleanItemNBT(playerStack.method_7972());
        int insert = this.inventory.distributeToCompartment(toInsert, slot, false);
        if (insert != 0) {
            int count = playerStack.method_7947();
            if (insert == count) {
                playerInv.method_5447(hotbarSlot, class_1799.field_8037);
            } else {
                playerStack.method_7939(count - insert);
            }
        }
    }

    private void tickAudio() {
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        if (this.lid.settled()) {
            if (this.openTracker.openCount > 0 && this.lid.getChaseTarget() == 0.0f) {
                this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_14567, class_3419.field_15245, 0.25f, this.field_11863.field_9229.method_43057() * 0.1f + 1.2f, true);
                this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_14982, class_3419.field_15245, 0.1f, this.field_11863.field_9229.method_43057() * 0.1f + 1.1f, true);
            }
            if (this.openTracker.openCount == 0 && this.lid.getChaseTarget() == 1.0f) {
                this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_14823, class_3419.field_15245, 0.1f, this.field_11863.field_9229.method_43057() * 0.1f + 1.1f, true);
            }
        } else if (this.openTracker.openCount == 0 && this.lid.getChaseTarget() == 0.0f && this.lid.getValue(0.0f) > 0.0625f && this.lid.getValue(1.0f) < 0.0625f) {
            this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_14819, class_3419.field_15245, 0.25f, this.field_11863.field_9229.method_43057() * 0.1f + 1.2f, true);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        this.inventory.read(view.method_71434("Inventory"));
        super.read(view, clientPacket);
        view.method_71426("UniqueId", class_4844.field_25122).ifPresent(uuid -> {
            this.uniqueId = uuid;
        });
        view.method_71426("CustomName", class_8824.field_46597).ifPresent(name -> {
            this.customName = name;
        });
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        if (this.uniqueId == null) {
            this.uniqueId = UUID.randomUUID();
        }
        this.inventory.write(view.method_71461("Inventory"));
        view.method_71468("UniqueId", class_4844.field_25122, (Object)this.uniqueId);
        if (this.customName != null) {
            view.method_71468("CustomName", class_8824.field_46597, (Object)this.customName);
        }
        super.write(view, clientPacket);
    }

    public ToolboxMenu createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        this.sendToMenu(extraData);
        return new ToolboxMenu(id, inv, this);
    }

    @Override
    public void lazyTick() {
        ToolboxHandler.onLoad(this);
        super.lazyTick();
    }

    public void connectPlayer(int slot, class_1657 player, int hotbarSlot) {
        if (this.field_11863.method_8608()) {
            return;
        }
        WeakHashMap map = this.connectedPlayers.computeIfAbsent(slot, WeakHashMap::new);
        Integer previous = (Integer)map.get(player);
        if (previous != null) {
            if (previous == hotbarSlot) {
                return;
            }
            ToolboxHandler.unequip(player, previous, false);
        }
        map.put(player, hotbarSlot);
    }

    public void readInventory(ToolboxInventory inv) {
        if (inv != null) {
            int i;
            class_2371<class_1799> filters = inv.filters;
            int size = filters.size();
            for (i = 0; i < size; ++i) {
                this.inventory.filters.set(i, (Object)((class_1799)filters.get(i)));
            }
            size = inv.method_5439();
            for (i = 0; i < size; ++i) {
                this.inventory.method_5447(i, inv.method_5438(i));
            }
        }
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public boolean isFullyInitialized() {
        return this.uniqueId != null;
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    @Override
    public class_2561 method_5476() {
        return this.customName != null ? this.customName : this.method_11010().method_26204().method_9518();
    }

    public class_2561 method_5797() {
        return this.customName;
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    public class_2561 method_5477() {
        return this.customName;
    }

    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.colorProvider.reset();
    }

    protected void method_57568(class_9473 componentInput) {
        this.setUniqueId((UUID)componentInput.method_58694(AllDataComponents.TOOLBOX_UUID));
        this.readInventory((ToolboxInventory)componentInput.method_58694(AllDataComponents.TOOLBOX_INVENTORY));
    }

    protected void method_57567(class_9323.class_9324 components) {
        components.method_57840(AllDataComponents.TOOLBOX_UUID, (Object)this.uniqueId);
        components.method_57840(AllDataComponents.TOOLBOX_INVENTORY, (Object)this.inventory);
    }
}

