/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.compat.computercraft;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.implementation.ComputerBehaviour;
import com.zurrtum.create.compat.computercraft.implementation.luaObjects.PackageLuaObject;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.CreativeMotorPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.DisplayLinkPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.FrogportPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.NixieTubePeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.PackagerPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.PostboxPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.RedstoneRequesterPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.RepackagerPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.SequencedGearshiftPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.SignalPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.SpeedControllerPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.SpeedGaugePeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.StationPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.StickerPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.StockTickerPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.StressGaugePeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.TableClothShopPeripheral;
import com.zurrtum.create.compat.computercraft.implementation.peripherals.TrackObserverPeripheral;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2591;

public class AllComputerPeripherals {
    private static <T extends SmartBlockEntity> void registerPeripheral(class_2591<T> type, Function<T, SyncedPeripheral<T>> factory) {
        BlockEntityBehaviour.add(type, ComputerBehaviour::new);
        PeripheralLookup.get().registerForBlockEntity((blockEntity, direction) -> {
            AbstractComputerBehaviour patt0$temp = blockEntity.getBehaviour(AbstractComputerBehaviour.TYPE);
            if (patt0$temp instanceof ComputerBehaviour) {
                ComputerBehaviour behaviour = (ComputerBehaviour)patt0$temp;
                if (behaviour.peripheral != null) {
                    return behaviour.peripheral;
                }
                behaviour.peripheral = (SyncedPeripheral)factory.apply(blockEntity);
                return behaviour.peripheral;
            }
            return null;
        }, type);
    }

    public static void register() {
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.MOTOR, CreativeMotorPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.DISPLAY_LINK, DisplayLinkPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.STRESSOMETER, StressGaugePeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.PACKAGE_FROGPORT, FrogportPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.NIXIE_TUBE, NixieTubePeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.PACKAGER, PackagerPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.PACKAGE_POSTBOX, PostboxPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.REDSTONE_REQUESTER, RedstoneRequesterPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.REPACKAGER, RepackagerPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.SEQUENCED_GEARSHIFT, SequencedGearshiftPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.TRACK_SIGNAL, SignalPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.ROTATION_SPEED_CONTROLLER, SpeedControllerPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.TRACK_STATION, StationPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.STICKER, StickerPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.TABLE_CLOTH, TableClothShopPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.SPEEDOMETER, SpeedGaugePeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.TRACK_OBSERVER, TrackObserverPeripheral::new);
        AllComputerPeripherals.registerPeripheral(AllBlockEntityTypes.STOCK_TICKER, StockTickerPeripheral::new);
        VanillaDetailRegistries.ITEM_STACK.addProvider((out, stack) -> {
            if (PackageItem.isPackage(stack)) {
                PackageLuaObject packageLuaObject = new PackageLuaObject(null, (class_1799)stack);
                out.put("package", packageLuaObject);
            }
        });
    }
}

