/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

@Environment(value=EnvType.CLIENT)
public class FunnelScenes {
    public static void intro(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("funnel_intro", "Using funnels");
        scene.configureBasePlate(0, 1, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(f.floatValue() / 2.0f));
        scene.idle(10);
        Selection verticalFunnel = util.select().fromTo(2, -1, 4, 2, 4, 4).add(util.select().fromTo(1, 1, 4, 1, 4, 4));
        Selection beltFunnels = util.select().fromTo(1, 2, 2, 3, 2, 2);
        Selection beltFunnelEnv = util.select().fromTo(0, 1, 0, 5, 2, 2).substract(beltFunnels);
        scene.world().showSection(beltFunnelEnv, class_2350.field_11033);
        scene.idle(20);
        scene.world().showSection(beltFunnels, class_2350.field_11033);
        class_2338 entryBeltPos = util.grid().at(3, 1, 2);
        class_2338 exitBeltPos = util.grid().at(1, 1, 2);
        class_1799 itemStack = AllItems.BRASS_BLOCK.method_7854();
        for (int i2 = 0; i2 < 8; ++i2) {
            scene.idle(8);
            scene.world().removeItemsFromBelt(exitBeltPos);
            scene.world().flapFunnel(exitBeltPos.method_10084(), false);
            if (i2 == 2) {
                scene.rotateCameraY(70.0f);
            }
            if (i2 >= 6) continue;
            scene.world().createItemOnBelt(entryBeltPos, class_2350.field_11034, itemStack);
        }
        scene.rotateCameraY(-70.0f);
        scene.idle(10);
        Selection outputFunnel = util.select().position(1, 2, 4);
        scene.world().setBlocks(outputFunnel, class_2246.field_10124.method_9564(), false);
        scene.world().setBlocks(util.select().fromTo(2, -1, 4, 2, 0, 4), AllBlocks.ANDESITE_CASING.method_9564(), true);
        ElementLink<WorldSectionElement> independentSection = scene.world().showIndependentSection(verticalFunnel, class_2350.field_11036);
        class_243 topItemSpawn = util.vector().centerOf(2, 6, 4);
        class_243 sideItemSpawn = util.vector().centerOf(1, 3, 4).method_1031((double)0.15f, (double)-0.45f, 0.0);
        ElementLink<EntityElement> lastItemEntity = null;
        for (i = 0; i < 4; ++i) {
            if (lastItemEntity != null) {
                scene.world().modifyEntity(lastItemEntity, class_1297::method_31472);
            }
            if (i < 3) {
                lastItemEntity = scene.world().createItemEntity(topItemSpawn, util.vector().of(0.0, -0.4, 0.0), itemStack);
            }
            scene.idle(8);
        }
        scene.world().moveSection(independentSection, util.vector().of(0.0, 1.0, 0.0), 15);
        scene.idle(10);
        scene.world().setBlocks(outputFunnel, (class_2680)((class_2680)AllBlocks.ANDESITE_FUNNEL.method_9564().method_11657((class_2769)FunnelBlock.FACING, (Comparable)class_2350.field_11039)).method_11657((class_2769)FunnelBlock.EXTRACTING, (Comparable)Boolean.valueOf(true)), false);
        for (i = 0; i < 3; ++i) {
            scene.idle(8);
            scene.world().flapFunnel(util.grid().at(1, 2, 4), false);
            scene.world().createItemEntity(sideItemSpawn, util.vector().of(-0.05, 0.0, 0.0), itemStack);
        }
        scene.idle(8);
        scene.overlay().showText(360).text("Funnels are ideal for transferring items from and to inventories.").independent();
        scene.markAsFinished();
    }

    public static void directionality(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("funnel_direction", "Direction of Transfer");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(f.floatValue() / 2.0f));
        scene.world().setBlocks(util.select().position(3, 1, 1), AllBlocks.ANDESITE_CASING.method_9564(), false);
        class_2338 topFunnel = util.grid().at(3, 3, 2);
        Selection topFunnelSelection = util.select().position(topFunnel);
        Selection firstShow = util.select().fromTo(3, 1, 2, 3, 2, 2);
        scene.idle(5);
        scene.world().showSection(firstShow, class_2350.field_11033);
        scene.idle(15);
        class_1799 itemStack = AllItems.BRASS_BLOCK.method_7854();
        class_243 topCenter = util.vector().centerOf(topFunnel);
        class_243 topSide = util.vector().blockSurface(topFunnel, class_2350.field_11034);
        scene.world().showSection(topFunnelSelection, class_2350.field_11033);
        scene.overlay().showText(80).text("Placed normally, it pulls items from the inventory.").attachKeyFrame().pointAt(topCenter).placeNearTarget();
        scene.idle(45);
        ElementLink<EntityElement> itemLink = scene.world().createItemEntity(topCenter, util.vector().of(0.0, 0.25, 0.0), itemStack);
        scene.idle(40);
        scene.world().modifyEntity(itemLink, class_1297::method_31472);
        scene.world().hideSection(topFunnelSelection, class_2350.field_11036);
        scene.idle(20);
        scene.world().modifyBlock(topFunnel, s -> (class_2680)s.method_11657((class_2769)FunnelBlock.EXTRACTING, (Comparable)Boolean.valueOf(false)), false);
        scene.idle(5);
        scene.world().showSection(topFunnelSelection, class_2350.field_11033);
        scene.overlay().showControls(topCenter, Pointing.DOWN, 35).rightClick().whileSneaking();
        scene.overlay().showText(80).text("Placed while sneaking, it puts items into the inventory.").attachKeyFrame().pointAt(topCenter).placeNearTarget();
        scene.idle(45);
        itemLink = scene.world().createItemEntity(topCenter.method_1031(0.0, 3.0, 0.0), util.vector().of(0.0, -0.2, 0.0), itemStack);
        scene.idle(10);
        scene.world().modifyEntity(itemLink, class_1297::method_31472);
        scene.idle(45);
        scene.overlay().showControls(topSide, Pointing.RIGHT, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(10);
        scene.world().modifyBlock(topFunnel, s -> (class_2680)s.method_28493((class_2769)FunnelBlock.EXTRACTING), true);
        scene.idle(10);
        scene.overlay().showText(80).text("Using a wrench, the funnel can be flipped after placement.").attachKeyFrame().pointAt(topCenter).placeNearTarget();
        itemLink = scene.world().createItemEntity(topCenter, util.vector().of(0.0, 0.25, 0.0), itemStack);
        scene.idle(30);
        scene.overlay().showControls(topSide, Pointing.RIGHT, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(10);
        scene.world().modifyBlock(topFunnel, s -> (class_2680)s.method_28493((class_2769)FunnelBlock.EXTRACTING), true);
        scene.idle(10);
        scene.world().modifyEntity(itemLink, class_1297::method_31472);
        scene.idle(20);
        class_2338 sideFunnel = util.grid().at(3, 2, 1);
        Selection sideFunnelSelection = util.select().fromTo(sideFunnel.method_10074(), sideFunnel);
        class_243 sideCenter = util.vector().centerOf(sideFunnel);
        scene.world().modifyBlock(sideFunnel, s -> (class_2680)s.method_28493((class_2769)FunnelBlock.EXTRACTING), false);
        scene.world().showSection(sideFunnelSelection, class_2350.field_11033);
        scene.overlay().showText(70).text("Same rules will apply for most orientations.").pointAt(sideCenter).placeNearTarget();
        scene.idle(20);
        scene.world().flapFunnel(sideFunnel, true);
        itemLink = scene.world().createItemEntity(sideCenter.method_1023(0.0, 0.45, 0.0), util.vector().of(0.0, 0.0, -0.1), itemStack);
        scene.idle(60);
        scene.world().hideSection(sideFunnelSelection, class_2350.field_11036);
        scene.world().hideSection(topFunnelSelection, class_2350.field_11036);
        scene.world().modifyEntity(itemLink, class_1297::method_31472);
        scene.idle(20);
        Selection beltFunnelSetup = util.select().fromTo(0, 1, 0, 2, 2, 5);
        Selection gearshiftAndLever = util.select().fromTo(1, 1, 4, 1, 2, 4);
        Selection gearshiftedKinetics = util.select().fromTo(1, 1, 2, 2, 1, 4);
        class_243 topOfBeltFunnel = util.vector().topOf(2, 2, 2);
        class_2338 beltPos = util.grid().at(2, 1, 2);
        class_2338 cogPos = util.grid().at(1, 1, 3);
        scene.world().showSection(beltFunnelSetup, class_2350.field_11033);
        scene.overlay().showText(140).text("Funnels on belts will extract/insert depending on its movement direction.").attachKeyFrame().pointAt(topOfBeltFunnel);
        scene.idle(15);
        for (int i = 0; i < 2; ++i) {
            scene.world().createItemOnBelt(beltPos, class_2350.field_11034, itemStack);
            scene.effects().rotationDirectionIndicator(cogPos);
            scene.idle(50);
            scene.world().modifyBlocks(gearshiftAndLever, s -> (class_2680)s.method_28493((class_2769)class_2741.field_12484), false);
            scene.world().modifyKineticSpeed(gearshiftedKinetics, f -> Float.valueOf(-f.floatValue()));
            scene.effects().indicateRedstone(util.grid().at(1, 2, 4));
            scene.effects().rotationDirectionIndicator(cogPos);
            scene.idle(35);
            scene.world().removeItemsFromBelt(beltPos);
            scene.world().flapFunnel(util.grid().at(2, 2, 2), false);
            if (i != 0) continue;
            scene.idle(50);
            scene.world().modifyBlocks(gearshiftAndLever, s -> (class_2680)s.method_28493((class_2769)class_2741.field_12484), false);
            scene.world().modifyKineticSpeed(gearshiftedKinetics, f -> Float.valueOf(-f.floatValue()));
            scene.effects().indicateRedstone(util.grid().at(1, 2, 4));
        }
    }

    public static void compat(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("funnel_compat", "Funnel compatibility");
        scene.configureBasePlate(0, 0, 5);
        class_2338 sawFunnel = util.grid().at(4, 2, 1);
        class_2338 depotFunnel = util.grid().at(2, 2, 2);
        class_2338 drainFunnel = util.grid().at(0, 2, 3);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        Selection firstShow = util.select().layer(1).add(util.select().position(sawFunnel.method_10072())).add(util.select().position(depotFunnel.method_10072())).add(util.select().position(drainFunnel.method_10072()));
        scene.idle(5);
        scene.world().showSection(firstShow, class_2350.field_11033);
        scene.idle(8);
        scene.overlay().showText(360).text("Funnels should also interact nicely with a handful of other components.").attachKeyFrame().independent(0);
        scene.idle(40);
        scene.world().showSection(util.select().position(sawFunnel), class_2350.field_11033);
        scene.overlay().showText(40).text("Vertical Saws").colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().centerOf(sawFunnel.method_10074()));
        scene.idle(8);
        scene.world().createItemOnBeltLike(sawFunnel.method_10074(), class_2350.field_11035, new class_1799((class_1935)class_2246.field_10431));
        scene.world().modifyBlockEntity(sawFunnel.method_10074(), SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.recipeDuration = 50.0f;
            inventory.remainingTime = 50.0f;
            inventory.appliedRecipe = false;
        });
        scene.idle(34);
        scene.world().modifyBlockEntity(sawFunnel.method_10074(), SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, new class_1799((class_1935)class_1802.field_8415));
            inventory.recipeDuration = 20.0f;
            inventory.remainingTime = 20.0f;
            inventory.appliedRecipe = true;
        });
        scene.idle(6);
        scene.world().showSection(util.select().position(depotFunnel), class_2350.field_11033);
        scene.overlay().showText(40).text("Depots").colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().centerOf(depotFunnel.method_10074()));
        scene.idle(8);
        scene.world().createItemOnBeltLike(depotFunnel.method_10074(), class_2350.field_11035, new class_1799((class_1935)class_1802.field_8335));
        scene.idle(40);
        scene.world().showSection(util.select().position(drainFunnel), class_2350.field_11033);
        scene.overlay().showText(40).text("Item Drains").colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector().centerOf(drainFunnel.method_10074()));
        scene.idle(8);
        scene.world().createItemOnBeltLike(drainFunnel.method_10074(), class_2350.field_11035, new class_1799((class_1935)class_1802.field_8705));
        scene.idle(40);
        scene.markAsFinished();
    }

    public static void redstone(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("funnel_redstone", "Redstone control");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().layersFrom(1), class_2350.field_11033);
        class_1799 itemStack = AllItems.BRASS_BLOCK.method_7854();
        class_243 topItemSpawn = util.vector().centerOf(3, 6, 2);
        ElementLink<EntityElement> lastItemEntity = null;
        class_2338 lever = util.grid().at(1, 2, 2);
        class_2338 redstone = util.grid().at(2, 2, 2);
        class_2338 funnel = util.grid().at(3, 2, 2);
        class_238 redstoneBB = new class_238(funnel).method_1009(-0.0625, -0.375, -0.0625).method_989(0.0, -0.3125, 0.0);
        for (int i = 0; i < 4; ++i) {
            if (lastItemEntity != null) {
                scene.world().modifyEntity(lastItemEntity, class_1297::method_31472);
            }
            lastItemEntity = scene.world().createItemEntity(topItemSpawn, util.vector().of(0.0, -0.2, 0.0), itemStack);
            scene.idle(8);
            if (i == 3) {
                scene.world().modifyBlock(lever, s -> (class_2680)s.method_28493((class_2769)class_2401.field_11265), false);
                scene.world().modifyBlock(redstone, s -> (class_2680)s.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(15)), false);
                scene.world().modifyBlock(funnel, s -> (class_2680)s.method_28493((class_2769)FunnelBlock.POWERED), false);
                scene.effects().indicateRedstone(lever);
                scene.idle(4);
                scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, funnel, redstoneBB, 80);
                scene.overlay().showText(80).colored(PonderPalette.RED).text("Redstone power will prevent any funnel from acting").pointAt(util.vector().blockSurface(funnel, class_2350.field_11033));
                continue;
            }
            scene.idle(4);
        }
        scene.idle(60);
    }

    public static void brass(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("brass_funnel", "The Brass Funnel");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 firstDepot = util.grid().at(3, 1, 1);
        class_2338 secondDepot = util.grid().at(1, 1, 1);
        Selection depots = util.select().fromTo(firstDepot, secondDepot);
        Selection beltAndStuff = util.select().fromTo(0, 1, 2, 4, 1, 2).add(util.select().fromTo(0, 1, 3, 0, 2, 5));
        Selection withoutBelt = util.select().layersFrom(1).substract(beltAndStuff).substract(depots);
        scene.world().showSection(withoutBelt, class_2350.field_11033);
        ElementLink<WorldSectionElement> independentSection = scene.world().showIndependentSection(depots, class_2350.field_11033);
        scene.world().moveSection(independentSection, util.vector().of(0.0, 0.0, 1.0), 0);
        class_2338 andesiteFunnel = util.grid().at(3, 2, 2);
        class_2338 brassFunnel = util.grid().at(1, 2, 2);
        class_1799 itemStack = AllItems.BRASS_INGOT.method_7854();
        scene.idle(10);
        scene.overlay().showText(60).text("Andesite Funnels can only ever extract single items.").attachKeyFrame().pointAt(util.vector().topOf(andesiteFunnel)).placeNearTarget();
        scene.idle(10);
        scene.world().createItemOnBeltLike(andesiteFunnel.method_10074().method_10095(), class_2350.field_11035, itemStack);
        scene.world().flapFunnel(andesiteFunnel, true);
        scene.idle(60);
        class_243 filter = util.vector().topOf(brassFunnel);
        scene.overlay().showText(60).text("Brass Funnels can extract up to a full stack.").attachKeyFrame().pointAt(filter).placeNearTarget();
        scene.idle(10);
        scene.world().createItemOnBeltLike(brassFunnel.method_10074().method_10095(), class_2350.field_11035, itemStack.method_46651(64));
        scene.world().flapFunnel(brassFunnel, true);
        scene.idle(60);
        filter = filter.method_1031(0.0, -0.3125, -0.09375);
        scene.overlay().showFilterSlotInput(filter, class_2350.field_11043, 80);
        scene.overlay().showControls(filter, Pointing.DOWN, 60).rightClick();
        scene.idle(10);
        scene.overlay().showText(80).text("The value panel allows for precise control over the extracted stack size.").attachKeyFrame().pointAt(filter).placeNearTarget();
        scene.idle(90);
        scene.world().hideIndependentSection(independentSection, class_2350.field_11043);
        scene.world().hideSection(util.select().position(brassFunnel), class_2350.field_11036);
        scene.idle(20);
        scene.world().modifyBlock(brassFunnel, s -> (class_2680)s.method_28493(BeltFunnelBlock.SHAPE), false);
        scene.world().showSection(util.select().position(brassFunnel), class_2350.field_11033);
        scene.world().showSection(beltAndStuff, class_2350.field_11035);
        scene.idle(10);
        class_1799 dirt = new class_1799((class_1935)class_1802.field_8831);
        class_1799 gravel = new class_1799((class_1935)class_1802.field_8110);
        class_1799 emerald = new class_1799((class_1935)class_1802.field_8687);
        for (int i = 0; i < 14; ++i) {
            if (i < 12) {
                scene.world().createItemOnBelt(andesiteFunnel.method_10074(), class_2350.field_11035, i % 3 == 0 ? dirt : (i % 3 == 1 ? gravel : emerald));
            }
            scene.idle(10);
            if (i > 0 && (i < 3 || i % 3 == 0)) {
                scene.world().removeItemsFromBelt(brassFunnel.method_10074());
                scene.world().flapFunnel(brassFunnel, false);
            }
            scene.world().modifyEntities(class_1542.class, e -> {
                if (e.method_23318() < 1.0) {
                    e.method_31472();
                }
            });
            if (i == 2) {
                scene.overlay().showFilterSlotInput(filter, class_2350.field_11043, 40);
                scene.overlay().showControls(filter, Pointing.DOWN, 60).rightClick().withItem(emerald);
                scene.idle(10);
                scene.overlay().showText(80).text("Using items on the filter slot will restrict the funnel to only transfer matching stacks.").attachKeyFrame().pointAt(filter).placeNearTarget();
                scene.world().setFilterData(util.select().position(brassFunnel), FunnelBlockEntity.class, emerald);
            } else {
                scene.idle(10);
            }
            if (i != 8) continue;
            scene.markAsFinished();
        }
    }

    public static void transposer(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("funnel_transfer", "Direct transfer");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 funnelPos = util.grid().at(2, 2, 2);
        Selection funnelSelect = util.select().position(funnelPos);
        ElementLink<WorldSectionElement> rightChest = scene.world().showIndependentSection(util.select().position(0, 2, 2), class_2350.field_11033);
        ElementLink<WorldSectionElement> leftChest = scene.world().showIndependentSection(util.select().position(4, 2, 2), class_2350.field_11033);
        scene.world().moveSection(rightChest, util.vector().of(2.0, 1.0, 0.0), 0);
        scene.world().moveSection(leftChest, util.vector().of(-2.0, -1.0, 0.0), 0);
        scene.idle(5);
        scene.world().showSection(funnelSelect, class_2350.field_11033);
        scene.idle(20);
        scene.overlay().showOutlineWithText(funnelSelect, 40).colored(PonderPalette.RED).text("Funnels cannot ever transfer between closed inventories directly.").attachKeyFrame().placeNearTarget();
        scene.idle(50);
        scene.world().hideSection(funnelSelect, class_2350.field_11035);
        scene.idle(20);
        scene.world().setBlocks(funnelSelect, AllBlocks.CHUTE.method_9564(), false);
        scene.world().showSection(funnelSelect, class_2350.field_11043);
        scene.idle(10);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).text("Chutes or Smart chutes might be more suitable for such purposes.").attachKeyFrame().pointAt(util.vector().centerOf(funnelPos)).placeNearTarget();
        scene.idle(50);
        scene.world().hideSection(funnelSelect, class_2350.field_11036);
        scene.world().hideIndependentSection(leftChest, class_2350.field_11036);
        scene.world().hideIndependentSection(rightChest, class_2350.field_11036);
        scene.idle(20);
        Selection belt = util.select().layer(1);
        scene.world().setBlocks(funnelSelect, class_2246.field_10124.method_9564(), false);
        scene.world().showSection(belt, class_2350.field_11033);
        scene.world().showSection(util.select().fromTo(0, 2, 2, 4, 2, 2), class_2350.field_11033);
        scene.overlay().showText(120).colored(PonderPalette.GREEN).text("Same applies for horizontal movement. A mechanical belt should help here.").pointAt(util.vector().topOf(1, 2, 2)).placeNearTarget();
        scene.markAsFinished();
    }
}

