/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client.tools;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.SchematicHandler;
import com.zurrtum.create.client.content.schematics.client.SchematicTransformation;
import com.zurrtum.create.client.content.schematics.client.tools.ISchematicTool;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public abstract class SchematicToolBase
implements ISchematicTool {
    protected SchematicHandler schematicHandler;
    protected class_2338 selectedPos;
    protected class_243 chasingSelectedPos;
    protected class_243 lastChasingSelectedPos;
    protected boolean selectIgnoreBlocks;
    protected int selectionRange;
    protected boolean schematicSelected;
    protected boolean renderSelectedFace;
    protected class_2350 selectedFace;

    @Override
    public void init() {
        this.schematicHandler = Create.SCHEMATIC_HANDLER;
        this.selectedPos = null;
        this.selectedFace = null;
        this.schematicSelected = false;
        this.chasingSelectedPos = class_243.field_1353;
        this.lastChasingSelectedPos = class_243.field_1353;
    }

    @Override
    public void updateSelection(class_310 mc) {
        this.updateTargetPos();
        if (this.selectedPos == null) {
            return;
        }
        this.lastChasingSelectedPos = this.chasingSelectedPos;
        class_243 target = class_243.method_24954((class_2382)this.selectedPos);
        if (target.method_1022(this.chasingSelectedPos) < 0.001953125) {
            this.chasingSelectedPos = target;
            return;
        }
        this.chasingSelectedPos = this.chasingSelectedPos.method_1019(target.method_1020(this.chasingSelectedPos).method_1021(0.5));
    }

    public void updateTargetPos() {
        boolean snap;
        class_746 player = class_310.method_1551().field_1724;
        if (this.schematicHandler.isDeployed()) {
            class_243 end;
            SchematicTransformation transformation = this.schematicHandler.getTransformation();
            class_238 localBounds = this.schematicHandler.getBounds();
            class_243 traceOrigin = player.method_33571();
            class_243 start = transformation.toLocalSpace(traceOrigin);
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil(start, end = transformation.toLocalSpace(RaycastHelper.getTraceTarget((class_1657)player, 70.0, traceOrigin)), pos -> localBounds.method_1006(VecHelper.getCenterOf((class_2382)pos)));
            this.schematicSelected = !result.missed();
            this.selectedFace = this.schematicSelected ? result.getFacing() : null;
        }
        boolean bl = snap = this.selectedPos == null;
        if (this.selectIgnoreBlocks) {
            float pt = AnimationTickHolder.getPartialTicks();
            this.selectedPos = class_2338.method_49638((class_2374)player.method_5836(pt).method_1019(player.method_5720().method_1021((double)this.selectionRange)));
            if (snap) {
                this.lastChasingSelectedPos = this.chasingSelectedPos = class_243.method_24954((class_2382)this.selectedPos);
            }
            return;
        }
        this.selectedPos = null;
        class_3965 trace = RaycastHelper.rayTraceRange(player.method_73183(), (class_1657)player, 75.0);
        if (trace == null || trace.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_2338 hit = class_2338.method_49638((class_2374)trace.method_17784());
        boolean replaceable = player.method_73183().method_8320(hit).method_45474();
        if (trace.method_17780().method_10166().method_10178() && !replaceable) {
            hit = hit.method_10093(trace.method_17780());
        }
        this.selectedPos = hit;
        if (snap) {
            this.lastChasingSelectedPos = this.chasingSelectedPos = class_243.method_24954((class_2382)this.selectedPos);
        }
    }

    @Override
    public void renderTool(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
    }

    @Override
    public void renderOverlay(class_329 gui, class_332 graphics, float partialTicks, int width, int height) {
    }

    @Override
    public void renderOnSchematic(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer) {
        if (!this.schematicHandler.isDeployed()) {
            return;
        }
        ms.method_22903();
        AABBOutline outline = this.schematicHandler.getOutline();
        if (this.renderSelectedFace) {
            outline.getParams().highlightFace(this.selectedFace).withFaceTextures(AllSpecialTextures.CHECKERED, AllKeys.hasControlDown() ? AllSpecialTextures.HIGHLIGHT_CHECKERED : AllSpecialTextures.CHECKERED);
        }
        outline.getParams().colored(6850245).withFaceTexture(AllSpecialTextures.CHECKERED).lineWidth(0.0625f);
        outline.render(class_310.method_1551(), ms, buffer, class_243.field_1353, AnimationTickHolder.getPartialTicks());
        outline.getParams().clearTextures();
        ms.method_22909();
    }
}

