/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zurrtum.create.AllAssemblyRecipeNames;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.render.DeployerRenderState;
import com.zurrtum.create.client.foundation.gui.render.PressRenderState;
import com.zurrtum.create.client.foundation.gui.render.SpoutRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.eiv.display.SequencedAssemblyDisplay;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.zurrtum.create.content.kinetics.press.PressingRecipe;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.infrastructure.component.BottleType;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.item.FluidItem;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class SequencedAssemblyView
extends CreateView {
    public static String[] ROMANS = new String[]{"I", "II", "III", "IV", "V", "VI", "-"};
    public static Map<class_3956<?>, SequencedRenderer<?>> RENDER = new IdentityHashMap();
    private final SlotContent result;
    private final List<SlotContent> ingredients;
    private final List<class_1860<?>> sequence;
    private final IntSet empty;
    private final float chance;
    private final int loops;

    public static <T extends class_1860<?>> SequencedRenderer<T> getRenderer(T recipe) {
        return RENDER.get(recipe.method_17716());
    }

    public static <T extends class_1860<?>> void registerRenderer(class_3956<T> type, SequencedRenderer<T> draw) {
        RENDER.put(type, draw);
    }

    public SequencedAssemblyView(SequencedAssemblyDisplay display) {
        ProcessingOutput output = display.result;
        this.result = SlotContent.of((class_1799)output.create());
        this.chance = output.chance();
        this.sequence = display.sequence;
        int size = this.sequence.size();
        this.ingredients = new ArrayList<SlotContent>(size + 1);
        this.empty = new IntOpenHashSet();
        for (int i = 0; i < size; ++i) {
            this.addSlot(this.sequence.get(i), i);
        }
        this.ingredients.add(SlotContent.of(display.ingredient));
        this.loops = display.loops;
    }

    private <T extends class_1860<?>> void addSlot(T sequence, int i) {
        SlotContent slot;
        SequencedRenderer<T> renderer = SequencedAssemblyView.getRenderer(sequence);
        if (renderer != null && (slot = renderer.createSlot(sequence)) != null) {
            this.ingredients.add(slot);
            return;
        }
        this.empty.add(i);
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.SEQUENCED_ASSEMBLY;
    }

    public List<SlotContent> getIngredients() {
        return this.ingredients;
    }

    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    @Override
    protected int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int i = 0;
        int size = this.sequence.size();
        int left = 91 - 14 * size;
        for (int j = 0; j < size; ++j) {
            if (this.empty.contains(j)) continue;
            slotDefinition.addItemSlot(i++, left + j * 28, 17);
        }
        if (this.chance == 1.0f) {
            slotDefinition.addItemSlot(i++, 22, 93);
            slotDefinition.addItemSlot(i++, 127, 93);
        } else {
            slotDefinition.addItemSlot(i++, 15, 93);
            slotDefinition.addItemSlot(i++, 120, 93);
        }
        return i;
    }

    @Override
    protected int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i = 0;
        Iterator<SlotContent> iterator = this.ingredients.iterator();
        int size = this.sequence.size();
        for (int j = 0; j < size; ++j) {
            if (this.empty.contains(j)) continue;
            slotFillContext.bindOptionalSlot(i, iterator.next(), SLOT);
            slotFillContext.addAdditionalStackModifier(i++, new SequenceTooltip(this.sequence.get(j), i));
        }
        slotFillContext.bindOptionalSlot(i++, iterator.next(), SLOT);
        if (this.chance == 1.0f) {
            slotFillContext.bindOptionalSlot(i++, this.result, SLOT);
        } else {
            this.bindChanceSlot(slotFillContext, i++, this.result, this.chance);
        }
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        boolean checkHover = screen.field_2787 == null;
        boolean checkStep = mouseY >= 7 && mouseY <= 86;
        class_327 textRenderer = screen.method_64506();
        Iterator<SlotContent> iterator = this.ingredients.iterator();
        int size = this.sequence.size();
        int left = 91 - 14 * size;
        for (int i = 0; i < size; ++i) {
            class_5250 text;
            class_1799 stack;
            int x = left + i * 28;
            String n = ROMANS[Math.min(i, ROMANS.length)];
            context.method_51433(textRenderer, n, x + 8 - textRenderer.method_1727(n) / 2, 4, -7829368, false);
            class_1860<?> recipe = this.sequence.get(i);
            if (this.empty.contains(i)) {
                stack = null;
            } else {
                SlotContent slot = iterator.next();
                stack = slot.getByIndex(slot.index());
            }
            SequencedRenderer<class_1860<?>> draw = SequencedAssemblyView.getRenderer(recipe);
            if (draw != null) {
                draw.render(context, i, x, 17, stack);
            } else {
                AllGuiTextures.JEI_CHANCE_SLOT.render(context, x - 1, 16);
                text = class_2561.method_43470((String)"?").method_27692(class_124.field_1067);
                context.method_51439(textRenderer, (class_2561)text, x + textRenderer.method_27525((class_5348)text) / -2 + 7, 21, -1052689, true);
            }
            if (!checkHover || !checkStep || mouseX <= x - 7 || mouseX >= x + 22) continue;
            checkHover = false;
            text = draw != null ? SequencedRenderer.getSequenceName(draw, recipe, stack) : SequencedRenderer.getSequenceName(recipe);
            List<class_5250> tooltip = List.of(CreateLang.translateDirect("recipe.assembly.step", i + 1), text.method_27661().method_27692(class_124.field_1077));
            context.method_51434(textRenderer, tooltip, mouseX + position.left(), mouseY + position.top());
        }
        int xOffset = 0;
        if (this.chance != 1.0f) {
            xOffset = -7;
            AllGuiTextures.JEI_CHANCE_SLOT.render(context, 138, 92);
            class_5250 text = class_2561.method_43470((String)"?").method_27692(class_124.field_1067);
            context.method_51439(textRenderer, (class_2561)text, 146 + textRenderer.method_27525((class_5348)text) / -2, 97, -1052689, true);
            if (checkHover && mouseX >= 138 && mouseX <= 155 && mouseY >= 92 && mouseY <= 109) {
                checkHover = false;
                context.method_25294(139, 93, 155, 109, -2130706433);
                float junk = 1.0f - this.chance;
                String number = (double)junk < 0.01 ? "<1" : ((double)junk > 0.99 ? ">99" : String.valueOf(Math.round(junk * 100.0f)));
                List<class_5250> tooltip = List.of(CreateLang.translateDirect("recipe.assembly.junk", new Object[0]), CreateLang.translateDirect("recipe.processing.chance", number).method_27692(class_124.field_1065));
                context.method_51434(textRenderer, tooltip, mouseX + position.left(), mouseY + position.top());
            }
        }
        AllGuiTextures.JEI_LONG_ARROW.render(context, xOffset + 47, 96);
        if (this.loops > 1) {
            AllIcons.I_SEQ_REPEAT.render(context, xOffset + 60, 101);
            context.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)("x" + this.loops)), xOffset + 76, 106, -7829368, false);
            if (checkHover && mouseX >= 43 && mouseX < 108 && mouseY >= 94 && mouseY < 118) {
                class_5250 text = CreateLang.translateDirect("recipe.assembly.repeat", this.loops);
                context.method_51438(textRenderer, (class_2561)text, mouseX + position.left(), mouseY + position.top());
            }
        }
    }

    static {
        SequencedAssemblyView.registerRenderer(AllRecipeTypes.PRESSING, new PressingRenderer());
        SequencedAssemblyView.registerRenderer(AllRecipeTypes.DEPLOYING, new DeployingRenderer());
        SequencedAssemblyView.registerRenderer(AllRecipeTypes.FILLING, new FillingRenderer());
    }

    @Environment(value=EnvType.CLIENT)
    public static interface SequencedRenderer<T extends class_1860<?>> {
        public static final Map<class_1860<?>, class_2561> NAMES = new WeakHashMap();

        public void render(class_332 var1, int var2, int var3, int var4, @Nullable class_1799 var5);

        public static class_2561 getSequenceName(class_1860<?> recipe) {
            class_2561 name = NAMES.get(recipe);
            if (name != null) {
                return name;
            }
            class_2960 id = class_7923.field_41188.method_10221((Object)recipe.method_17716());
            if (id == null) {
                name = class_5244.field_39003;
            } else {
                class_6903 ops = class_310.method_1551().field_1687.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE);
                name = class_1860.field_47319.encodeStart((DynamicOps)ops, recipe).result().map(json -> AllAssemblyRecipeNames.get((DynamicOps<JsonElement>)ops, json)).orElse(class_5244.field_39003);
            }
            NAMES.put(recipe, name);
            return name;
        }

        public static <T extends class_1860<?>> class_2561 getSequenceName(SequencedRenderer<?> render, T recipe, class_1799 stack) {
            return render.getSequenceName(recipe, stack);
        }

        default public class_2561 getSequenceName(T recipe, class_1799 stack) {
            return SequencedRenderer.getSequenceName(recipe);
        }

        @Nullable
        default public SlotContent createSlot(T recipe) {
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record SequenceTooltip<T extends class_1860<?>>(T recipe, int i) implements RecipeViewMenu.AdditionalStackModifier
    {
        public void addTooltip(class_1799 stack, List<class_2561> list) {
            SequencedRenderer<T> renderer = SequencedAssemblyView.getRenderer(this.recipe);
            class_2561 text = renderer == null ? SequencedRenderer.getSequenceName(this.recipe) : renderer.getSequenceName(this.recipe, stack);
            text = text.method_27661().method_27692(class_124.field_1077);
            if (list.isEmpty()) {
                list.add(text);
            } else {
                list.set(0, text);
            }
            list.addFirst((class_2561)CreateLang.translateDirect("recipe.assembly.step", this.i));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PressingRenderer
    implements SequencedRenderer<PressingRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, @Nullable class_1799 stack) {
            float scale = 0.6333333f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)x, (float)y);
            matrices.scale(scale, scale);
            matrices.translate((float)(-x), (float)(-y));
            graphics.field_59826.method_70922((class_11256)new PressRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), x - 3, y + 18, i));
            matrices.popMatrix();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DeployingRenderer
    implements SequencedRenderer<DeployerApplicationRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, @Nullable class_1799 stack) {
            float scale = 0.75641024f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)x, (float)y);
            matrices.scale(scale, scale);
            matrices.translate((float)(-x), (float)(-y));
            graphics.field_59826.method_70922((class_11256)new DeployerRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), x - 3, y + 18, i));
            matrices.popMatrix();
        }

        @Override
        public class_2561 getSequenceName(DeployerApplicationRecipe recipe, class_1799 stack) {
            return class_2561.method_43469((String)"create.recipe.assembly.deploying_item", (Object[])new Object[]{stack.method_7964()});
        }

        @Override
        public SlotContent createSlot(DeployerApplicationRecipe recipe) {
            return SlotContent.of((class_1856)recipe.ingredient());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FillingRenderer
    implements SequencedRenderer<FillingRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, @Nullable class_1799 stack) {
            class_1792 class_17922;
            if (stack != null && (class_17922 = stack.method_7909()) instanceof FluidItem) {
                FluidItem item = (FluidItem)class_17922;
                float scale = 0.76086956f;
                Matrix3x2fStack matrices = graphics.method_51448();
                matrices.pushMatrix();
                matrices.translate((float)x, (float)y);
                matrices.scale(scale, scale);
                matrices.translate((float)(-x), (float)(-y));
                class_3611 fluid = item.getFluid();
                class_9326 components = stack.method_57380();
                graphics.field_59826.method_70922((class_11256)new SpoutRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), fluid, components, x - 2, y + 24, i));
                matrices.popMatrix();
            }
        }

        @Override
        public class_2561 getSequenceName(FillingRecipe recipe, class_1799 stack) {
            class_2561 name;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof FluidItem) {
                FluidItem item = (FluidItem)class_17922;
                class_3611 fluid = item.getFluid();
                if (fluid == AllFluids.POTION) {
                    class_1844 contents = (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
                    BottleType bottleType = (BottleType)((Object)stack.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR));
                    class_1792 itemFromBottleType = PotionFluidHandler.itemFromBottleType(bottleType);
                    return contents.method_64195(itemFromBottleType.method_8389().method_7876() + ".effect.");
                }
                class_2248 block = fluid.method_15785().method_15759().method_26204();
                if (fluid != class_3612.field_15906 && block == class_2246.field_10124) {
                    return class_2561.method_43471((String)class_156.method_646((String)"block", (class_2960)class_7923.field_41173.method_10221((Object)fluid)));
                }
                name = block.method_9518();
            } else {
                name = class_5244.field_39003;
            }
            return class_2561.method_43469((String)"create.recipe.assembly.spout_filling_fluid", (Object[])new Object[]{name});
        }

        @Override
        public SlotContent createSlot(FillingRecipe recipe) {
            return SlotContent.of(CreateView.getItemStacks(recipe.fluidIngredient()));
        }
    }
}

