/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.PressRenderState;
import com.zurrtum.create.compat.eiv.display.PressingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class PressingView
extends CreateView {
    private final List<SlotContent> results;
    private final List<Float> chances;
    private final SlotContent ingredient;

    public PressingView(PressingDisplay display) {
        this.results = display.results.stream().map(SlotContent::of).toList();
        this.chances = display.chances;
        this.ingredient = SlotContent.of(display.ingredient);
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.PRESSING;
    }

    public List<SlotContent> getIngredients() {
        return List.of(this.ingredient);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    public int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int i;
        int size = this.results.size();
        for (i = 0; i < size; ++i) {
            slotDefinition.addItemSlot(i, 131 + 19 * i, 55);
        }
        slotDefinition.addItemSlot(i++, 27, 55);
        return i;
    }

    @Override
    public int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        int size = this.results.size();
        for (i = 0; i < size; ++i) {
            float chance = this.chances.get(i).floatValue();
            if (chance == 1.0f) {
                slotFillContext.bindOptionalSlot(i, this.results.get(i), SLOT);
                continue;
            }
            this.bindChanceSlot(slotFillContext, i, this.results.get(i), chance);
        }
        slotFillContext.bindOptionalSlot(i++, this.ingredient, SLOT);
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_SHADOW.render(context, 61, 45);
        AllGuiTextures.JEI_LONG_ARROW.render(context, 52, 58);
        context.field_59826.method_70922((class_11256)new PressRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 73, -12));
    }
}

