/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.FanRenderState;
import com.zurrtum.create.compat.eiv.display.FanWashingDisplay;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_332;
import net.minecraft.class_3612;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class FanWashingView
extends CreateView {
    private final List<SlotContent> results;
    private final SlotContent ingredient;
    private final List<Float> chances;

    public FanWashingView(FanWashingDisplay display) {
        this.results = display.results.stream().map(SlotContent::of).toList();
        this.chances = display.chances;
        this.ingredient = SlotContent.of(display.ingredient);
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.FAN_WASHING;
    }

    public List<SlotContent> getIngredients() {
        return List.of(this.ingredient);
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    protected int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int size = this.results.size();
        if (size == 1) {
            slotDefinition.addItemSlot(0, 17, 55);
            slotDefinition.addItemSlot(1, 137, 55);
            return 2;
        }
        int xOffsetAmount = 1 - Math.min(3, size);
        slotDefinition.addItemSlot(0, 17 + xOffsetAmount * 5, 55);
        int left = (size == 2 ? 137 : 132) + xOffsetAmount * 9;
        int top = 55;
        for (int i = 0; i < size; ++i) {
            slotDefinition.addItemSlot(i + 1, left + i % 3 * 19, top + i / 3 * -19);
        }
        return size + 1;
    }

    @Override
    protected int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        slotFillContext.bindOptionalSlot(0, this.ingredient, SLOT);
        int size = this.results.size();
        for (int i = 0; i < size; ++i) {
            float chance = this.chances.get(i).floatValue();
            if (chance == 1.0f) {
                slotFillContext.bindOptionalSlot(i + 1, this.results.get(i), SLOT);
                continue;
            }
            this.bindChanceSlot(slotFillContext, i + 1, this.results.get(i), chance);
        }
        return size + 1;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        int xOffsetAmount = 1 - Math.min(3, this.results.size());
        AllGuiTextures.JEI_SHADOW.render(context, 42, 34);
        AllGuiTextures.JEI_LIGHT.render(context, 61, 46);
        AllGuiTextures.JEI_LONG_ARROW.render(context, 50 + 7 * xOffsetAmount, 58);
        context.field_59826.method_70922((class_11256)new FanRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 52, 11, class_3612.field_15910.method_15785().method_15759()));
    }
}

