/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv.view;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.compat.eiv.CreateView;
import com.zurrtum.create.client.compat.eiv.EivClientPlugin;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.render.BasinBlazeBurnerRenderState;
import com.zurrtum.create.client.foundation.gui.render.PressBasinRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.compat.eiv.display.CompactingDisplay;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11256;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class CompactingView
extends CreateView {
    private final List<SlotContent> results;
    private final List<Float> chances;
    private final List<SlotContent> ingredients;
    private final HeatCondition heat;
    private final SlotContent burner;
    private final SlotContent cake;

    public CompactingView(CompactingDisplay display) {
        this.results = display.results.stream().map(SlotContent::of).toList();
        this.chances = display.chances;
        this.ingredients = new ArrayList<SlotContent>(display.ingredients.size() + display.fluidIngredients.size());
        for (List<class_1799> ingredient : display.ingredients) {
            this.ingredients.add(SlotContent.of(ingredient));
        }
        for (FluidIngredient fluidIngredient : display.fluidIngredients) {
            this.ingredients.add(SlotContent.of(CompactingView.getItemStacks(fluidIngredient)));
        }
        this.heat = display.heat;
        this.burner = this.heat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE) ? null : SlotContent.of((class_1792)AllItems.BLAZE_BURNER);
        this.cake = this.heat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED) ? null : SlotContent.of((class_1792)AllItems.BLAZE_CAKE);
    }

    public IEivRecipeViewType getViewType() {
        return EivClientPlugin.PACKING;
    }

    public List<SlotContent> getIngredients() {
        return this.ingredients;
    }

    public List<SlotContent> getResults() {
        return this.results;
    }

    @Override
    public int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int i;
        int yOffset;
        int size = this.ingredients.size();
        int xOffset = size < 3 ? 8 + (3 - size) * 19 / 2 : 8;
        int n = yOffset = size <= 9 ? 51 : 60;
        for (i = 0; i < size; ++i) {
            slotDefinition.addItemSlot(i, xOffset + i % 3 * 19, yOffset - i / 3 * 19);
        }
        size = this.results.size();
        int end = size - 1;
        for (int j = 0; j < end; ++j) {
            slotDefinition.addItemSlot(i++, j % 2 == 0 ? 128 : 147, 51 - 19 * (j / 2));
        }
        if (size % 2 != 0) {
            slotDefinition.addItemSlot(i++, 138, 51 - 19 * (end / 2));
        } else {
            slotDefinition.addItemSlot(i++, end % 2 == 0 ? 128 : 147, 51 - 19 * (end / 2));
        }
        if (this.burner != null) {
            slotDefinition.addItemSlot(i++, 130, 81);
        }
        if (this.cake != null) {
            slotDefinition.addItemSlot(i++, 149, 81);
        }
        return i;
    }

    @Override
    public int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int i;
        int size = this.ingredients.size();
        for (i = 0; i < size; ++i) {
            slotFillContext.bindOptionalSlot(i, this.ingredients.get(i), SLOT);
        }
        int size2 = this.chances.size();
        for (int j = 0; j < size2; ++j) {
            float chance = this.chances.get(j).floatValue();
            if (chance == 1.0f) {
                slotFillContext.bindOptionalSlot(i++, this.results.get(j), SLOT);
                continue;
            }
            this.bindChanceSlot(slotFillContext, i++, this.results.get(j), chance);
        }
        if (this.burner != null) {
            slotFillContext.bindSlot(i++, this.burner);
        }
        if (this.cake != null) {
            slotFillContext.bindSlot(i++, this.cake);
        }
        return i;
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition position, class_332 context, int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.JEI_DOWN_ARROW.render(context, 132, 32 - (this.results.size() - 1) / 2 * 19);
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)context.method_51448());
        if (this.heat == HeatCondition.NONE) {
            AllGuiTextures.JEI_NO_HEAT_BAR.render(context, 0, 80);
            AllGuiTextures.JEI_SHADOW.render(context, 77, 68);
        } else {
            AllGuiTextures.JEI_HEAT_BAR.render(context, 0, 80);
            AllGuiTextures.JEI_LIGHT.render(context, 77, 88);
            context.field_59826.method_70922((class_11256)new BasinBlazeBurnerRenderState(pose, 87, 69, this.heat.visualizeAsBlazeBurner()));
        }
        context.field_59826.method_70922((class_11256)new PressBasinRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), 87, -5));
        context.method_51439(context.field_44656.field_1772, (class_2561)CreateLang.translateDirect(this.heat.getTranslationKey(), new Object[0]), 5, 86, this.heat.getColor(), false);
    }
}

