/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.UUID;
import net.minecraft.class_10017;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.ETFConfigWarning;
import traben.entity_texture_features.config.ETFConfigWarnings;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.property_reading.TrueRandomProvider;
import traben.entity_texture_features.features.property_reading.properties.RandomProperties;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.features.state.HoldsETFRenderState;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public final class ETFApi {
    public static final int ETFApiVersion = 11;
    public static final UUID ETF_GENERIC_UUID = UUID.nameUUIDFromBytes("GENERIC".getBytes());
    public static final long ETF_SPAWNER_MARKER = 0x303900003039L;
    @Deprecated
    public static ETFConfig getETFConfigObject = null;

    public static ETFConfig getETFConfigObject() {
        return ETF.config().getConfig();
    }

    public static void setETFConfigObject(ETFConfig newETFConfig) {
        if (newETFConfig != null) {
            ETF.config().setConfig(newETFConfig);
            ETFApi.saveETFConfigChangesAndResetETF();
        } else {
            ETFUtils2.logError("new config was null: ignoring.");
        }
    }

    public static ETFConfig getCopyOfETFConfigObject() {
        return ETF.config().copyOfConfig();
    }

    public static ETFConfig getDefaultETFConfigObject() {
        return new ETFConfig();
    }

    public static String getBlockEntityTypeToTranslationKey(class_2591<?> type) {
        class_2960 id = class_2591.method_11033(type);
        if (id == null) {
            return null;
        }
        return "block." + id.method_12836() + "." + id.method_12832();
    }

    public static void saveETFConfigChangesAndResetETF() {
        ETF.config().saveToFile();
        ETFManager.resetInstance();
    }

    public static void resetETF() {
        ETFManager.resetInstance();
    }

    public static UUID getUUIDForBlockEntity(class_2586 blockEntity) {
        class_2680 blockEntityState = blockEntity.method_11010();
        long most = blockEntityState == null ? Long.MAX_VALUE : (long)blockEntityState.hashCode();
        class_2338 pos = blockEntity.method_11016();
        long least = pos == null ? 0L : pos.method_10063();
        return new UUID(most, least);
    }

    public static ETFEntityRenderState stateOfEntityOrEntityState(Object entity) {
        if (entity instanceof ETFEntity) {
            ETFEntity etfEntity = (ETFEntity)entity;
            return ETFEntityRenderState.forEntity(etfEntity);
        }
        if (entity instanceof HoldsETFRenderState) {
            HoldsETFRenderState holdsETFRenderState = (HoldsETFRenderState)entity;
            return holdsETFRenderState.etf$getState();
        }
        throw new IllegalArgumentException("Entity must be an instance of ETFEntity or HoldsETFRenderState");
    }

    @NotNull
    public static class_2960 getCurrentETFVariantTextureOfEntity(@NotNull class_1297 entity, @NotNull class_2960 defaultTexture) {
        if (entity != null) {
            class_2960 etfIdentifier;
            ETFEntity etfEntity = (ETFEntity)entity;
            ETFEntityRenderState state = ETFApi.stateOfEntityOrEntityState(etfEntity);
            ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, state);
            if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(state)) != null) {
                return etfIdentifier;
            }
        }
        return defaultTexture;
    }

    public static class_2960 getCurrentETFVariantTextureOfBlockEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture) {
        if (entity != null) {
            ETFEntity etfEntity = (ETFEntity)entity;
            return ETFApi.getCurrentETFVariantTextureOfBlockEntityInternal(etfEntity, defaultTexture);
        }
        return defaultTexture;
    }

    public static class_2960 getCurrentETFVariantTextureOfBlockEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture, @NotNull UUID specifiedUUID) {
        if (entity != null) {
            ETFEntity etfEntity = (ETFEntity)entity;
            return ETFApi.getCurrentETFVariantTextureOfBlockEntityInternal(etfEntity, defaultTexture);
        }
        return defaultTexture;
    }

    private static class_2960 getCurrentETFVariantTextureOfBlockEntityInternal(@NotNull ETFEntity etfEntity, @NotNull class_2960 defaultTexture) {
        class_2960 etfIdentifier;
        ETFEntityRenderState state = ETFApi.stateOfEntityOrEntityState(etfEntity);
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, state);
        if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(state)) != null) {
            return etfIdentifier;
        }
        return defaultTexture;
    }

    @Deprecated
    @NotNull
    public static class_2960 getCurrentETFVariantTextureOfEntity(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture, UUID ignore) {
        return ETFApi.getCurrentETFVariantTextureOfBlockEntity(entity, defaultTexture);
    }

    @Nullable
    public static class_2960 getCurrentETFEmissiveTextureOfEntityOrNull(@NotNull class_1297 entity, @NotNull class_2960 defaultTexture) {
        ETFTexture etfTexture;
        if (entity != null && (etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, ETFApi.stateOfEntityOrEntityState(entity))) != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    @Nullable
    public static class_2960 getCurrentETFEmissiveTextureOfBlockEntityOrNull(@NotNull class_2586 entity, @NotNull class_2960 defaultTexture) {
        ETFTexture etfTexture;
        if (entity != null && (etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTexture, ETFApi.stateOfEntityOrEntityState(entity))) != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    public static void renderETFEmissiveModel(@NotNull class_1297 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_3879 model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, ETFApi.stateOfEntityOrEntityState(entity));
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull class_1297 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_630 modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, ETFApi.stateOfEntityOrEntityState(entity));
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    public static void renderETFEmissiveModel(@NotNull class_2586 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_3879 model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, ETFApi.stateOfEntityOrEntityState(entity));
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull class_2586 entity, @NotNull class_2960 defaultTextureOfEntity, @NotNull class_4587 matrixStack, @NotNull class_4597 vertexConsumerProvider, @NotNull class_630 modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTextureVariant(defaultTextureOfEntity, ETFApi.stateOfEntityOrEntityState(entity));
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    @Nullable
    public static ETFVariantSuffixProvider getVariantSupplierOrNull(class_2960 propertiesFileIdentifier, class_2960 vanillaIdentifier, String ... suffixKeys) {
        return ETFVariantSuffixProvider.getVariantProviderOrNull(propertiesFileIdentifier, vanillaIdentifier, suffixKeys);
    }

    @Deprecated
    public static int getLastMatchingRuleOfEntity(class_1297 entity) {
        return 0;
    }

    @Deprecated
    public static int getLastMatchingRuleOfBlockEntity(class_2586 entity) {
        return 0;
    }

    public static void registerCustomRandomPropertyFactory(String yourModId, RandomProperties.RandomPropertyFactory ... factories) {
        if (factories != null && factories.length != 0) {
            RandomProperties.register(factories);
            ETFUtils2.logMessage(factories.length + " new ETF Random Properties registered by " + yourModId);
        }
    }

    public static void registerCustomETFConfigWarning(String yourModId, ETFConfigWarning ... warnings) {
        if (warnings != null && warnings.length != 0) {
            ETFConfigWarnings.registerConfigWarning(warnings);
            ETFUtils2.logMessage(warnings.length + " new ETF Config Warnings registered by " + yourModId);
        }
    }

    public static interface ETFVariantSuffixProvider {
        @Nullable
        public static ETFVariantSuffixProvider getVariantProviderOrNull(class_2960 propertiesFileIdentifier, class_2960 vanillaIdentifier, String ... suffixKeyName) {
            TrueRandomProvider random;
            PropertiesRandomProvider optifine = PropertiesRandomProvider.of(propertiesFileIdentifier, vanillaIdentifier, suffixKeyName);
            TrueRandomProvider trueRandomProvider = random = ETFRenderContext.isRandomLimitedToProperties() ? null : TrueRandomProvider.of(vanillaIdentifier);
            if (optifine == null && vanillaIdentifier.method_12832().endsWith(".png") && "minecraft".equals(vanillaIdentifier.method_12836()) && vanillaIdentifier.method_12832().contains("_")) {
                String vanId = vanillaIdentifier.method_12832().replaceAll("_(tame|angry|nectar|shooting|cold)", "");
                optifine = PropertiesRandomProvider.of(ETFUtils2.res(vanId.replace(".png", ".properties")), ETFUtils2.res(vanId), suffixKeyName);
            }
            if (random == null && optifine == null) {
                return null;
            }
            if (optifine == null) {
                return random;
            }
            if (random == null) {
                return optifine;
            }
            return optifine.isHigherPackThan(random.getPackName()) ? optifine : random;
        }

        public boolean entityCanUpdate(UUID var1);

        public IntOpenHashSet getAllSuffixes();

        public int size();

        default public int getSuffixForEntity(class_1297 entityToBeTested) {
            return this.getSuffixForETFEntity(ETFEntityRenderState.forEntity((ETFEntity)entityToBeTested));
        }

        default public int getSuffixForEntityState(class_10017 entityToBeTested) {
            return this.getSuffixForETFEntity(((HoldsETFRenderState)entityToBeTested).etf$getState());
        }

        default public int getSuffixForBlockEntity(class_2586 entityToBeTested) {
            return this.getSuffixForETFEntity(ETFEntityRenderState.forEntity((ETFEntity)entityToBeTested));
        }

        public int getSuffixForETFEntity(ETFEntityRenderState var1);

        @Deprecated(forRemoval=true)
        default public void setRandomSupplier(EntityRandomSeedFunction entityRandomSeedFunction) {
        }

        @Deprecated(forRemoval=true)
        public static interface EntityRandomSeedFunction {
            public int toInt(ETFEntityRenderState var1);
        }
    }
}

