/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.blue.endless.jankson.magic;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.DeserializationException;
import org.jetbrains.annotations.Nullable;

public class TypeMagic {
    private static Map<Class<?>, Class<?>> concreteClasses = new HashMap();

    @Nullable
    public static Class<?> classForType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            Type subtype = ((ParameterizedType)t).getRawType();
            if (subtype instanceof Class) {
                return (Class)subtype;
            }
            String className = t.getTypeName();
            int typeParamStart = className.indexOf(60);
            if (typeParamStart >= 0) {
                className = className.substring(0, typeParamStart);
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (t instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)t).getUpperBounds();
            if (upperBounds.length == 0) {
                return Object.class;
            }
            return TypeMagic.classForType(upperBounds[0]);
        }
        if (t instanceof TypeVariable) {
            return Object.class;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)t;
            Class<?> componentClass = TypeMagic.classForType(arrayType.getGenericComponentType());
            try {
                Class<?> arrayClass = Class.forName("[L" + componentClass.getCanonicalName() + ";");
                return arrayClass;
            }
            catch (ClassNotFoundException ex2) {
                return Object[].class;
            }
        }
        return null;
    }

    @Nullable
    public static <U> U createAndCast(Type t) {
        try {
            return (U)TypeMagic.createAndCast(TypeMagic.classForType(t), false);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static <U> U createAndCastCarefully(Type t) throws DeserializationException {
        return TypeMagic.createAndCast(TypeMagic.classForType(t));
    }

    @Nullable
    public static <U> U createAndCast(Class<U> t, boolean failFast) throws DeserializationException {
        Class<?> substitute;
        if (t.isInterface() && (substitute = concreteClasses.get(t)) != null) {
            try {
                return TypeMagic.createAndCast(substitute);
            }
            catch (Throwable ex) {
                return null;
            }
        }
        Constructor<U> noArg = null;
        try {
            noArg = t.getConstructor(new Class[0]);
        }
        catch (Throwable ex2) {
            try {
                noArg = t.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable ex3) {
                if (failFast) {
                    throw new DeserializationException("Class " + t.getCanonicalName() + " doesn't have a no-arg constructor, so an instance can't be created.");
                }
                return null;
            }
        }
        try {
            boolean available = noArg.isAccessible();
            if (!available) {
                noArg.setAccessible(true);
            }
            U u = noArg.newInstance(new Object[0]);
            if (!available) {
                noArg.setAccessible(false);
            }
            return u;
        }
        catch (Throwable ex) {
            if (failFast) {
                throw new DeserializationException("An error occurred while creating an object.", ex);
            }
            return null;
        }
    }

    public static <T> T shoehorn(Object o) {
        return (T)o;
    }

    static {
        concreteClasses.put(Map.class, HashMap.class);
        concreteClasses.put(Set.class, HashSet.class);
        concreteClasses.put(Collection.class, ArrayList.class);
        concreteClasses.put(List.class, ArrayList.class);
        concreteClasses.put(Queue.class, ArrayDeque.class);
        concreteClasses.put(Deque.class, ArrayDeque.class);
    }
}

