/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.impl.network;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.ConfigModification;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.api.sync.SyncBehavior;
import net.frozenblock.lib.config.api.sync.annotation.EntrySyncData;
import net.frozenblock.lib.config.api.sync.network.ConfigSyncData;
import net.frozenblock.lib.config.impl.network.ConfigSyncPacket;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ConfigSyncModification<T>(Config<T> config, DataSupplier<T> dataSupplier) implements Consumer<T>
{
    @Override
    public void accept(T destination) {
        try {
            ConfigSyncData<T> syncData = this.dataSupplier.get(this.config);
            if (syncData == null || !FrozenNetworking.connectedToServer()) {
                new Exception("Attempted to sync config " + String.valueOf(this.config.path()) + " for mod " + this.config.modId() + " outside a server!").printStackTrace();
                return;
            }
            T source = syncData.instance();
            this.config.setSynced(true);
            ConfigModification.copyInto(source, destination, true);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @ApiStatus.Internal
    public static <T> void clearSyncData(Config<T> config) {
        if (!ConfigRegistry.contains(config)) {
            throw new IllegalStateException("Config " + String.valueOf(config) + " not in registry!");
        }
        ConfigRegistry.removeSyncData(config);
        ConfigRegistry.getModificationsForConfig(config).keySet().removeIf(key -> key.modification() instanceof ConfigSyncModification);
        config.setSynced(false);
    }

    public static boolean isSyncable(@NotNull Field field) {
        EntrySyncData entrySyncData = field.getAnnotation(EntrySyncData.class);
        return entrySyncData == null || entrySyncData.behavior().canSync();
    }

    public static boolean isLockedWhenSynced(@NotNull Field field) {
        EntrySyncData entrySyncData = field.getAnnotation(EntrySyncData.class);
        return entrySyncData != null && entrySyncData.behavior() == SyncBehavior.LOCK_WHEN_SYNCED;
    }

    @Environment(value=EnvType.CLIENT)
    public static ConfigModification.EntryPermissionType canModifyField(@Nullable Field field, @Nullable Config<?> config) {
        if (config != null && field != null && config.supportsSync()) {
            boolean isOperator = ConfigSyncPacket.hasPermissionsToSendSync((class_1657)class_310.method_1551().field_1724, false);
            if (!config.isSynced() || isOperator) {
                return ConfigModification.EntryPermissionType.CAN_MODIFY;
            }
            if (ConfigSyncModification.isSyncable(field)) {
                return ConfigModification.EntryPermissionType.LOCKED_DUE_TO_SYNC;
            }
            if (ConfigSyncModification.isLockedWhenSynced(field)) {
                return ConfigModification.EntryPermissionType.LOCKED_DUE_TO_SERVER;
            }
        }
        return ConfigModification.EntryPermissionType.CAN_MODIFY;
    }

    @FunctionalInterface
    public static interface DataSupplier<T> {
        public ConfigSyncData<T> get(Config<T> var1);
    }
}

