/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.VoxelMapRenderTypes;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class WaypointContainer {
    private final List<ExtendedWaypoint> wayPts = new ArrayList<ExtendedWaypoint>();
    private Waypoint highlightedWaypoint;
    public final MapSettingsManager options;
    public final class_310 minecraft = class_310.method_1551();

    public WaypointContainer(MapSettingsManager options) {
        this.options = options;
    }

    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(new ExtendedWaypoint(newWaypoint));
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.wayPts.removeIf(point -> point.waypoint == waypoint);
    }

    public void setHighlightedWaypoint(Waypoint highlightedWaypoint) {
        this.highlightedWaypoint = highlightedWaypoint;
    }

    private void sortWaypoints() {
        this.wayPts.sort(Collections.reverseOrder());
    }

    public void renderWaypoints(float gameTimeDeltaPartialTick, class_4587 poseStack, class_4597.class_4598 bufferSource, class_4184 camera) {
        class_243 cameraPos = camera.method_19326();
        double renderPosX = cameraPos.field_1352;
        double renderPosY = cameraPos.field_1351;
        double renderPosZ = cameraPos.field_1350;
        if (this.options.showBeacons) {
            for (ExtendedWaypoint pt : this.wayPts) {
                if (!pt.waypoint.isActive() && pt.waypoint != this.highlightedWaypoint) continue;
                int x = pt.waypoint.getX();
                int z = pt.waypoint.getZ();
                double bottomOfWorld = (double)VoxelConstants.getPlayer().method_73183().method_31607() - renderPosY;
                this.renderBeam(pt.waypoint, (double)x - renderPosX, bottomOfWorld, (double)z - renderPosZ, poseStack, bufferSource);
            }
        }
        if (this.options.showWaypoints && !this.minecraft.field_1690.field_1842) {
            this.sortWaypoints();
            boolean shiftDown = this.minecraft.field_1690.field_1832.method_1434();
            int last = this.wayPts.size() - 1;
            int i = 0;
            for (ExtendedWaypoint pt : this.wayPts) {
                boolean isHighlighted;
                boolean bl = isHighlighted = pt.waypoint == this.highlightedWaypoint;
                if (pt.waypoint.isActive() || isHighlighted) {
                    int x = pt.waypoint.getX();
                    int z = pt.waypoint.getZ();
                    int y = pt.waypoint.getY();
                    double distance = Math.sqrt(pt.waypoint.getDistanceSqToCamera(camera));
                    if (distance < (double)this.options.maxWaypointDisplayDistance || this.options.maxWaypointDisplayDistance < 0 || isHighlighted) {
                        double offset = this.getCenterOffset(pt.waypoint, distance, camera);
                        boolean isPointedAt = offset != -1.0 && (shiftDown || i == last);
                        this.renderLabel(poseStack, bufferSource, pt.waypoint, distance, isPointedAt, false, (double)x - renderPosX, (double)y - renderPosY + 1.12, (double)z - renderPosZ);
                        pt.offset = offset;
                        pt.target = isHighlighted;
                    }
                }
                ++i;
            }
            if (this.highlightedWaypoint != null && !VoxelConstants.getMinecraft().field_1690.field_1842) {
                int x = this.highlightedWaypoint.getX();
                int z = this.highlightedWaypoint.getZ();
                int y = this.highlightedWaypoint.getY();
                double distance = Math.sqrt(this.highlightedWaypoint.getDistanceSqToCamera(camera));
                boolean isPointedAt = this.getCenterOffset(this.highlightedWaypoint, distance, camera) != -1.0;
                this.renderLabel(poseStack, bufferSource, this.highlightedWaypoint, distance, isPointedAt, true, (double)x - renderPosX, (double)y - renderPosY + 1.12, (double)z - renderPosZ);
            }
        }
    }

    private double getCenterOffset(Waypoint waypoint, double distance, class_4184 camera) {
        double dz;
        double dy;
        if (distance < 1.0) {
            return -1.0;
        }
        class_243 cameraPos = camera.method_19326();
        double degrees = 5.0 + Math.min(5.0 / distance, 5.0);
        double angle = degrees * 0.01745329238474369;
        double size = Math.max(Math.sin(angle) * distance, 0.5) * (double)this.options.waypointSignScale;
        Vector3f lookVector = camera.method_19335();
        class_243 scaledLookVector = cameraPos.method_1031((double)lookVector.x * distance, (double)lookVector.y * distance, (double)lookVector.z * distance);
        double dx = (double)((float)waypoint.getX() + 0.5f) - scaledLookVector.field_1352;
        double distFromCenter = dx * dx + (dy = (double)((float)waypoint.getY() + 1.5f) - scaledLookVector.field_1351) * dy + (dz = (double)((float)waypoint.getZ() + 0.5f) - scaledLookVector.field_1350) * dz;
        if (distFromCenter <= size * size) {
            return distFromCenter;
        }
        return -1.0;
    }

    private void renderBeam(Waypoint par1EntityWaypoint, double baseX, double baseY, double baseZ, class_4587 poseStack, class_4597.class_4598 bufferSource) {
        int height = VoxelConstants.getClientWorld().method_31605();
        float brightness = 0.1f;
        double topWidthFactor = 1.05;
        double bottomWidthFactor = 1.05;
        float r = par1EntityWaypoint.red;
        float b = par1EntityWaypoint.blue;
        float g = par1EntityWaypoint.green;
        class_4588 vertexConsumerBeam = bufferSource.method_73477(VoxelMapRenderTypes.WAYPOINT_BEAM);
        for (int width = 0; width < 4; ++width) {
            double d6 = 0.1 + (double)width * 0.2;
            d6 *= topWidthFactor;
            double d7 = 0.1 + (double)width * 0.2;
            d7 *= bottomWidthFactor;
            for (int side = 0; side < 5; ++side) {
                float vertX2 = (float)(baseX + 0.5 - d6);
                float vertZ2 = (float)(baseZ + 0.5 - d6);
                if (side == 1 || side == 2) {
                    vertX2 = (float)((double)vertX2 + d6 * 2.0);
                }
                if (side == 2 || side == 3) {
                    vertZ2 = (float)((double)vertZ2 + d6 * 2.0);
                }
                float vertX1 = (float)(baseX + 0.5 - d7);
                float vertZ1 = (float)(baseZ + 0.5 - d7);
                if (side == 1 || side == 2) {
                    vertX1 = (float)((double)vertX1 + d7 * 2.0);
                }
                if (side == 2 || side == 3) {
                    vertZ1 = (float)((double)vertZ1 + d7 * 2.0);
                }
                vertexConsumerBeam.method_56824(poseStack.method_23760(), vertX1, (float)baseY + 0.0f, vertZ1).method_22915(r * brightness, g * brightness, b * brightness, 0.8f);
                vertexConsumerBeam.method_56824(poseStack.method_23760(), vertX2, (float)baseY + (float)height, vertZ2).method_22915(r * brightness, g * brightness, b * brightness, 0.8f);
            }
        }
    }

    private void renderLabel(class_4587 poseStack, class_4597.class_4598 bufferSource, Waypoint pt, double distance, boolean isPointedAt, boolean target, double baseX, double baseY, double baseZ) {
        Sprite icon;
        float fade;
        Object name = pt.name;
        if (target) {
            if (pt.red == 2.0f && pt.green == 0.0f && pt.blue == 0.0f) {
                name = "X:" + pt.getX() + ", Y:" + pt.getY() + ", Z:" + pt.getZ();
            } else {
                isPointedAt = false;
            }
        }
        double maxDistance = (double)((Integer)this.minecraft.field_1690.method_42510().method_41753()).intValue() * 16.0 * 0.99;
        double adjustedDistance = distance;
        if (distance > maxDistance) {
            baseX = baseX / distance * maxDistance;
            baseY = baseY / distance * maxDistance;
            baseZ = baseZ / distance * maxDistance;
            adjustedDistance = maxDistance;
        }
        float scale = ((float)adjustedDistance * 0.1f + 1.0f) * 0.0266f * this.options.waypointSignScale;
        poseStack.method_22903();
        poseStack.method_46416((float)baseX + 0.5f, (float)baseY + 0.5f, (float)baseZ + 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-VoxelConstants.getMinecraft().method_1561().field_4686.method_19330()));
        poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(VoxelConstants.getMinecraft().method_1561().field_4686.method_19329()));
        poseStack.method_22905(-scale, -scale, -scale);
        float f = fade = distance > 5.0 ? 1.0f : (float)distance / 5.0f;
        if (!pt.enabled && !target) {
            fade *= 0.5f;
        }
        float fadeNoDepth = fade;
        if (!isPointedAt) {
            fadeNoDepth *= 0.5f;
        }
        float width = 10.0f;
        float r = target ? 1.0f : pt.red;
        float g = target ? 0.0f : pt.green;
        float b = target ? 0.0f : pt.blue;
        TextureAtlas textureAtlas = VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas();
        Sprite sprite = icon = target ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
        if (icon == textureAtlas.getMissingImage()) {
            icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
        }
        class_1921 renderType = VoxelMapRenderTypes.WAYPOINT_ICON_DEPTHTEST.apply(icon.getResourceLocation());
        class_4588 vertexIconDepthtest = bufferSource.method_73477(renderType);
        vertexIconDepthtest.method_56824(poseStack.method_23760(), -width, -width, 0.0f).method_22913(icon.getMinU(), icon.getMinV()).method_22915(r, g, b, fade);
        vertexIconDepthtest.method_56824(poseStack.method_23760(), -width, width, 0.0f).method_22913(icon.getMinU(), icon.getMaxV()).method_22915(r, g, b, fade);
        vertexIconDepthtest.method_56824(poseStack.method_23760(), width, width, 0.0f).method_22913(icon.getMaxU(), icon.getMaxV()).method_22915(r, g, b, fade);
        vertexIconDepthtest.method_56824(poseStack.method_23760(), width, -width, 0.0f).method_22913(icon.getMaxU(), icon.getMinV()).method_22915(r, g, b, fade);
        bufferSource.method_22994(renderType);
        renderType = VoxelMapRenderTypes.WAYPOINT_ICON_NO_DEPTHTEST.apply(icon.getResourceLocation());
        class_4588 vertexIconNoDepthtest = bufferSource.method_73477(renderType);
        vertexIconNoDepthtest.method_56824(poseStack.method_23760(), -width, -width, 0.0f).method_22913(icon.getMinU(), icon.getMinV()).method_22915(r, g, b, fadeNoDepth);
        vertexIconNoDepthtest.method_56824(poseStack.method_23760(), -width, width, 0.0f).method_22913(icon.getMinU(), icon.getMaxV()).method_22915(r, g, b, fadeNoDepth);
        vertexIconNoDepthtest.method_56824(poseStack.method_23760(), width, width, 0.0f).method_22913(icon.getMaxU(), icon.getMaxV()).method_22915(r, g, b, fadeNoDepth);
        vertexIconNoDepthtest.method_56824(poseStack.method_23760(), width, -width, 0.0f).method_22913(icon.getMaxU(), icon.getMinV()).method_22915(r, g, b, fadeNoDepth);
        bufferSource.method_22994(renderType);
        class_327 fontRenderer = this.minecraft.field_1772;
        if (isPointedAt) {
            int halfLabelWidth;
            boolean moveLabelDown = this.options.waypointNamesLocation == 1;
            Object distanceString = "";
            if (this.options.waypointNamesLocation == 0) {
                name = "";
            }
            if (this.options.waypointDistancesLocation != 0) {
                boolean shouldConvertUnit;
                boolean bl = shouldConvertUnit = this.options.distanceUnitConversionMode != 0 && (this.options.distanceUnitConversionMode == 1 && distance > 1000.0 || this.options.distanceUnitConversionMode == 2 && distance > 10000.0);
                if (shouldConvertUnit) {
                    double converted = distance / 1000.0;
                    distanceString = (int)converted + "." + (int)((converted - (double)((int)converted)) * 10.0) + "km";
                } else {
                    distanceString = (int)distance + "." + (int)((distance - (double)((int)distance)) * 10.0) + "m";
                }
                if (((String)name).isEmpty()) {
                    moveLabelDown = this.options.waypointDistancesLocation == 1;
                    name = distanceString;
                    distanceString = "";
                } else if (this.options.waypointDistancesLocation == 1) {
                    name = (String)name + " (" + (String)distanceString + ")";
                    distanceString = "";
                }
            }
            int textColor = (int)(255.0f * fade) << 24 | 0xFFFFFF;
            if (!((String)name).isEmpty()) {
                int elevateBy = moveLabelDown ? (((String)distanceString).isEmpty() ? -18 : -24) : 10;
                halfLabelWidth = fontRenderer.method_1727((String)name) / 2;
                renderType = VoxelMapRenderTypes.WAYPOINT_TEXT_BACKGROUND;
                class_4588 vertexBackground = bufferSource.method_73477(renderType);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfLabelWidth - 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfLabelWidth - 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfLabelWidth + 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfLabelWidth + 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfLabelWidth - 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfLabelWidth - 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfLabelWidth + 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfLabelWidth + 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                bufferSource.method_22994(renderType);
                fontRenderer.method_27522((class_2561)class_2561.method_43470((String)name), (float)(-fontRenderer.method_1727((String)name)) / 2.0f, (float)elevateBy, textColor, false, poseStack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
                bufferSource.method_37104();
            }
            if (!((String)distanceString).isEmpty()) {
                float labelScale = 0.75f;
                int elevateBy = moveLabelDown ? -20 : 26;
                halfLabelWidth = fontRenderer.method_1727((String)distanceString) / 2;
                poseStack.method_22903();
                poseStack.method_22905(labelScale, labelScale, 1.0f);
                class_4588 vertexBackground = bufferSource.method_73477(renderType);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfLabelWidth - 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfLabelWidth - 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfLabelWidth + 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfLabelWidth + 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfLabelWidth - 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(-halfLabelWidth - 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfLabelWidth + 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBackground.method_56824(poseStack.method_23760(), (float)(halfLabelWidth + 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                bufferSource.method_22994(renderType);
                fontRenderer.method_27522((class_2561)class_2561.method_43470((String)distanceString), (float)(-fontRenderer.method_1727((String)distanceString)) / 2.0f, (float)elevateBy, textColor, false, poseStack.method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33994, 0, 0xF000F0);
                bufferSource.method_37104();
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }

    public static class ExtendedWaypoint
    implements Comparable<ExtendedWaypoint> {
        public Waypoint waypoint;
        public double offset;
        public boolean target;

        public ExtendedWaypoint(Waypoint waypoint) {
            this.waypoint = waypoint;
        }

        @Override
        public int compareTo(ExtendedWaypoint o) {
            boolean skip2;
            boolean skip1 = this.offset == -1.0 || !this.waypoint.enabled && !this.target || !this.waypoint.inWorld || !this.waypoint.inDimension;
            boolean bl = skip2 = o.offset == -1.0 || !o.waypoint.enabled && !o.target || !o.waypoint.inWorld || !o.waypoint.inDimension;
            if (skip1 && !skip2) {
                return 1;
            }
            if (!skip1 && skip2) {
                return -1;
            }
            return Double.compare(this.offset, o.offset);
        }
    }
}

