/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.gui.GuiMobs;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.util.MobCategory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_6382;
import net.minecraft.class_7923;

class GuiSlotMobs
extends class_350<MobItem> {
    private final ArrayList<MobItem> mobs;
    private ArrayList<class_350.class_351<?>> mobsFiltered;
    final GuiMobs parentGui;
    static final class_2561 ENABLED = class_2561.method_43471((String)"options.minimap.mobs.enabled");
    static final class_2561 DISABLED = class_2561.method_43471((String)"options.minimap.mobs.disabled");
    static final class_2561 TOOLTIP_ENABLE = class_2561.method_43471((String)"options.minimap.mobs.enableTooltip");
    static final class_2561 TOOLTIP_DISABLE = class_2561.method_43471((String)"options.minimap.mobs.disableTooltip");
    final class_2960 visibleIconIdentifier = class_2960.method_60654((String)"textures/gui/sprites/container/beacon/confirm.png");
    final class_2960 invisibleIconIdentifier = class_2960.method_60654((String)"textures/gui/sprites/container/beacon/cancel.png");

    GuiSlotMobs(GuiMobs par1GuiMobs) {
        super(VoxelConstants.getMinecraft(), par1GuiMobs.getWidth(), par1GuiMobs.getHeight() - 110, 40, 18);
        this.parentGui = par1GuiMobs;
        this.mobs = new ArrayList();
        class_7923.field_41177.method_29722().forEach(entry -> {
            if (((class_1299)entry.getValue()).method_5883((class_1937)class_310.method_1551().field_1687, class_3730.field_52444) instanceof class_1309) {
                this.mobs.add(new MobItem(this.parentGui, (class_1299)entry.getValue(), ((class_5321)entry.getKey()).method_29177()));
            }
        });
        this.mobs.sort((mob1, mob2) -> {
            int dcat = mob1.category.compareTo(mob2.category);
            if (dcat != 0) {
                return dcat;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(mob1.nameString, mob2.nameString);
        });
        this.mobsFiltered = new ArrayList<MobItem>(this.mobs);
        this.mobsFiltered.forEach((Consumer<class_350.class_351<?>>)((Consumer<class_350.class_351>)x -> this.method_25321((MobItem)((Object)x))));
    }

    public void setSelected(MobItem entry) {
        super.method_25313((class_350.class_351)entry);
        if (this.method_25334() != null) {
            class_333 narratorManager = new class_333(VoxelConstants.getMinecraft());
            narratorManager.method_44708((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{((MobItem)this.method_25334()).name}));
        }
        this.parentGui.setSelectedMob(entry.id);
    }

    protected void updateFilter(String filterString) {
        this.method_25339();
        this.mobsFiltered = new ArrayList<MobItem>(this.mobs);
        Iterator<class_350.class_351<?>> iterator = this.mobsFiltered.iterator();
        while (iterator.hasNext()) {
            String mobName = ((MobItem)iterator.next()).nameString;
            if (mobName.toLowerCase().contains(filterString)) continue;
            if (mobName.equals(this.parentGui.selectedMobId)) {
                this.parentGui.setSelectedMob(null);
            }
            iterator.remove();
        }
        this.mobsFiltered.forEach((Consumer<class_350.class_351<?>>)((Consumer<class_350.class_351>)x -> this.method_25321((MobItem)((Object)x))));
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public class MobItem
    extends class_350.class_351<MobItem> {
        private final GuiMobs parentGui;
        private final class_1299<?> type;
        private final class_2960 id;
        private final class_2561 name;
        private final String nameString;
        private final MobCategory category;

        protected MobItem(GuiMobs mobsScreen, class_1299<?> type, class_2960 id) {
            this.type = type;
            this.parentGui = mobsScreen;
            this.id = id;
            this.name = type.method_5897();
            this.nameString = this.name.getString();
            this.category = MobCategory.forEntityType(type);
        }

        public void method_25343(class_332 drawContext, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Sprite sprite;
            boolean isHostile = this.category == MobCategory.HOSTILE;
            boolean isNeutral = !isHostile;
            boolean isEnabled = VoxelMap.radarOptions.isMobEnabled(this.type);
            int red = isHostile ? 255 : 0;
            int green = isNeutral ? 255 : 0;
            int color = -16777216 + (red << 16) + (green << 8);
            drawContext.method_27534(this.parentGui.method_64506(), this.name, this.parentGui.getWidth() / 2, this.method_46427() + 3, color);
            int padding = 3;
            if (mouseX >= this.method_46426() - padding && mouseY >= this.method_46427() && mouseX <= this.method_46426() + 215 + padding && mouseY <= this.method_46427() + GuiSlotMobs.this.field_62109) {
                class_2561 tooltip;
                if (mouseX >= this.method_46426() + 215 - 16 - padding && mouseX <= this.method_46426() + 215 + padding) {
                    drawContext.method_74037(class_11876.field_62455);
                    tooltip = isEnabled ? TOOLTIP_DISABLE : TOOLTIP_ENABLE;
                } else {
                    tooltip = isEnabled ? ENABLED : DISABLED;
                }
                GuiMobs.setTooltip(this.parentGui, tooltip);
            }
            if ((sprite = VoxelConstants.getVoxelMapInstance().getNotSimpleRadar().getEntityMapImageManager().requestImageForMobType(this.type, true)) != null) {
                sprite.blit(drawContext, class_10799.field_56883, this.method_46426() + 2, this.method_46427() - 2, 18.0f, 18.0f);
            }
            drawContext.method_25290(class_10799.field_56883, isEnabled ? GuiSlotMobs.this.visibleIconIdentifier : GuiSlotMobs.this.invisibleIconIdentifier, this.method_46426() + 198, this.method_46427() - 2, 0.0f, 0.0f, 18, 18, 18, 18);
        }

        public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
            double mouseX = mouseButtonEvent.comp_4798();
            double mouseY = mouseButtonEvent.comp_4799();
            if (mouseY < (double)GuiSlotMobs.this.method_46427() || mouseY > (double)GuiSlotMobs.this.method_55443()) {
                return false;
            }
            GuiSlotMobs.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                this.parentGui.toggleMobVisibility();
            }
            return true;
        }
    }
}

