/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.gui.GuiSlotDimensions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.IPopupGuiScreen;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_9848;

public class GuiAddWaypoint
extends GuiScreenMinimap
implements IPopupGuiScreen {
    private static final class_2960 PICKER = class_2960.method_60654((String)"voxelmap:images/colorpicker.png");
    private static final class_2960 TARGET = class_2960.method_60654((String)"voxelmap:images/waypoints/target.png");
    final WaypointManager waypointManager;
    final ColorManager colorManager;
    private final IGuiWaypoints parentGui;
    private PopupGuiButton doneButton;
    private GuiSlotDimensions dimensionList;
    protected DimensionContainer selectedDimension;
    private class_2561 tooltip;
    private class_342 waypointName;
    private class_342 waypointX;
    private class_342 waypointY;
    private class_342 waypointZ;
    private PopupGuiButton buttonEnabled;
    protected final Waypoint waypoint;
    private boolean choosingColor;
    private boolean choosingIcon;
    private final int colorPickerWidth = 200;
    private final int colorPickerHeight = 200;
    private final float red;
    private final float green;
    private final float blue;
    private final String suffix;
    private final boolean enabled;
    private final boolean editing;

    public GuiAddWaypoint(IGuiWaypoints par1GuiScreen, Waypoint par2Waypoint, boolean editing) {
        this.parentGui = par1GuiScreen;
        this.setParentScreen(this.parentGui);
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
        this.colorManager = VoxelConstants.getVoxelMapInstance().getColorManager();
        this.waypoint = par2Waypoint;
        this.red = this.waypoint.red;
        this.green = this.waypoint.green;
        this.blue = this.waypoint.blue;
        this.suffix = this.waypoint.imageSuffix;
        this.enabled = this.waypoint.enabled;
        this.editing = editing;
    }

    public void method_25393() {
    }

    public void method_25426() {
        this.method_37067();
        this.waypointName = new class_342(this.method_64506(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 13, 200, 20, null);
        this.waypointName.method_1852(this.waypoint.name);
        this.waypointX = new class_342(this.method_64506(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointX.method_1880(128);
        this.waypointX.method_1852(String.valueOf(this.waypoint.getX()));
        this.waypointY = new class_342(this.method_64506(), this.getWidth() / 2 - 28, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointY.method_1880(128);
        this.waypointY.method_1852(String.valueOf(this.waypoint.getY()));
        this.waypointZ = new class_342(this.method_64506(), this.getWidth() / 2 + 44, this.getHeight() / 6 + 41 + 13, 56, 20, null);
        this.waypointZ.method_1880(128);
        this.waypointZ.method_1852(String.valueOf(this.waypoint.getZ()));
        this.method_37063((class_364)this.waypointName);
        this.method_37063((class_364)this.waypointX);
        this.method_37063((class_364)this.waypointY);
        this.method_37063((class_364)this.waypointZ);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.buttonEnabled = new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY, 100, 20, (class_2561)class_2561.method_43470((String)("Enabled: " + (this.waypoint.enabled ? "On" : "Off"))), button -> {
            this.waypoint.enabled = !this.waypoint.enabled;
        }, this);
        this.method_37063((class_364)this.buttonEnabled);
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 24, 100, 20, (class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.sortByColor", (Object[])new Object[0]) + ":     ")), button -> {
            this.choosingColor = true;
        }, this));
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 - 101, buttonListY + 48, 100, 20, (class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.sortByIcon", (Object[])new Object[0]) + ":     ")), button -> {
            this.choosingIcon = true;
        }, this));
        this.doneButton = new PopupGuiButton(this.getWidth() / 2 - 155, this.getHeight() - 28, 150, 20, (class_2561)class_2561.method_43471((String)"gui.done"), button -> this.acceptWaypoint(), this);
        this.method_37063((class_364)this.doneButton);
        this.method_37063((class_364)new PopupGuiButton(this.getWidth() / 2 + 5, this.getHeight() - 28, 150, 20, (class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.cancelWaypoint(), this));
        this.doneButton.field_22763 = !this.waypointName.method_1882().isEmpty();
        this.method_25395((class_364)this.waypointName);
        this.waypointName.method_25365(true);
        this.dimensionList = new GuiSlotDimensions(this);
        this.method_37063((class_364)this.dimensionList);
    }

    @Override
    public void method_25432() {
    }

    protected void cancelWaypoint() {
        this.waypoint.red = this.red;
        this.waypoint.green = this.green;
        this.waypoint.blue = this.blue;
        this.waypoint.imageSuffix = this.suffix;
        this.waypoint.enabled = this.enabled;
        if (this.parentGui != null) {
            this.parentGui.accept(false);
            return;
        }
        VoxelConstants.getMinecraft().method_1507(null);
    }

    protected void acceptWaypoint() {
        this.waypoint.name = this.waypointName.method_1882();
        this.waypoint.setX(Integer.parseInt(this.waypointX.method_1882()));
        this.waypoint.setY(Integer.parseInt(this.waypointY.method_1882()));
        this.waypoint.setZ(Integer.parseInt(this.waypointZ.method_1882()));
        if (this.parentGui != null) {
            this.parentGui.accept(true);
            return;
        }
        if (this.editing) {
            this.waypointManager.saveWaypoints();
            VoxelConstants.getMinecraft().method_1507(null);
            return;
        }
        this.waypointManager.addWaypoint(this.waypoint);
        VoxelConstants.getMinecraft().method_1507(null);
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        int keyCode = keyEvent.comp_4795();
        boolean OK = false;
        if (!this.popupOpen()) {
            OK = super.method_25404(keyEvent);
            boolean acceptable = !this.waypointName.method_1882().isEmpty();
            try {
                Integer.parseInt(this.waypointX.method_1882());
                Integer.parseInt(this.waypointY.method_1882());
                Integer.parseInt(this.waypointZ.method_1882());
            }
            catch (NumberFormatException var7) {
                acceptable = false;
            }
            this.doneButton.field_22763 = acceptable;
            if ((keyCode == 257 || keyCode == 335) && acceptable) {
                this.acceptWaypoint();
            }
        }
        return OK;
    }

    public boolean method_25400(class_11905 characterEvent) {
        boolean OK = false;
        if (!this.popupOpen()) {
            OK = super.method_25400(characterEvent);
            boolean acceptable = !this.waypointName.method_1882().isEmpty();
            try {
                Integer.parseInt(this.waypointX.method_1882());
                Integer.parseInt(this.waypointY.method_1882());
                Integer.parseInt(this.waypointZ.method_1882());
            }
            catch (NumberFormatException var6) {
                acceptable = false;
            }
            this.doneButton.field_22763 = acceptable;
        }
        return OK;
    }

    @Override
    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        int pickedColor;
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        int button = mouseButtonEvent.method_74245();
        if (!this.popupOpen()) {
            return super.method_25402(mouseButtonEvent, doubleClick);
        }
        if (this.choosingColor && button == 0 && (pickedColor = this.pickColor(200, 200, (int)mouseX, (int)mouseY)) != -1) {
            this.waypoint.red = (float)class_9848.method_61327((int)pickedColor) / 255.0f;
            this.waypoint.green = (float)class_9848.method_61329((int)pickedColor) / 255.0f;
            this.waypoint.blue = (float)class_9848.method_61331((int)pickedColor) / 255.0f;
            this.choosingColor = false;
        }
        if (this.choosingIcon && button == 0) {
            TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
            Sprite pickedIcon = this.pickIcon((int)mouseX, (int)mouseY);
            if (pickedIcon != chooser.getMissingImage()) {
                this.waypoint.imageSuffix = ((String)pickedIcon.getIconName()).replace("voxelmap:images/waypoints/waypoint", "").replace(".png", "");
                this.choosingIcon = false;
            }
        }
        return false;
    }

    public boolean method_25406(class_11909 mouseButtonEvent) {
        return !this.popupOpen() && super.method_25406(mouseButtonEvent);
    }

    public boolean method_25403(class_11909 mouseButtonEvent, double deltaX, double deltaY) {
        return !this.popupOpen() && super.method_25403(mouseButtonEvent, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double amount) {
        return !this.popupOpen() && super.method_25401(mouseX, mouseY, horizontalAmount, amount);
    }

    @Override
    public boolean overPopup(int mouseX, int mouseY) {
        return this.choosingColor || this.choosingIcon;
    }

    @Override
    public boolean popupOpen() {
        return this.choosingColor || this.choosingIcon;
    }

    @Override
    public void popupAction(Popup popup, int action) {
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        this.buttonEnabled.method_25355((class_2561)class_2561.method_43470((String)(class_1074.method_4662((String)"minimap.waypoints.enabled", (Object[])new Object[0]) + " " + (this.waypoint.enabled ? class_1074.method_4662((String)"options.on", (Object[])new Object[0]) : class_1074.method_4662((String)"options.off", (Object[])new Object[0])))));
        drawContext.method_25300(this.method_64506(), (this.parentGui == null || !this.parentGui.isEditing()) && !this.editing ? class_1074.method_4662((String)"minimap.waypoints.new", (Object[])new Object[0]) : class_1074.method_4662((String)"minimap.waypoints.edit", (Object[])new Object[0]), this.getWidth() / 2, 20, -1);
        drawContext.method_25303(this.method_64506(), class_1074.method_4662((String)"minimap.waypoints.name", (Object[])new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6, -1);
        drawContext.method_25303(this.method_64506(), "X", this.getWidth() / 2 - 100, this.getHeight() / 6 + 41, -1);
        drawContext.method_25303(this.method_64506(), "Y", this.getWidth() / 2 - 28, this.getHeight() / 6 + 41, -1);
        drawContext.method_25303(this.method_64506(), "Z", this.getWidth() / 2 + 44, this.getHeight() / 6 + 41, -1);
        super.method_25394(drawContext, this.popupOpen() ? 0 : mouseX, this.popupOpen() ? 0 : mouseY, delta);
        int buttonListY = this.getHeight() / 6 + 88;
        int color = this.waypoint.getUnifiedColor();
        drawContext.method_25294(this.getWidth() / 2 - 25, buttonListY + 24 + 5, this.getWidth() / 2 - 25 + 16, buttonListY + 24 + 5 + 10, color);
        this.waypointManager.getTextureAtlasChooser().getAtlasSprite("voxelmap:images/waypoints/waypoint" + this.waypoint.imageSuffix + ".png").blit(drawContext, class_10799.field_56883, this.getWidth() / 2 - 25, buttonListY + 48 + 2, 16.0f, 16.0f, color);
        if (this.choosingColor || this.choosingIcon) {
            this.method_52752(drawContext);
            if (this.choosingColor) {
                int anchorX = this.getWidth() / 2 - 100;
                int anchorY = this.getHeight() / 2 - 100;
                drawContext.method_25290(class_10799.field_56883, PICKER, anchorX, anchorY, 0.0f, 0.0f, 200, 200, 200, 200);
                int pickedColor = this.pickColor(200, 200, mouseX, mouseY);
                if (pickedColor != -1) {
                    int red = class_9848.method_61327((int)pickedColor);
                    int green = class_9848.method_61329((int)pickedColor);
                    int blue = class_9848.method_61331((int)pickedColor);
                    drawContext.method_25290(class_10799.field_56883, TARGET, mouseX - 8, mouseY - 8, 0.0f, 0.0f, 16, 16, 16, 16);
                    drawContext.method_25300(this.method_64506(), "R: " + red + ", G: " + green + ", B: " + blue, this.getWidth() / 2, this.getHeight() / 2 + 100 + 8, pickedColor);
                }
            }
            if (this.choosingIcon) {
                TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
                int anchorX = (int)((float)this.getWidth() / 2.0f - (float)chooser.getWidth() / 2.0f);
                int anchorY = (int)((float)this.getHeight() / 2.0f - (float)chooser.getHeight() / 2.0f);
                drawContext.method_25291(class_10799.field_56883, WaypointManager.resourceTextureAtlasWaypointChooser, anchorX, anchorY, 0.0f, 0.0f, chooser.getWidth(), chooser.getHeight(), chooser.getWidth(), chooser.getHeight(), -3618616);
                Sprite pickedIcon = this.pickIcon(mouseX, mouseY);
                if (pickedIcon != chooser.getMissingImage()) {
                    int iconPreviewX = pickedIcon.getOriginX() + anchorX;
                    int iconPreviewY = pickedIcon.getOriginY() + anchorY;
                    pickedIcon.blit(drawContext, class_10799.field_56883, iconPreviewX - 4, iconPreviewY - 4, 40.0f, 40.0f, color);
                    this.tooltip = class_2561.method_43471((String)((String)pickedIcon.getIconName()).replace("voxelmap:images/waypoints/", "minimap.waypoints.").replace(".png", ""));
                }
            }
        }
        if (this.tooltip != null) {
            this.renderTooltip(drawContext, this.tooltip, mouseX, mouseY);
        }
    }

    private int pickColor(int width, int height, int mouseX, int mouseY) {
        int anchorX = (int)((float)this.getWidth() / 2.0f - (float)width / 2.0f);
        int anchorY = (int)((float)this.getHeight() / 2.0f - (float)height / 2.0f);
        if (mouseX >= anchorX && mouseX <= anchorX + width && mouseY >= anchorY && mouseY <= anchorY + height) {
            int pickPointX = (int)((float)(mouseX - anchorX) / (float)width * 255.0f);
            int pickPointY = (int)((float)(mouseY - anchorY) / (float)height * 255.0f);
            return this.colorManager.getColorPicker().getRGB(pickPointX, pickPointY);
        }
        return -1;
    }

    private Sprite pickIcon(int mouseX, int mouseY) {
        TextureAtlas chooser = this.waypointManager.getTextureAtlasChooser();
        int anchorX = (int)((float)this.getWidth() / 2.0f - (float)chooser.getWidth() / 2.0f);
        int anchorY = (int)((float)this.getHeight() / 2.0f - (float)chooser.getHeight() / 2.0f);
        return chooser.getIconAt(mouseX - anchorX, mouseY - anchorY);
    }

    public void setSelectedDimension(DimensionContainer dimension) {
        this.selectedDimension = dimension;
    }

    public void toggleDimensionSelected() {
        if (this.waypoint.dimensions.size() > 1 && this.waypoint.dimensions.contains(this.selectedDimension) && this.selectedDimension != VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_73183())) {
            this.waypoint.dimensions.remove(this.selectedDimension);
        } else {
            this.waypoint.dimensions.add(this.selectedDimension);
        }
    }

    static void setTooltip(GuiAddWaypoint par0GuiWaypoint, class_2561 par1Str) {
        par0GuiWaypoint.tooltip = par1Str;
    }
}

