/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity.ai.firefly;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.entity.Firefly;
import net.frozenblock.wilderwild.entity.ai.ValidateOrSetHome;
import net.frozenblock.wilderwild.entity.ai.firefly.FireflyHide;
import net.frozenblock.wilderwild.entity.ai.firefly.FireflyMoveToBush;
import net.frozenblock.wilderwild.registry.WWMemoryModuleTypes;
import net.frozenblock.wilderwild.registry.WWSensorTypes;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4095;
import net.minecraft.class_4099;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4115;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4818;
import net.minecraft.class_5321;
import net.minecraft.class_5753;
import net.minecraft.class_7297;
import org.jetbrains.annotations.NotNull;

public class FireflyAi {
    protected static final List<class_4149<? extends class_4148<? super Firefly>>> SENSOR_TYPES = List.of(class_4149.field_18466, WWSensorTypes.FIREFLY_SPECIFIC_SENSOR, WWSensorTypes.FIREFLY_LEADER_SENSOR);
    protected static final List<class_4140<?>> MEMORY_TYPES = List.of(class_4140.field_18449, class_4140.field_18441, class_4140.field_18442, class_4140.field_18445, class_4140.field_19293, class_4140.field_18446, class_4140.field_18438, WWMemoryModuleTypes.NEARBY_FIREFLIES, WWMemoryModuleTypes.NATURAL, WWMemoryModuleTypes.HOME_VALIDATE_COOLDOWN, WWMemoryModuleTypes.IS_SWARM_LEADER, WWMemoryModuleTypes.SWARM_LEADER_TRACKER);

    private FireflyAi() {
    }

    public static void setNatural(@NotNull Firefly firefly) {
        firefly.method_18868().method_18878(WWMemoryModuleTypes.NATURAL, (Object)true);
    }

    public static void setSwarmLeader(@NotNull Firefly firefly) {
        firefly.method_18868().method_18878(WWMemoryModuleTypes.IS_SWARM_LEADER, (Object)true);
    }

    @NotNull
    public static class_4095.class_5303<Firefly> brainProvider() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    public static class_4095<?> makeBrain(@NotNull Firefly firefly, @NotNull class_4095<Firefly> brain) {
        FireflyAi.addCoreActivities(brain);
        FireflyAi.addIdleActivities(firefly, brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(@NotNull class_4095<Firefly> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4110(45, 90), (Object)new class_4112(), ValidateOrSetHome.create(), (Object)new class_5753(WWMemoryModuleTypes.HOME_VALIDATE_COOLDOWN)));
    }

    private static void addIdleActivities(@NotNull Firefly firefly, @NotNull class_4095<Firefly> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)1, (Object)((Object)new FireflyHide(firefly, 1.75, 10, 8))), (Object)Pair.of((Object)2, (Object)((Object)new FireflyMoveToBush(firefly, 1.25, 10, 8, 5))), (Object)Pair.of((Object)3, (Object)class_7297.method_47130(FireflyAi::getHomeTarget, entity -> true, (int)7, (int)16, (float)1.25f)), (Object)Pair.of((Object)4, (Object)class_7297.method_47130(FireflyAi::getSwarmLeaderTarget, entity -> WWEntityConfig.FIREFLY_SWARMS, (int)2, (int)3, (float)1.75f)), (Object)Pair.of((Object)5, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47025((float)1.25f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)1.25f, (int)3), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))))));
    }

    public static void updateActivities(@NotNull Firefly firefly) {
        firefly.method_18868().method_24531(List.of(class_4168.field_18595));
    }

    public static void rememberHome(@NotNull class_1309 firefly, @NotNull class_2338 pos) {
        firefly.method_18868().method_18878(class_4140.field_18438, (Object)class_4208.method_19443((class_5321)firefly.method_73183().method_27983(), (class_2338)pos));
    }

    private static boolean shouldGoTowardsHome(@NotNull class_1309 firefly, @NotNull class_4208 pos) {
        return ((Firefly)firefly).method_18410() && firefly.method_73183().method_27983() == pos.comp_2207() && !((Firefly)firefly).shouldHide();
    }

    @NotNull
    private static Optional<class_4115> getSwarmLeaderTarget(@NotNull class_1309 firefly) {
        return !((Firefly)firefly).method_18410() ? firefly.method_18868().method_18904(WWMemoryModuleTypes.SWARM_LEADER_TRACKER) : Optional.empty();
    }

    @NotNull
    private static Optional<class_4115> getHomeTarget(@NotNull class_1309 firefly) {
        class_4208 globalPos;
        Optional home = firefly.method_18868().method_18904(class_4140.field_18438);
        if (home.isPresent() && FireflyAi.shouldGoTowardsHome(firefly, globalPos = (class_4208)home.get())) {
            return Optional.of(new class_4099(FireflyAi.randomPosAround(globalPos.comp_2208(), firefly.method_73183())));
        }
        return Optional.empty();
    }

    @NotNull
    private static class_2338 randomPosAround(@NotNull class_2338 pos, @NotNull class_1937 level) {
        return pos.method_10069(level.field_9229.method_39332(-7, 7), level.field_9229.method_39332(-7, 7), level.field_9229.method_39332(-7, 7));
    }

    public static List<Firefly> getNearbyFirefliesInRank(@NotNull Firefly firefly, boolean searchingForLeader) {
        return new ArrayList((Collection)firefly.method_18868().method_18904(WWMemoryModuleTypes.NEARBY_FIREFLIES).orElse(ImmutableList.of())).stream().filter(otherFirefly -> otherFirefly.isSwarmLeader() == searchingForLeader).sorted(Comparator.comparingDouble(arg_0 -> ((Firefly)firefly).method_5858(arg_0))).toList();
    }

    public static void transferLeadershipToRandomFirefly(@NotNull Firefly firefly) {
        class_4095<Firefly> brain = firefly.method_18868();
        List<Firefly> nonLeaderFireflies = FireflyAi.getNearbyFirefliesInRank(firefly, false);
        if (!nonLeaderFireflies.isEmpty()) {
            FireflyAi.transferLeadershipTo(firefly, nonLeaderFireflies.getFirst());
            return;
        }
        brain.method_18875(WWMemoryModuleTypes.IS_SWARM_LEADER);
    }

    private static void transferLeadershipTo(@NotNull Firefly firefly, Firefly newLeader) {
        FireflyAi.setSwarmLeader(newLeader);
        firefly.method_18868().method_18875(WWMemoryModuleTypes.IS_SWARM_LEADER);
    }
}

